/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.models.AdminRoles;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.testframework.admin.AdminClientFactory;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectAdminClientFactory;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest(config=PermissionsTestServerConfig.class)
public class AbstractPermissionsTest {
    @InjectRealm(attachTo="master", ref="masterRealm")
    ManagedRealm managedMasterRealm;
    @InjectAdminClientFactory
    protected AdminClientFactory adminClientFactory;
    @InjectAdminClient
    protected Keycloak adminClient;
    protected static final String REALM_NAME = "permissions-test";
    protected static final String REALM_2_NAME = "realm2";
    protected Map<String, Keycloak> clients = new HashMap<String, Keycloak>();

    @BeforeEach
    public void beforeEach() {
        Response response = this.managedMasterRealm.admin().users().create(UserConfigBuilder.create().username("permissions-test-master-none").password("password").build());
        String userUuid = ApiUtil.getCreatedId((Response)response);
        this.managedMasterRealm.cleanup().add(r -> r.users().delete(userUuid));
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            response = this.managedMasterRealm.admin().users().create(UserConfigBuilder.create().username("permissions-test-master-" + role).password("password").build());
            String roleUserUuid = ApiUtil.getCreatedId((Response)response);
            this.managedMasterRealm.cleanup().add(r -> r.users().delete(roleUserUuid));
            String clientUuid = ((ClientRepresentation)this.managedMasterRealm.admin().clients().findByClientId("permissions-test-realm").get(0)).getId();
            RoleRepresentation roleRep = this.managedMasterRealm.admin().clients().get(clientUuid).roles().get(role).toRepresentation();
            this.managedMasterRealm.admin().users().get(roleUserUuid).roles().clientLevel(clientUuid).add(Collections.singletonList(roleRep));
        }
        this.clients.put("realm-admin", this.adminClientFactory.create().realm(REALM_NAME).username("realm-admin").password("password").clientId("test-client").clientSecret("secret").build());
        this.clients.put("none", this.adminClientFactory.create().realm(REALM_NAME).username("none").password("password").clientId("test-client").clientSecret("secret").build());
        this.clients.put("multi", this.adminClientFactory.create().realm(REALM_NAME).username("multi").password("password").clientId("test-client").clientSecret("secret").build());
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            this.clients.put(role, this.adminClientFactory.create().realm(REALM_NAME).username(role).password("password").clientId("test-client").build());
        }
        this.clients.put("REALM2", this.adminClientFactory.create().realm(REALM_2_NAME).username("admin").password("password").clientId("test-client").build());
        this.clients.put("master-admin", this.adminClient);
        this.clients.put("master-none", this.adminClientFactory.create().realm("master").username("permissions-test-master-none").password("password").clientId("admin-cli").build());
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            this.clients.put("master-" + role, this.adminClientFactory.create().realm("master").username("permissions-test-master-" + role).password("password").clientId("admin-cli").build());
        }
    }

    protected void invoke(Invocation invocation, AdminAuth.Resource resource, boolean manage) {
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> invocation.invoke(realm), resource, manage);
    }

    protected void invoke(Invocation invocation, AdminAuth.Resource resource, boolean manage, boolean skipDifferentRole) {
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> invocation.invoke(realm), resource, manage, skipDifferentRole);
    }

    protected void invoke(InvocationWithResponse invocation, AdminAuth.Resource resource, boolean manage) {
        this.invoke(invocation, resource, manage, false);
    }

    protected void invoke(InvocationWithResponse invocation, AdminAuth.Resource resource, boolean manage, boolean skipDifferentRole) {
        String viewRole = this.getViewRole(resource);
        String manageRole = this.getManageRole(resource);
        String differentViewRole = this.getDifferentViewRole(resource);
        String differentManageRole = this.getDifferentManageRole(resource);
        this.invoke(invocation, this.clients.get("master-none"), false);
        this.invoke(invocation, this.clients.get("master-admin"), true);
        this.invoke(invocation, this.clients.get("master-" + viewRole), !manage);
        this.invoke(invocation, this.clients.get("master-" + manageRole), true);
        if (!skipDifferentRole) {
            this.invoke(invocation, this.clients.get("master-" + differentViewRole), false);
            this.invoke(invocation, this.clients.get("master-" + differentManageRole), false);
        }
        this.invoke(invocation, this.clients.get("none"), false);
        this.invoke(invocation, this.clients.get("realm-admin"), true);
        this.invoke(invocation, this.clients.get(viewRole), !manage);
        this.invoke(invocation, this.clients.get(manageRole), true);
        if (!skipDifferentRole) {
            this.invoke(invocation, this.clients.get(differentViewRole), false);
            this.invoke(invocation, this.clients.get(differentManageRole), false);
        }
        this.invoke(invocation, this.clients.get("REALM2"), false);
    }

    protected void invoke(Invocation invocation, Keycloak client, boolean expectSuccess) {
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> invocation.invoke(realm), client, expectSuccess);
    }

    protected void invoke(InvocationWithResponse invocation, Keycloak client, boolean expectSuccess) {
        int statusCode;
        try {
            AtomicReference<Response> responseReference = new AtomicReference<Response>();
            invocation.invoke(client.realm(REALM_NAME), responseReference);
            Response response = responseReference.get();
            statusCode = response != null ? response.getStatus() : 200;
        }
        catch (ClientErrorException e) {
            statusCode = e.getResponse().getStatus();
        }
        if (expectSuccess) {
            if (statusCode != 200 && statusCode != 201 && statusCode != 204 && statusCode != 404 && statusCode != 409 && statusCode != 400) {
                Assertions.fail((String)("Expected permitted, but was " + statusCode));
            }
        } else if (statusCode != 403) {
            Assertions.fail((String)("Expected 403, but was " + statusCode));
        }
    }

    private String getViewRole(AdminAuth.Resource resource) {
        return switch (resource) {
            case AdminAuth.Resource.CLIENT -> "view-clients";
            case AdminAuth.Resource.USER -> "view-users";
            case AdminAuth.Resource.REALM -> "view-realm";
            case AdminAuth.Resource.EVENTS -> "view-events";
            case AdminAuth.Resource.IDENTITY_PROVIDER -> "view-identity-providers";
            case AdminAuth.Resource.AUTHORIZATION -> "view-authorization";
            default -> throw new RuntimeException("Unexpected resource");
        };
    }

    private String getManageRole(AdminAuth.Resource resource) {
        return switch (resource) {
            case AdminAuth.Resource.CLIENT -> "manage-clients";
            case AdminAuth.Resource.USER -> "manage-users";
            case AdminAuth.Resource.REALM -> "manage-realm";
            case AdminAuth.Resource.EVENTS -> "manage-events";
            case AdminAuth.Resource.IDENTITY_PROVIDER -> "manage-identity-providers";
            case AdminAuth.Resource.AUTHORIZATION -> "manage-authorization";
            default -> throw new RuntimeException("Unexpected resource");
        };
    }

    private String getDifferentViewRole(AdminAuth.Resource resource) {
        return switch (resource) {
            case AdminAuth.Resource.CLIENT -> "view-users";
            case AdminAuth.Resource.USER -> "view-clients";
            case AdminAuth.Resource.REALM -> "view-events";
            case AdminAuth.Resource.EVENTS, AdminAuth.Resource.AUTHORIZATION -> "view-identity-providers";
            case AdminAuth.Resource.IDENTITY_PROVIDER -> "view-realm";
            default -> throw new RuntimeException("Unexpected resouce");
        };
    }

    private String getDifferentManageRole(AdminAuth.Resource resource) {
        return switch (resource) {
            case AdminAuth.Resource.CLIENT -> "manage-users";
            case AdminAuth.Resource.USER -> "manage-clients";
            case AdminAuth.Resource.REALM -> "manage-events";
            case AdminAuth.Resource.EVENTS, AdminAuth.Resource.AUTHORIZATION -> "manage-identity-providers";
            case AdminAuth.Resource.IDENTITY_PROVIDER -> "manage-realm";
            default -> throw new RuntimeException("Unexpected resouce");
        };
    }

    protected static interface Invocation {
        public void invoke(RealmResource var1);
    }

    protected static interface InvocationWithResponse {
        public void invoke(RealmResource var1, AtomicReference<Response> var2);
    }

    protected static class PermissionsTestRealmConfig2
    implements RealmConfig {
        protected PermissionsTestRealmConfig2() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.name(AbstractPermissionsTest.REALM_2_NAME);
            realm.addClient("test-client").publicClient(true).directAccessGrantsEnabled(true);
            realm.addUser("admin").name("admin", "admin").email("admin@localhost.com").password("password").clientRoles("realm-management", new String[]{"realm-admin"});
            return realm;
        }
    }

    protected static class PermissionsTestRealmConfig1
    implements RealmConfig {
        protected PermissionsTestRealmConfig1() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.name(AbstractPermissionsTest.REALM_NAME);
            realm.addClient("test-client").enabled(true).publicClient(true).directAccessGrantsEnabled(true);
            realm.addUser("realm-admin").name("realm-admin", "realm-admin").email("realmadmin@localhost.com").password("password").clientRoles("realm-management", new String[]{"realm-admin"});
            realm.addUser("multi").name("multi", "multi").email("multi@localhost.com").password("password").clientRoles("realm-management", new String[]{"query-groups", "manage-realm", "view-clients"});
            realm.addUser("none").name("none", "none").email("none@localhost.com").password("password");
            for (String role : AdminRoles.ALL_REALM_ROLES) {
                realm.addUser(role).name(role, role).email(role + "@localhost.com").password("password").clientRoles("realm-management", new String[]{role});
            }
            realm.addUser("admin").name("admin", "admin").email("admin@localhost.com").password("password").clientRoles("realm-management", new String[]{"realm-admin"});
            realm.smtp("localhost", Integer.parseInt("3025"), "server@mail.test");
            return realm;
        }
    }

    static class PermissionsTestServerConfig
    implements KeycloakServerConfig {
        PermissionsTestServerConfig() {
        }

        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.features(new Profile.Feature[]{Profile.Feature.AUTHORIZATION});
        }
    }
}

