/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectHttpClient;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

@KeycloakIntegrationTest
public class AdminConsoleWhoAmILocaleTest {
    @InjectRealm(ref="master", attachTo="master")
    ManagedRealm masterRealm;
    @InjectRealm(ref="realm-i18n-off", config=LocaleOffRealmConfig.class)
    ManagedRealm managedRealmOff;
    @InjectRealm(ref="realm-i18n-on", config=LocaleOnRealmConfig.class)
    ManagedRealm managedRealmOn;
    @InjectUser(realmRef="master", config=MasterAdminUserConfig.class)
    ManagedUser masterAdmin;
    @InjectClient(realmRef="master", config=MasterAdminClientConfig.class)
    ManagedClient masterClient;
    @InjectOAuthClient(ref="master", realmRef="master")
    OAuthClient oAuthClientMaster;
    @InjectOAuthClient(ref="locale-off", realmRef="realm-i18n-off")
    OAuthClient oAuthClientLocaleOff;
    @InjectOAuthClient(ref="locale-on", realmRef="realm-i18n-on")
    OAuthClient oAuthClientLocaleOn;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;
    @InjectHttpClient
    CloseableHttpClient client;
    private static final String REALM_I18N_OFF = "realm-i18n-off";
    private static final String REALM_I18N_ON = "realm-i18n-on";
    private static final String USER_WITHOUT_LOCALE = "user-without-locale";
    private static final String USER_WITH_LOCALE = "user-with-locale";
    private static final String USER_NO_ACCESS = "user-no-access";
    private static final String PASSWORD = "password";
    private static final String ADMIN_CLI_NOT_ALLOWED = "admin-cli-not-allowed";
    private static final String SECRET = "secret";
    private static final String DEFAULT_LOCALE = "en";
    private static final String REALM_LOCALE = "no";
    private static final String USER_LOCALE = "de";
    private static final String EXTRA_LOCALE = "zh-CN";

    @Test
    public void testLocaleRealmI18nDisabledUserWithoutLocale() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOff, "admin-cli", SECRET, USER_WITHOUT_LOCALE, PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.managedRealmOff), response, new Header[0]);
        Assertions.assertEquals((Object)REALM_I18N_OFF, (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)DEFAULT_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(REALM_I18N_OFF, whoAmI);
        this.oAuthClientLocaleOff.doLogout(response.getRefreshToken());
    }

    @Test
    public void testLocaleRealmI18nDisabledUserWithLocale() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOff, "admin-cli", SECRET, USER_WITH_LOCALE, PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.managedRealmOff), response, new Header[0]);
        Assertions.assertEquals((Object)REALM_I18N_OFF, (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)DEFAULT_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(REALM_I18N_OFF, whoAmI);
        this.oAuthClientLocaleOff.doLogout(response.getRefreshToken());
    }

    @Test
    public void testLocaleRealmI18nEnabledUserWithoutLocale() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOn, "admin-cli", SECRET, USER_WITHOUT_LOCALE, PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.managedRealmOn), response, new Header[0]);
        Assertions.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)REALM_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(REALM_I18N_ON, whoAmI);
        this.oAuthClientLocaleOn.doLogout(response.getRefreshToken());
    }

    @Test
    public void testLocaleRealmI18nEnabledUserWithLocale() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOn, "admin-cli", SECRET, USER_WITH_LOCALE, PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.managedRealmOn), response, new Header[0]);
        Assertions.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)USER_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(REALM_I18N_ON, whoAmI);
        this.oAuthClientLocaleOn.doLogout(response.getRefreshToken());
    }

    @Test
    public void testLocaleRealmI18nEnabledAcceptLanguageHeader() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOn, "admin-cli", SECRET, USER_WITHOUT_LOCALE, PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.managedRealmOn), response, new Header[]{new BasicHeader("Accept-Language", EXTRA_LOCALE)});
        Assertions.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)EXTRA_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(REALM_I18N_ON, whoAmI);
        this.oAuthClientLocaleOn.doLogout(response.getRefreshToken());
    }

    @Test
    public void testLocaleRealmI18nEnabledKeycloakLocaleCookie() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOn, "admin-cli", SECRET, USER_WITHOUT_LOCALE, PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.managedRealmOn), response, new Header[]{new BasicHeader("Cookie", "KEYCLOAK_LOCALE=zh-CN")});
        Assertions.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)EXTRA_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(REALM_I18N_ON, whoAmI);
        this.oAuthClientLocaleOn.doLogout(response.getRefreshToken());
    }

    @Test
    public void testMasterRealm() throws Exception {
        this.updateMasterAdminRole();
        AccessTokenResponse response = this.accessToken(this.oAuthClientMaster, this.masterClient.getClientId(), SECRET, this.masterAdmin.getUsername(), PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.masterRealm), response, new Header[0]);
        Assertions.assertEquals((Object)this.masterRealm.getName(), (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)DEFAULT_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(this.masterRealm.getName(), whoAmI);
        this.oAuthClientMaster.doLogout(response.getRefreshToken());
    }

    @Test
    public void testMasterRealmCurrentRealm() throws Exception {
        this.updateMasterAdminRole();
        AccessTokenResponse response = this.accessToken(this.oAuthClientMaster, this.masterClient.getClientId(), SECRET, this.masterAdmin.getUsername(), PASSWORD);
        JsonNode whoAmI = this.getHttpJsonResponse(this.whoAmiUrl(this.masterRealm, REALM_I18N_ON), response, new Header[0]);
        Assertions.assertEquals((Object)this.masterRealm.getName(), (Object)whoAmI.get("realm").asText());
        Assertions.assertEquals((Object)DEFAULT_LOCALE, (Object)whoAmI.get("locale").asText());
        this.checkRealmAccess(REALM_I18N_ON, whoAmI);
        this.oAuthClientMaster.doLogout(response.getRefreshToken());
    }

    @Test
    public void testLocaleRealmNoToken() throws Exception {
        HttpGet httpGet = new HttpGet(this.whoAmiUrl(this.managedRealmOn));
        httpGet.addHeader("Accept", "application/json");
        CloseableHttpResponse httpGetResponse = this.client.execute((HttpUriRequest)httpGet);
        Assertions.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)httpGetResponse.getStatusLine().getStatusCode());
        httpGetResponse.close();
    }

    @Test
    public void testLocaleRealmUserNoAccess() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOn, "admin-cli", SECRET, USER_NO_ACCESS, PASSWORD);
        HttpGet httpGet = new HttpGet(this.whoAmiUrl(this.managedRealmOn));
        httpGet.addHeader("Accept", "application/json");
        httpGet.addHeader("Authorization", "Bearer " + response.getAccessToken());
        CloseableHttpResponse httpGetResponse = this.client.execute((HttpUriRequest)httpGet);
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)httpGetResponse.getStatusLine().getStatusCode());
        httpGetResponse.close();
        this.oAuthClientLocaleOn.doLogout(response.getRefreshToken());
    }

    @Test
    public void testLocaleRealmTokenAdminNotAllowed() throws Exception {
        AccessTokenResponse response = this.accessToken(this.oAuthClientLocaleOn, ADMIN_CLI_NOT_ALLOWED, SECRET, USER_WITH_LOCALE, PASSWORD);
        Assertions.assertNotNull((Object)response.getAccessToken());
        HttpGet httpGet = new HttpGet(this.whoAmiUrl(this.managedRealmOn));
        httpGet.addHeader("Accept", "application/json");
        httpGet.addHeader("Authorization", "Bearer " + response.getAccessToken());
        CloseableHttpResponse httpGetResponse = this.client.execute((HttpUriRequest)httpGet);
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)httpGetResponse.getStatusLine().getStatusCode());
        httpGetResponse.close();
    }

    private void updateMasterAdminRole() {
        RoleRepresentation roleRep = this.masterRealm.admin().roles().get("admin").toRepresentation();
        this.masterRealm.admin().users().get(this.masterAdmin.getId()).roles().realmLevel().add(List.of(roleRep));
    }

    private AccessTokenResponse accessToken(OAuthClient oAuth, String clientId, String clientSecret, String username, String password) {
        return ((OAuthClient)oAuth.client(clientId, clientSecret)).doPasswordGrantRequest(username, password);
    }

    private JsonNode getHttpJsonResponse(String url, AccessTokenResponse response, Header ... headers) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Accept", "application/json");
        httpGet.addHeader("Authorization", "Bearer " + response.getAccessToken());
        for (Header header : headers) {
            httpGet.addHeader(header.getName(), header.getValue());
        }
        return new ObjectMapper().readTree(this.client.execute((HttpUriRequest)httpGet).getEntity().getContent());
    }

    private String whoAmiUrl(ManagedRealm realm) {
        return this.whoAmiUrl(realm, null);
    }

    private String whoAmiUrl(ManagedRealm realm, String currentRealm) {
        StringBuilder sb = new StringBuilder().append(this.keycloakUrls.getBaseUrl()).append("/admin/").append(realm.getName()).append("/console/whoami");
        if (currentRealm != null) {
            sb.append("?currentRealm=").append(currentRealm);
        }
        return sb.toString();
    }

    private void checkRealmAccess(String realm, JsonNode whoAmI) {
        Assertions.assertNotNull((Object)whoAmI.get("realm_access"));
        Assertions.assertNotNull((Object)whoAmI.get("realm_access").get(realm));
        Assertions.assertTrue((boolean)whoAmI.get("realm_access").get(realm).isArray());
        Assertions.assertTrue((whoAmI.get("realm_access").get(realm).size() > 0 ? 1 : 0) != 0);
    }

    private static class MasterAdminClientConfig
    implements ClientConfig {
        private MasterAdminClientConfig() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            client.clientId("master-admin-cli");
            client.name("master-admin-cli");
            client.secret(AdminConsoleWhoAmILocaleTest.SECRET);
            client.attribute("security.admin.console", "true");
            client.directAccessGrantsEnabled(true);
            return client;
        }
    }

    private static class MasterAdminUserConfig
    implements UserConfig {
        private MasterAdminUserConfig() {
        }

        public UserConfigBuilder configure(UserConfigBuilder user) {
            user.username("master-admin");
            user.password(AdminConsoleWhoAmILocaleTest.PASSWORD);
            user.name("My", "Admin");
            user.roles(new String[]{"admin"});
            user.email("master-admin@email.org");
            user.emailVerified(true);
            user.attribute("locale", new String[]{AdminConsoleWhoAmILocaleTest.DEFAULT_LOCALE});
            return user;
        }
    }

    private static class LocaleOnRealmConfig
    implements RealmConfig {
        private LocaleOnRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.internationalizationEnabled(true);
            realm.supportedLocales(new String[]{AdminConsoleWhoAmILocaleTest.REALM_LOCALE, AdminConsoleWhoAmILocaleTest.USER_LOCALE, AdminConsoleWhoAmILocaleTest.EXTRA_LOCALE});
            realm.defaultLocale(AdminConsoleWhoAmILocaleTest.REALM_LOCALE);
            realm.addUser(AdminConsoleWhoAmILocaleTest.USER_WITHOUT_LOCALE).password(AdminConsoleWhoAmILocaleTest.PASSWORD).name("My", "Locale Off").email("locale-off@email.org").emailVerified(true).clientRoles("realm-management", new String[]{"realm-admin"});
            realm.addUser(AdminConsoleWhoAmILocaleTest.USER_WITH_LOCALE).password(AdminConsoleWhoAmILocaleTest.PASSWORD).email("locale-on@email.org").emailVerified(true).name("My", "Locale On").attribute("locale", new String[]{AdminConsoleWhoAmILocaleTest.USER_LOCALE}).clientRoles("realm-management", new String[]{"realm-admin"});
            realm.addUser(AdminConsoleWhoAmILocaleTest.USER_NO_ACCESS).password(AdminConsoleWhoAmILocaleTest.PASSWORD).name("No", "Access").email("no-access@email.org").emailVerified(true).attribute("locale", new String[]{AdminConsoleWhoAmILocaleTest.USER_LOCALE});
            realm.addClient("admin-cli").name("admin-cli").secret(AdminConsoleWhoAmILocaleTest.SECRET).attribute("security.admin.console", "true").directAccessGrantsEnabled(true);
            realm.addClient(AdminConsoleWhoAmILocaleTest.ADMIN_CLI_NOT_ALLOWED).name(AdminConsoleWhoAmILocaleTest.ADMIN_CLI_NOT_ALLOWED).secret(AdminConsoleWhoAmILocaleTest.SECRET).attribute("security.admin.console", null).directAccessGrantsEnabled(true);
            return realm;
        }
    }

    private static class LocaleOffRealmConfig
    implements RealmConfig {
        private LocaleOffRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.internationalizationEnabled(false);
            realm.addUser(AdminConsoleWhoAmILocaleTest.USER_WITHOUT_LOCALE).password(AdminConsoleWhoAmILocaleTest.PASSWORD).name("My", "Locale Off").email("locale-off@email.org").emailVerified(true).clientRoles("realm-management", new String[]{"realm-admin"});
            realm.addUser(AdminConsoleWhoAmILocaleTest.USER_WITH_LOCALE).password(AdminConsoleWhoAmILocaleTest.PASSWORD).name("My", "Locale On").email("locale-on@email.org").emailVerified(true).attribute("locale", new String[]{AdminConsoleWhoAmILocaleTest.USER_LOCALE}).clientRoles("realm-management", new String[]{"realm-admin"});
            realm.addClient("admin-cli").name("admin-cli").secret(AdminConsoleWhoAmILocaleTest.SECRET).attribute("security.admin.console", "true").directAccessGrantsEnabled(true);
            return realm;
        }
    }
}

