/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.admin.AdminClientFactory;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectAdminClientFactory;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class AdminEndpointAccessibilityTest {
    @InjectAdminClient
    Keycloak adminClient;
    @InjectAdminClientFactory
    AdminClientFactory adminClientFactory;

    @Test
    public void noAdminEndpointAccessWhenNoRoleAssigned() {
        String userName = "user-" + String.valueOf(UUID.randomUUID());
        UserRepresentation user = UserConfigBuilder.create().username(userName).password("pwd").build();
        String realmName = "master";
        String userUuid = ApiUtil.getCreatedId((Response)this.adminClient.realm("master").users().create(user));
        Keycloak userClient = this.adminClientFactory.create().realm("master").username(userName).password("pwd").clientId("admin-cli").build();
        ClientErrorException e = (ClientErrorException)Assertions.assertThrows(ClientErrorException.class, () -> userClient.realms().findAll());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)String.valueOf(Response.Status.FORBIDDEN.getStatusCode())));
        this.adminClient.realm("master").users().get(userUuid).remove();
    }

    @Test
    public void adminEndpointAccessibleWhenAdminRoleAssignedToUser() {
        String userName = "user-" + String.valueOf(UUID.randomUUID());
        UserRepresentation user = UserConfigBuilder.create().username(userName).password("pwd").build();
        String realmName = "master";
        RealmResource realm = this.adminClient.realms().realm("master");
        RoleRepresentation adminRole = realm.roles().get("admin").toRepresentation();
        MatcherAssert.assertThat((Object)adminRole, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)adminRole.getId(), (Matcher)Matchers.notNullValue());
        String userUuid = ApiUtil.getCreatedId((Response)this.adminClient.realm("master").users().create(user));
        MatcherAssert.assertThat((Object)userUuid, (Matcher)Matchers.notNullValue());
        RoleMappingResource mappings = realm.users().get(userUuid).roles();
        mappings.realmLevel().add(List.of(adminRole));
        Keycloak userClient = this.adminClientFactory.create().realm("master").username(userName).password("pwd").clientId("admin-cli").build();
        Assertions.assertFalse((boolean)userClient.realms().findAll().isEmpty());
        this.adminClient.realm("master").users().get(userUuid).remove();
    }

    @Test
    public void adminEndpointAccessibleWhenAdminRoleAssignedToGroup() {
        String userName = "user-" + String.valueOf(UUID.randomUUID());
        String groupName = "group-" + String.valueOf(UUID.randomUUID());
        String realmName = "master";
        RealmResource realm = this.adminClient.realms().realm("master");
        RoleRepresentation adminRole = realm.roles().get("admin").toRepresentation();
        MatcherAssert.assertThat((Object)adminRole, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)adminRole.getId(), (Matcher)Matchers.notNullValue());
        UserRepresentation user = UserConfigBuilder.create().username(userName).password("pwd").build();
        String userUuid = ApiUtil.getCreatedId((Response)this.adminClient.realm("master").users().create(user));
        MatcherAssert.assertThat((Object)userUuid, (Matcher)Matchers.notNullValue());
        GroupRepresentation group = GroupConfigBuilder.create().name(groupName).build();
        Response response = realm.groups().add(group);
        String groupId = ApiUtil.getCreatedId((Response)response);
        RoleMappingResource mappings = realm.groups().group(groupId).roles();
        mappings.realmLevel().add(List.of(adminRole));
        realm.users().get(userUuid).joinGroup(groupId);
        Keycloak userClient = this.adminClientFactory.create().realm("master").username(userName).password("pwd").clientId("admin-cli").build();
        Assertions.assertFalse((boolean)userClient.realms().findAll().isEmpty());
        this.adminClient.realm("master").groups().group(groupId).remove();
        this.adminClient.realm("master").users().get(userUuid).remove();
    }

    @Test
    public void adminEndpointAccessibleWhenAdminRoleAssignedToGroupAfterUserJoinedIt() {
        String userName = "user-" + String.valueOf(UUID.randomUUID());
        String groupName = "group-" + String.valueOf(UUID.randomUUID());
        String realmName = "master";
        RealmResource realm = this.adminClient.realms().realm("master");
        RoleRepresentation adminRole = realm.roles().get("admin").toRepresentation();
        MatcherAssert.assertThat((Object)adminRole, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)adminRole.getId(), (Matcher)Matchers.notNullValue());
        UserRepresentation user = UserConfigBuilder.create().username(userName).password("pwd").build();
        String userUuid = ApiUtil.getCreatedId((Response)this.adminClient.realm("master").users().create(user));
        MatcherAssert.assertThat((Object)userUuid, (Matcher)Matchers.notNullValue());
        GroupRepresentation group = GroupConfigBuilder.create().name(groupName).build();
        Response response = realm.groups().add(group);
        String groupId = ApiUtil.getCreatedId((Response)response);
        realm.users().get(userUuid).joinGroup(groupId);
        RoleMappingResource mappings = realm.groups().group(groupId).roles();
        mappings.realmLevel().add(List.of(adminRole));
        Keycloak userClient = this.adminClientFactory.create().realm("master").username(userName).password("pwd").clientId("admin-cli").build();
        Assertions.assertFalse((boolean)userClient.realms().findAll().isEmpty());
        this.adminClient.realm("master").groups().group(groupId).remove();
        this.adminClient.realm("master").users().get(userUuid).remove();
    }
}

