/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;

@KeycloakIntegrationTest
public class AdminHeadersTest {
    @InjectRealm
    private ManagedRealm realm;

    @Test
    public void testHeaders() {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("headers-user");
        Response response = this.realm.admin().users().create(userRep);
        MultivaluedMap h = response.getHeaders();
        this.assertDefaultValue(BrowserSecurityHeaders.STRICT_TRANSPORT_SECURITY, (MultivaluedMap<String, Object>)h);
        this.assertDefaultValue(BrowserSecurityHeaders.X_FRAME_OPTIONS, (MultivaluedMap<String, Object>)h);
        this.assertDefaultValue(BrowserSecurityHeaders.X_CONTENT_TYPE_OPTIONS, (MultivaluedMap<String, Object>)h);
        this.assertDefaultValue(BrowserSecurityHeaders.REFERRER_POLICY, (MultivaluedMap<String, Object>)h);
        response.close();
    }

    private void assertDefaultValue(BrowserSecurityHeaders header, MultivaluedMap<String, Object> h) {
        MatcherAssert.assertThat((Object)h.getFirst((Object)header.getHeaderName()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)header.getDefaultValue())));
    }
}

