/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.testframework.annotations.InjectHttpClient;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakUrls;

@KeycloakIntegrationTest
public class AdminPreflightTest {
    @InjectHttpClient
    HttpClient client;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;

    @Test
    public void testPreflight() throws IOException {
        this.testPreflightForAdminPath("/realms/master/users");
    }

    @Test
    public void testPreflightServerInfo() throws IOException {
        this.testPreflightForAdminPath("/serverinfo");
    }

    private void testPreflightForAdminPath(String path) throws IOException {
        HttpOptions options = new HttpOptions(this.keycloakUrls.getAdminBuilder().path(path).build(new Object[0]));
        options.setHeader("Origin", "http://test");
        HttpResponse response = this.client.execute((HttpUriRequest)options);
        Assertions.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        Assertions.assertEquals((Object)"true", (Object)response.getFirstHeader("Access-Control-Allow-Credentials").getValue());
        Assertions.assertEquals((Object)"DELETE, POST, GET, PUT", (Object)response.getFirstHeader("Access-Control-Allow-Methods").getValue());
        Assertions.assertEquals((Object)"http://test", (Object)response.getFirstHeader("Access-Control-Allow-Origin").getValue());
        Assertions.assertEquals((Object)"3600", (Object)response.getFirstHeader("Access-Control-Max-Age").getValue());
        Assertions.assertTrue((boolean)response.getFirstHeader("Access-Control-Allow-Headers").getValue().contains("Authorization"));
        Assertions.assertTrue((boolean)response.getFirstHeader("Access-Control-Allow-Headers").getValue().contains("Content-Type"));
    }
}

