/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.keycloak.testframework.annotations.InjectHttpClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;

@KeycloakIntegrationTest(config=AdminUrlConfig.class)
public class AdminRootEdgeTest {
    private static final String HOSTNAME = "https://localtest.me:8080";
    @InjectHttpClient(followRedirects=false)
    private HttpClient client;

    @ParameterizedTest
    @ValueSource(strings={"http://127.0.0.1:8080", "http://localtest.me:8080"})
    public void testRedirect(String hostname) throws Exception {
        HttpResponse response = this.client.execute((HttpUriRequest)new HttpGet(hostname + "/admin"));
        Assertions.assertEquals((int)302, (int)response.getStatusLine().getStatusCode());
        MatcherAssert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)Matchers.startsWith((String)"https://localtest.me:8080/admin/master/console"));
    }

    public static class AdminUrlConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.options(Map.of("hostname", AdminRootEdgeTest.HOSTNAME));
        }
    }
}

