/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import java.util.Arrays;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.keycloak.testframework.annotations.InjectHttpClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;

@KeycloakIntegrationTest(config=AdminUrlConfig.class)
public class AdminRootTest {
    private static final String HOSTNAME = "http://localtest.me:8080";
    private static final String HOSTNAME_ADMIN = "http://admin.localtest.me:8080";
    private static final String HOSTNAME_LOCAL_ADMIN = "http://localhost:8080";
    @InjectHttpClient(followRedirects=false)
    private HttpClient client;

    @ParameterizedTest
    @ValueSource(strings={"http://admin.localtest.me:8080", "http://localhost:8080"})
    public void testRedirect(String hostname) throws Exception {
        HttpResponse response = this.client.execute((HttpUriRequest)new HttpGet(hostname + "/admin"));
        Assertions.assertEquals((int)302, (int)response.getStatusLine().getStatusCode());
        MatcherAssert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)Matchers.startsWith((String)"http://admin.localtest.me:8080/admin/master/console"));
    }

    @Test
    public void testNoRedirectWithFrontendUrl() throws Exception {
        HttpGet request = new HttpGet("http://localtest.me:8080/admin");
        request.addHeader("Forwarded", "for=192.0.2.60");
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)404, (int)response.getStatusLine().getStatusCode());
        Assertions.assertFalse((boolean)Arrays.stream(response.getAllHeaders()).anyMatch(header -> header.getValue().contains(HOSTNAME_ADMIN)));
        MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)HOSTNAME_ADMIN)));
    }

    public static class AdminUrlConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.options(Map.of("hostname", AdminRootTest.HOSTNAME, "hostname-admin", AdminRootTest.HOSTNAME_ADMIN));
        }
    }
}

