/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.TokenVerifier;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;

@KeycloakIntegrationTest
public class AdminSignatureAlgorithmTest {
    @InjectAdminClient
    Keycloak admin;
    @InjectRealm(attachTo="master")
    ManagedRealm masterRealm;

    @Test
    public void changeRealmTokenAlgorithm() throws Exception {
        this.masterRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.defaultSignatureAlgorithm("ES256")});
        this.admin.tokenManager().invalidate(this.admin.tokenManager().getAccessTokenString());
        AccessTokenResponse accessToken = this.admin.tokenManager().getAccessToken();
        TokenVerifier verifier = TokenVerifier.create((String)accessToken.getToken(), AccessToken.class);
        Assertions.assertEquals((Object)"ES256", (Object)verifier.getHeader().getAlgorithm().name());
    }
}

