/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.AttackDetectionResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class AttackDetectionResourceTest {
    @InjectRealm(config=AttackDetectionResourceRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectUser
    ManagedUser testUser;
    @InjectUser(ref="testUser2")
    ManagedUser testUser2;
    @InjectAdminEvents
    AdminEvents adminEvents;
    @InjectOAuthClient
    OAuthClient oauthClient;

    @Test
    public void test() {
        AttackDetectionResource detection = this.managedRealm.admin().attackDetection();
        this.assertBruteForce(detection.bruteForceUserStatus(this.testUser.getId()), 0, 0, false, false);
        this.oauthClient.doPasswordGrantRequest(this.testUser.getUsername(), "invalid");
        this.oauthClient.doPasswordGrantRequest(this.testUser.getUsername(), "invalid");
        this.oauthClient.doPasswordGrantRequest(this.testUser.getUsername(), "invalid");
        this.oauthClient.doPasswordGrantRequest(this.testUser2.getUsername(), "invalid");
        this.oauthClient.doPasswordGrantRequest(this.testUser2.getUsername(), "invalid");
        this.oauthClient.doPasswordGrantRequest("nosuchuser", "invalid");
        this.assertBruteForce(detection.bruteForceUserStatus(this.testUser.getId()), 2, 1, true, true);
        this.assertBruteForce(detection.bruteForceUserStatus(this.testUser2.getId()), 2, 1, true, true);
        this.assertBruteForce(detection.bruteForceUserStatus("nosuchuser"), 0, 0, false, false);
        detection.clearBruteForceForUser(this.testUser.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.attackDetectionClearBruteForceForUserPath((String)this.testUser.getId()), (ResourceType)ResourceType.USER_LOGIN_FAILURE);
        this.assertBruteForce(detection.bruteForceUserStatus(this.testUser.getId()), 0, 0, false, false);
        this.assertBruteForce(detection.bruteForceUserStatus(this.testUser2.getId()), 2, 1, true, true);
        detection.clearAllBruteForce();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.attackDetectionClearAllBruteForcePath(), (ResourceType)ResourceType.USER_LOGIN_FAILURE);
        this.assertBruteForce(detection.bruteForceUserStatus(this.testUser.getId()), 0, 0, false, false);
        this.assertBruteForce(detection.bruteForceUserStatus(this.testUser2.getId()), 0, 0, false, false);
    }

    private void assertBruteForce(Map<String, Object> status, Integer expectedNumFailures, Integer expectedNumTemporaryLockouts, Boolean expectedFailure, Boolean expectedDisabled) {
        Assertions.assertEquals((int)6, (int)status.size());
        Assertions.assertEquals((Object)expectedNumFailures, (Object)status.get("numFailures"));
        Assertions.assertEquals((Object)expectedNumTemporaryLockouts, (Object)status.get("numTemporaryLockouts"));
        Assertions.assertEquals((Object)expectedDisabled, (Object)status.get("disabled"));
        if (expectedFailure.booleanValue()) {
            Assertions.assertEquals((Object)"127.0.0.1", (Object)status.get("lastIPFailure"));
            Long lastFailure = (Long)status.get("lastFailure");
            Assertions.assertTrue((lastFailure < System.currentTimeMillis() + 1L && lastFailure > System.currentTimeMillis() - 10000L ? 1 : 0) != 0);
            Assertions.assertNotEquals((Object)"0", (Object)status.get("failedLoginNotBefore").toString());
        } else {
            Assertions.assertEquals((Object)"n/a", (Object)status.get("lastIPFailure"));
            Assertions.assertEquals((Object)"0", (Object)status.get("lastFailure").toString());
            Assertions.assertEquals((Object)"0", (Object)status.get("failedLoginNotBefore").toString());
        }
    }

    private static class AttackDetectionResourceRealmConfig
    implements RealmConfig {
        private AttackDetectionResourceRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.bruteForceProtected(true);
            realm.failureFactor(2);
            return realm;
        }
    }
}

