/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import java.io.InputStream;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest(config=AuthzCleanupServerConfig.class)
public class AuthzCleanupTest {
    @InjectRealm(config=AuthzCleanupRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    private static final String clientId = "myclient";
    private static final String clientSecret = "secret";
    private static final String realmName = "default";

    @Test
    public void testCreate() throws Exception {
        ClientsResource clients = this.managedRealm.admin().clients();
        ClientRepresentation client = (ClientRepresentation)clients.findByClientId(clientId).get(0);
        ResourceServerRepresentation settings = (ResourceServerRepresentation)JsonSerialization.readValue((InputStream)AuthzCleanupTest.class.getResourceAsStream("authz/acme-resource-server-cleanup-test.json"), ResourceServerRepresentation.class);
        clients.get(client.getId()).authorization().importSettings(settings);
        this.runOnServer.run(AuthzCleanupTest::setup);
    }

    public static void setup(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(realmName);
        session.getContext().setRealm(realm);
        AuthorizationProvider authz = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        ClientModel myClient = realm.getClientByClientId(clientId);
        ResourceServer resourceServer = authz.getStoreFactory().getResourceServerStore().findByClient(myClient);
        AuthzCleanupTest.createRolePolicy(authz, resourceServer, myClient.getClientId() + "/client-role-1");
        AuthzCleanupTest.createRolePolicy(authz, resourceServer, myClient.getClientId() + "/client-role-2");
    }

    private static Policy createRolePolicy(AuthorizationProvider authz, ResourceServer resourceServer, String roleName) {
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        representation.setName(roleName);
        representation.setType("role");
        representation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        representation.setLogic(Logic.POSITIVE);
        representation.addRole(roleName, Boolean.valueOf(true));
        return authz.getStoreFactory().getPolicyStore().create(resourceServer, (AbstractPolicyRepresentation)representation);
    }

    private static class AuthzCleanupRealmConfig
    implements RealmConfig {
        private AuthzCleanupRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.addClient(AuthzCleanupTest.clientId).secret(AuthzCleanupTest.clientSecret).authorizationServicesEnabled(true).redirectUris(new String[]{"http://localhost/myclient"});
            realm.roles(new String[]{"client-role-1", "client-role-2", "Acme administrator", "Acme viewer", "tenant administrator", "tenant viewer", "tenant user"});
            return realm;
        }
    }

    public static class AuthzCleanupServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder builder) {
            builder.features(new Profile.Feature[]{Profile.Feature.AUTHORIZATION});
            return builder;
        }
    }
}

