/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.Constants;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.TestApp;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectTestApp;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.AuthorizationEndpointResponse;

@KeycloakIntegrationTest
public class ClientTest {
    @InjectRealm(ref="default", config=ClientTestRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectRealm(ref="master", attachTo="master")
    ManagedRealm managedMasterRealm;
    @InjectOAuthClient(realmRef="default", kcAdmin=true)
    OAuthClient oauth;
    @InjectTestApp
    TestApp testApp;
    @InjectAdminEvents(realmRef="default")
    AdminEvents adminEvents;

    @Test
    public void getClients() {
        Assert.assertNames((List)this.managedRealm.admin().clients().findAll(), (String[])new String[]{"account", "account-console", "realm-management", "security-admin-console", "broker", "test-app", "admin-cli"});
    }

    @Test
    public void getRealmClients() {
        Assertions.assertTrue((boolean)this.managedRealm.admin().clients().findAll().stream().filter(client -> ((String)client.getAttributes().get("realm_client")).equals("true")).map(ClientRepresentation::getClientId).allMatch(clientId -> clientId.equals("realm-management") || clientId.equals("broker") || clientId.endsWith("-realm")));
    }

    private ClientRepresentation createClient() {
        return this.createClient(null);
    }

    private ClientRepresentation createClient(String protocol) {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setClientId("my-app");
        rep.setDescription("my-app description");
        rep.setEnabled(Boolean.valueOf(true));
        rep.setPublicClient(Boolean.valueOf(true));
        if (protocol != null) {
            rep.setProtocol(protocol);
        }
        Response response = this.managedRealm.admin().clients().create(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(id).remove());
        ClientRepresentation found = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"my-app").toRepresentation();
        Assertions.assertEquals((Object)"my-app", (Object)found.getClientId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)id), (Object)rep, (ResourceType)ResourceType.CLIENT);
        rep.setId(id);
        return rep;
    }

    private ClientRepresentation createClientNonPublic() {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setClientId("my-app");
        rep.setDescription("my-app description");
        rep.setEnabled(Boolean.valueOf(true));
        rep.setPublicClient(Boolean.valueOf(false));
        Response response = this.managedRealm.admin().clients().create(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(id).remove());
        ClientRepresentation found = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"my-app").toRepresentation();
        Assertions.assertEquals((Object)"my-app", (Object)found.getClientId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)id), (Object)rep, (ResourceType)ResourceType.CLIENT);
        rep.setId(id);
        return rep;
    }

    @Test
    public void createClientVerifyWithSecret() {
        String id = this.createClientNonPublic().getId();
        ClientResource client = this.managedRealm.admin().clients().get(id);
        Assertions.assertNotNull((Object)client);
        Assertions.assertNotNull((Object)client.toRepresentation().getSecret());
        Assert.assertNames((List)this.managedRealm.admin().clients().findAll(), (String[])new String[]{"account", "account-console", "realm-management", "security-admin-console", "broker", "my-app", "test-app", "admin-cli"});
    }

    @Test
    public void createClientVerify() {
        String id = this.createClient().getId();
        ClientResource client = this.managedRealm.admin().clients().get(id);
        Assertions.assertNotNull((Object)client);
        Assertions.assertNull((Object)client.toRepresentation().getSecret());
        Assert.assertNames((List)this.managedRealm.admin().clients().findAll(), (String[])new String[]{"account", "account-console", "realm-management", "security-admin-console", "broker", "my-app", "test-app", "admin-cli"});
    }

    @Test
    public void testCreateClientWithBlankClientId() {
        ClientRepresentation rep = ClientConfigBuilder.create().clientId("").description("blank").enabled(true).publicClient(true).build();
        try (Response response = this.managedRealm.admin().clients().create(rep);){
            if (response.getStatus() != 400) {
                response.bufferEntity();
                String body = (String)response.readEntity(String.class);
                Assertions.fail((String)("expect 400 Bad request response code but receive: " + response.getStatus() + "\n" + body));
            }
        }
    }

    @Test
    public void testInvalidLengthClientIdValidation() {
        ClientRepresentation rep = ClientConfigBuilder.create().id("test-long-invalid-client-id-validation-400-bad-request").clientId("test-long-invalid-client-id-validation-400-bad-request").description("invalid-client-id-app description").enabled(true).publicClient(true).build();
        try (Response response = this.managedRealm.admin().clients().create(rep);){
            if (response.getStatus() != 400) {
                response.bufferEntity();
                String body = (String)response.readEntity(String.class);
                Assertions.fail((String)("expect 400 Bad request response code but receive: " + response.getStatus() + "\n" + body));
            }
        }
    }

    @Test
    public void testInvalidUrlClientValidation() {
        this.testClientUriValidation("Root URL is not a valid URL", "Base URL is not a valid URL", "Backchannel logout URL is not a valid URL", null, "invalid", "myapp://some-fake-app");
    }

    @Test
    public void testIllegalSchemeClientValidation() {
        this.testClientUriValidation("Root URL uses an illegal scheme", "Base URL uses an illegal scheme", "Backchannel logout URL uses an illegal scheme", "A redirect URI uses an illegal scheme", "data:text/html;base64,PHNjcmlwdD5jb25maXJtKGRvY3VtZW50LmRvbWFpbik7PC9zY3JpcHQ+", "javascript:confirm(document.domain)/*");
    }

    @Test
    public void testFragmentProhibitedClientValidation() {
        this.testClientUriValidation("Root URL must not contain an URL fragment", null, null, "Redirect URIs must not contain an URI fragment", "http://redhat.com/abcd#someFragment");
    }

    @Test
    public void testSamlSpecificUrls() {
        this.testSamlSpecificUrls(true, "javascript:alert('TEST')", "data:text/html;base64,PHNjcmlwdD5jb25maXJtKGRvY3VtZW50LmRvbWFpbik7PC9zY3JpcHQ+");
        this.testSamlSpecificUrls(false, "javascript:alert('TEST')", "data:text/html;base64,PHNjcmlwdD5jb25maXJtKGRvY3VtZW50LmRvbWFpbik7PC9zY3JpcHQ+");
    }

    private void testSamlSpecificUrls(boolean create, String ... testUrls) {
        ClientRepresentation rep;
        if (create) {
            rep = new ClientRepresentation();
            rep.setClientId("my-app2");
            rep.setEnabled(Boolean.valueOf(true));
            rep.setProtocol("saml");
        } else {
            rep = this.createClient("saml");
        }
        rep.setAttributes(new HashMap());
        Map<String, String> attrs = Map.of("saml_assertion_consumer_url_post", "Assertion Consumer Service POST Binding URL", "saml_assertion_consumer_url_redirect", "Assertion Consumer Service Redirect Binding URL", "saml_artifact_binding_url", "Artifact Binding URL", "saml_single_logout_service_url_post", "Logout Service POST Binding URL", "saml_single_logout_service_url_artifact", "Logout Service ARTIFACT Binding URL", "saml_single_logout_service_url_redirect", "Logout Service Redirect Binding URL", "saml_single_logout_service_url_soap", "Logout Service SOAP Binding URL", "saml_artifact_resolution_service_url", "Artifact Resolution Service");
        for (String testUrl : testUrls) {
            rep.setAdminUrl(testUrl);
            this.createOrUpdateClientExpectingValidationErrors(rep, create, "Master SAML Processing URL uses an illegal scheme");
            rep.setAdminUrl(null);
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                rep.getAttributes().put(entry.getKey(), testUrl);
                this.createOrUpdateClientExpectingValidationErrors(rep, create, entry.getValue() + " uses an illegal scheme");
                rep.getAttributes().remove(entry.getKey());
            }
        }
    }

    private void testClientUriValidation(String expectedRootUrlError, String expectedBaseUrlError, String expectedBackchannelLogoutUrlError, String expectedRedirectUrisError, String ... testUrls) {
        this.testClientUriValidation(false, expectedRootUrlError, expectedBaseUrlError, expectedBackchannelLogoutUrlError, expectedRedirectUrisError, testUrls);
        this.testClientUriValidation(true, expectedRootUrlError, expectedBaseUrlError, expectedBackchannelLogoutUrlError, expectedRedirectUrisError, testUrls);
    }

    private void testClientUriValidation(boolean create, String expectedRootUrlError, String expectedBaseUrlError, String expectedBackchannelLogoutUrlError, String expectedRedirectUrisError, String ... testUrls) {
        ClientRepresentation rep;
        if (create) {
            rep = new ClientRepresentation();
            rep.setClientId("my-app2");
            rep.setEnabled(Boolean.valueOf(true));
        } else {
            rep = this.createClient();
        }
        for (String testUrl : testUrls) {
            if (expectedRootUrlError != null) {
                rep.setRootUrl(testUrl);
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedRootUrlError);
            }
            rep.setRootUrl(null);
            if (expectedBaseUrlError != null) {
                rep.setBaseUrl(testUrl);
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedBaseUrlError);
            }
            rep.setBaseUrl(null);
            if (expectedBackchannelLogoutUrlError != null) {
                OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)rep).setBackchannelLogoutUrl(testUrl);
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedBackchannelLogoutUrlError);
            }
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)rep).setBackchannelLogoutUrl(null);
            if (expectedRedirectUrisError != null) {
                rep.setRedirectUris(List.of(testUrl));
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedRedirectUrisError);
            }
            rep.setRedirectUris(null);
            if (expectedRootUrlError != null) {
                rep.setRootUrl(testUrl);
            }
            if (expectedBaseUrlError != null) {
                rep.setBaseUrl(testUrl);
            }
            if (expectedRedirectUrisError != null) {
                rep.setRedirectUris(List.of(testUrl));
            }
            this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedRootUrlError, expectedBaseUrlError, expectedRedirectUrisError);
            rep.setRootUrl(null);
            rep.setBaseUrl(null);
            rep.setRedirectUris(null);
        }
    }

    private void createOrUpdateClientExpectingValidationErrors(ClientRepresentation rep, boolean create, String ... expectedErrors) {
        Response response = null;
        if (create) {
            response = this.managedRealm.admin().clients().create(rep);
        } else {
            try {
                this.managedRealm.admin().clients().get(rep.getId()).update(rep);
                Assertions.fail((String)"Expected exception");
            }
            catch (BadRequestException e) {
                response = e.getResponse();
            }
        }
        expectedErrors = (String[])Arrays.stream(expectedErrors).filter(Objects::nonNull).toArray(String[]::new);
        Assertions.assertEquals((int)400, (int)response.getStatus());
        OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)response.readEntity(OAuth2ErrorRepresentation.class);
        List<String> actualErrors = Arrays.asList(errorRep.getErrorDescription().split("; "));
        MatcherAssert.assertThat(actualErrors, (Matcher)Matchers.containsInAnyOrder((Object[])expectedErrors));
        Assertions.assertEquals((Object)"invalid_input", (Object)errorRep.getError());
    }

    @Test
    public void removeClient() {
        Response response = this.managedRealm.admin().clients().create(ClientConfigBuilder.create().clientId("my-app").build());
        String id = ApiUtil.getCreatedId((Response)response);
        this.adminEvents.skip();
        Assertions.assertNotNull((Object)ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"my-app"));
        this.managedRealm.admin().clients().get(id).remove();
        Assertions.assertNull((Object)ApiUtil.findClientResourceById((RealmResource)this.managedRealm.admin(), (String)"my-app"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientResourcePath((String)id), (ResourceType)ResourceType.CLIENT);
    }

    @Test
    public void removeClientWithDependentCompositeRoles() {
        ClientRepresentation clientRep = ClientConfigBuilder.create().clientId("my-app").build();
        String id = ApiUtil.getCreatedId((Response)this.managedRealm.admin().clients().create(clientRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)id), (Object)clientRep, (ResourceType)ResourceType.CLIENT);
        ClientResource clientRsc = this.managedRealm.admin().clients().get(id);
        RoleRepresentation roleB = RoleConfigBuilder.create().name("role-b").build();
        clientRsc.roles().create(roleB);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)id, (String)"role-b"), (Object)roleB, (ResourceType)ResourceType.CLIENT_ROLE);
        RoleRepresentation roleA = RoleConfigBuilder.create().name("role-a").build();
        clientRsc.roles().create(roleA);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)id, (String)"role-a"), (Object)roleA, (ResourceType)ResourceType.CLIENT_ROLE);
        List<RoleRepresentation> composites = List.of(clientRsc.roles().get("role-b").toRepresentation());
        clientRsc.roles().get("role-a").addComposites(composites);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourceCompositesPath((String)id, (String)"role-a"), composites, (ResourceType)ResourceType.CLIENT_ROLE);
        clientRsc.remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientResourcePath((String)id), (ResourceType)ResourceType.CLIENT);
    }

    @Test
    public void removeInternalClientExpectingBadRequestException() {
        String testRealmClientId = ApiUtil.findClientByClientId((RealmResource)this.managedMasterRealm.admin(), (String)(this.managedRealm.getName() + "-realm")).toRepresentation().getId();
        Assertions.assertThrows(BadRequestException.class, () -> this.managedMasterRealm.admin().clients().get(testRealmClientId).remove());
        Constants.defaultClients.forEach(defaultClient -> {
            String defaultClientId = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)defaultClient).toRepresentation().getId();
            Assertions.assertThrows(BadRequestException.class, () -> this.managedRealm.admin().clients().get(defaultClientId).remove());
        });
    }

    @Test
    public void getClientRepresentation() {
        String id = this.createClient().getId();
        ClientRepresentation rep = this.managedRealm.admin().clients().get(id).toRepresentation();
        Assertions.assertEquals((Object)id, (Object)rep.getId());
        Assertions.assertEquals((Object)"my-app", (Object)rep.getClientId());
        Assertions.assertTrue((boolean)rep.isEnabled());
    }

    @Test
    public void getClientDescription() {
        String id = this.createClient().getId();
        ClientRepresentation rep = this.managedRealm.admin().clients().get(id).toRepresentation();
        Assertions.assertEquals((Object)id, (Object)rep.getId());
        Assertions.assertEquals((Object)"my-app description", (Object)rep.getDescription());
    }

    @Test
    public void getClientSessions() {
        AccessTokenResponse response = this.oauth.doPasswordGrantRequest("test-user@localhost", "password");
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        AuthorizationEndpointResponse codeResponse = this.oauth.doLogin("test-user@localhost", "password");
        AccessTokenResponse response2 = this.oauth.doAccessTokenRequest(codeResponse.getCode());
        Assertions.assertEquals((int)200, (int)response2.getStatusCode());
        ClientResource app = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"test-app");
        Assertions.assertEquals((long)2L, (long)((Integer)app.getApplicationSessionCount().get("count")).intValue());
        List userSessions = app.getUserSessions(Integer.valueOf(0), Integer.valueOf(100));
        Assertions.assertEquals((int)2, (int)userSessions.size());
        Assertions.assertEquals((int)1, (int)((UserSessionRepresentation)userSessions.get(0)).getClients().size());
    }

    @Test
    public void getAllClients() {
        List allClients = this.managedRealm.admin().clients().findAll();
        Assertions.assertNotNull((Object)allClients);
        Assertions.assertFalse((boolean)allClients.isEmpty());
    }

    @Test
    public void getAllClientsSearchAndPagination() {
        for (int i = 1; i <= 10; ++i) {
            ClientRepresentation c = ClientConfigBuilder.create().clientId("ccx-" + String.valueOf(i < 10 ? "0" + i : Integer.valueOf(i))).build();
            Response response = this.managedRealm.admin().clients().create(c);
            String id = ApiUtil.getCreatedId((Response)response);
            this.managedRealm.cleanup().add(r -> r.clients().get(id).remove());
        }
        this.assertPaginatedClients(1, 10, this.managedRealm.admin().clients().findAll("ccx-", null, Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(100)));
        this.assertPaginatedClients(1, 5, this.managedRealm.admin().clients().findAll("ccx-", null, Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5)));
        this.assertPaginatedClients(6, 10, this.managedRealm.admin().clients().findAll("ccx-", null, Boolean.valueOf(true), Integer.valueOf(5), Integer.valueOf(5)));
    }

    private void assertPaginatedClients(int start, int end, List<ClientRepresentation> actual) {
        LinkedList<CallSite> expected = new LinkedList<CallSite>();
        for (int i = start; i <= end; ++i) {
            expected.add((CallSite)((Object)("ccx-" + String.valueOf(i < 10 ? "0" + i : Integer.valueOf(i)))));
        }
        List a = actual.stream().map(ClientRepresentation::getClientId).collect(Collectors.toList());
        MatcherAssert.assertThat(a, (Matcher)CoreMatchers.is(expected));
    }

    @Test
    public void getClientById() {
        this.createClient();
        ClientRepresentation rep = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"my-app").toRepresentation();
        ClientRepresentation gotById = this.managedRealm.admin().clients().get(rep.getId()).toRepresentation();
        ClientTest.assertClient(rep, gotById);
    }

    @Test
    public void deleteDefaultRole() {
        ClientRepresentation rep = this.createClient();
        String id = rep.getId();
        RoleRepresentation role = new RoleRepresentation("test", "test", false);
        this.managedRealm.admin().clients().get(id).roles().create(role);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)id, (String)"test"), (Object)role, (ResourceType)ResourceType.CLIENT_ROLE);
        role = this.managedRealm.admin().clients().get(id).roles().get("test").toRepresentation();
        String DEFAULT_ROLE = "default-roles-" + this.managedRealm.getName();
        this.managedRealm.admin().roles().get(DEFAULT_ROLE).addComposites(List.of(role));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourceCompositesPath((String)DEFAULT_ROLE), List.of(role), (ResourceType)ResourceType.REALM_ROLE);
        MatcherAssert.assertThat(this.managedRealm.admin().roles().get(DEFAULT_ROLE).getRoleComposites().stream().map(RoleRepresentation::getName).collect(Collectors.toSet()), (Matcher)Matchers.hasItem((Object)role.getName()));
        this.managedRealm.admin().clients().get(id).roles().deleteRole("test");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientRoleResourcePath((String)id, (String)"test"), (ResourceType)ResourceType.CLIENT_ROLE);
        MatcherAssert.assertThat(this.managedRealm.admin().roles().get(DEFAULT_ROLE).getRoleComposites().stream().map(RoleRepresentation::getName).collect(Collectors.toSet()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)role)));
    }

    @Test
    public void testProtocolMappers() {
        String clientDbId = this.createClient().getId();
        ProtocolMappersResource mappersResource = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"my-app").getProtocolMappers();
        this.protocolMappersTest(clientDbId, mappersResource);
    }

    @Test
    public void updateClient() {
        ClientRepresentation client = this.createClient();
        ClientRepresentation newClient = ClientConfigBuilder.create().id(client.getId()).clientId(client.getClientId()).baseUrl("http://baseurl").build();
        ClientResource clientRes = this.managedRealm.admin().clients().get(client.getId());
        clientRes.update(newClient);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)client.getId()), (Object)newClient, (ResourceType)ResourceType.CLIENT);
        ClientRepresentation storedClient = clientRes.toRepresentation();
        Assertions.assertNull((Object)storedClient.getSecret());
        Assertions.assertNull((Object)clientRes.getSecret().getValue());
        ClientTest.assertClient(client, storedClient);
        client.setPublicClient(Boolean.valueOf(false));
        newClient.setPublicClient(client.isPublicClient());
        client.setSecret("new-secret");
        newClient.setSecret(client.getSecret());
        clientRes.update(newClient);
        newClient.setSecret("**********");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)client.getId()), (Object)newClient, (ResourceType)ResourceType.CLIENT);
        storedClient = clientRes.toRepresentation();
        ClientTest.assertClient(client, storedClient);
        storedClient.setSecret(null);
        storedClient.getAttributes().put("backchannel.logout.url", "");
        clientRes.update(storedClient);
        storedClient = clientRes.toRepresentation();
        Assertions.assertFalse((boolean)storedClient.getAttributes().containsKey("backchannel.logout.url"));
        ClientTest.assertClient(client, storedClient);
    }

    @Test
    public void serviceAccount() {
        Response response = this.managedRealm.admin().clients().create(ClientConfigBuilder.create().clientId("serviceClient").serviceAccountsEnabled(true).build());
        String id = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(id).remove());
        UserRepresentation userRep = this.managedRealm.admin().clients().get(id).getServiceAccountUser();
        MatcherAssert.assertThat((Object)"service-account-serviceclient", (Matcher)Matchers.equalTo((Object)userRep.getUsername()));
        Assertions.assertNull((Object)userRep.getEmail());
    }

    @Test
    public void pushRevocation() throws InterruptedException {
        this.testApp.kcAdmin().clear();
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"test-app");
        String id = client.toRepresentation().getId();
        client.pushRevocation();
        PushNotBeforeAction pushNotBefore = this.testApp.kcAdmin().getAdminPushNotBefore();
        Assertions.assertEquals((int)client.toRepresentation().getNotBefore(), (int)pushNotBefore.getNotBefore());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)AdminEventPaths.clientPushRevocationPath((String)id), (ResourceType)ResourceType.CLIENT);
    }

    @Test
    public void testAddNodeWithReservedCharacter() {
        this.testApp.kcAdmin().clear();
        String id = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"test-app").toRepresentation().getId();
        Assertions.assertThrows(BadRequestException.class, () -> this.managedRealm.admin().clients().get(id).registerNode(Collections.singletonMap("node", "foo#")));
    }

    @Test
    public void nodes() throws MalformedURLException, InterruptedException {
        this.testApp.kcAdmin().clear();
        String id = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"test-app").toRepresentation().getId();
        String myhost = new URL(this.managedRealm.getBaseUrl()).getHost();
        this.managedRealm.admin().clients().get(id).registerNode(Collections.singletonMap("node", myhost));
        this.managedRealm.admin().clients().get(id).registerNode(Collections.singletonMap("node", "invalid"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientNodePath((String)id, (String)myhost), (ResourceType)ResourceType.CLUSTER_NODE);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientNodePath((String)id, (String)"invalid"), (ResourceType)ResourceType.CLUSTER_NODE);
        GlobalRequestResult result = this.managedRealm.admin().clients().get(id).testNodesAvailable();
        Assertions.assertEquals((int)1, (int)result.getSuccessRequests().size());
        Assertions.assertEquals((int)1, (int)result.getFailedRequests().size());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)AdminEventPaths.clientTestNodesAvailablePath((String)id), (Object)result, (ResourceType)ResourceType.CLUSTER_NODE);
        TestAvailabilityAction testAvailable = this.testApp.kcAdmin().getTestAvailable();
        Assertions.assertEquals((Object)"test-app", (Object)testAvailable.getResource());
        Assertions.assertEquals((int)2, (int)this.managedRealm.admin().clients().get(id).toRepresentation().getRegisteredNodes().size());
        this.managedRealm.admin().clients().get(id).unregisterNode("invalid");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientNodePath((String)id, (String)"invalid"), (ResourceType)ResourceType.CLUSTER_NODE);
        Assertions.assertEquals((int)1, (int)this.managedRealm.admin().clients().get(id).toRepresentation().getRegisteredNodes().size());
        this.managedRealm.admin().clients().get(id).unregisterNode(myhost);
    }

    @Test
    public void offlineUserSessions() {
        ClientRepresentation client = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"test-app").toRepresentation();
        String id = client.getId();
        Response response = this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser").password("password").email("testuser@localhost").name("test", "user").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.users().delete(userId).close());
        Map offlineSessionCount = this.managedRealm.admin().clients().get(id).getOfflineSessionCount();
        Assertions.assertEquals((Long)0L, (Long)((Long)offlineSessionCount.get("count")));
        List userSessions = this.managedRealm.admin().users().get(userId).getOfflineSessions(id);
        Assertions.assertEquals((int)0, (int)userSessions.size(), (String)"There should be no offline sessions");
        this.oauth.scope("offline_access");
        this.oauth.doLogin("testuser", "password");
        AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(this.oauth.parseLoginResponse().getCode());
        Assertions.assertEquals((int)200, (int)accessTokenResponse.getStatusCode());
        offlineSessionCount = this.managedRealm.admin().clients().get(id).getOfflineSessionCount();
        Assertions.assertEquals((Long)1L, (Long)((Long)offlineSessionCount.get("count")));
        List offlineUserSessions = this.managedRealm.admin().clients().get(id).getOfflineUserSessions(Integer.valueOf(0), Integer.valueOf(100));
        Assertions.assertEquals((int)1, (int)offlineUserSessions.size());
        Assertions.assertEquals((Object)"testuser", (Object)((UserSessionRepresentation)offlineUserSessions.get(0)).getUsername());
        MatcherAssert.assertThat((Object)((UserSessionRepresentation)offlineUserSessions.get(0)).getLastAccess(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(Time.currentTimeMillis() - 10000L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(Time.currentTimeMillis()))));
        userSessions = this.managedRealm.admin().users().get(userId).getOfflineSessions(id);
        Assertions.assertEquals((int)1, (int)userSessions.size(), (String)"There should be one offline session");
        this.assertOfflineSession((UserSessionRepresentation)offlineUserSessions.get(0), (UserSessionRepresentation)userSessions.get(0));
        this.oauth.scope(null);
    }

    private void assertOfflineSession(UserSessionRepresentation expected, UserSessionRepresentation actual) {
        Assertions.assertEquals((Object)expected.getId(), (Object)actual.getId(), (String)"id");
        Assertions.assertEquals((Object)expected.getUserId(), (Object)actual.getUserId(), (String)"userId");
        Assertions.assertEquals((Object)expected.getUsername(), (Object)actual.getUsername(), (String)"userName");
        Assertions.assertEquals((Object)expected.getClients(), (Object)actual.getClients(), (String)"clients");
    }

    @Test
    public void scopes() {
        Response response = this.managedRealm.admin().clients().create(ClientConfigBuilder.create().clientId("client").fullScopeEnabled(false).build());
        String id = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(id).remove());
        this.adminEvents.skip();
        RoleMappingResource scopesResource = this.managedRealm.admin().clients().get(id).getScopeMappings();
        RoleRepresentation roleRep1 = this.createRealmRole("realm-composite");
        RoleRepresentation roleRep2 = this.createRealmRole("realm-child");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)"realm-composite"), (Object)roleRep1, (ResourceType)ResourceType.REALM_ROLE);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)"realm-child"), (Object)roleRep2, (ResourceType)ResourceType.REALM_ROLE);
        roleRep1 = this.managedRealm.admin().roles().get("realm-composite").toRepresentation();
        roleRep2 = this.managedRealm.admin().roles().get("realm-child").toRepresentation();
        this.managedRealm.admin().roles().get("realm-composite").addComposites(List.of(roleRep2));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourceCompositesPath((String)"realm-composite"), List.of(roleRep2), (ResourceType)ResourceType.REALM_ROLE);
        String accountMgmtId = ((ClientRepresentation)this.managedRealm.admin().clients().findByClientId("account").get(0)).getId();
        RoleRepresentation viewAccountRoleRep = this.managedRealm.admin().clients().get(accountMgmtId).roles().get("view-profile").toRepresentation();
        scopesResource.realmLevel().add(List.of(roleRep1));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeMappingsRealmLevelPath((String)id), List.of(roleRep1), (ResourceType)ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).add(List.of(viewAccountRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeMappingsClientLevelPath((String)id, (String)accountMgmtId), List.of(viewAccountRoleRep), (ResourceType)ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[]{"realm-composite"});
        Assert.assertNames((List)scopesResource.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)scopesResource.realmLevel().listAvailable(), (String[])new String[]{"realm-child", "offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)scopesResource.clientLevel(accountMgmtId).listAll(), (String[])new String[]{"view-profile"});
        Assert.assertNames((List)scopesResource.clientLevel(accountMgmtId).listEffective(), (String[])new String[]{"view-profile"});
        Assert.assertNames((List)scopesResource.clientLevel(accountMgmtId).listAvailable(), (String[])new String[]{"manage-account", "manage-account-links", "view-applications", "view-consent", "manage-consent", "delete-account", "view-groups"});
        Assert.assertNames((List)scopesResource.getAll().getRealmMappings(), (String[])new String[]{"realm-composite"});
        Assert.assertNames((List)((ClientMappingsRepresentation)scopesResource.getAll().getClientMappings().get("account")).getMappings(), (String[])new String[]{"view-profile"});
        scopesResource.realmLevel().remove(List.of(roleRep1));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeMappingsRealmLevelPath((String)id), List.of(roleRep1), (ResourceType)ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).remove(List.of(viewAccountRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeMappingsClientLevelPath((String)id, (String)accountMgmtId), List.of(viewAccountRoleRep), (ResourceType)ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[0]);
        Assert.assertNames((List)scopesResource.realmLevel().listEffective(), (String[])new String[0]);
        Assert.assertNames((List)scopesResource.realmLevel().listAvailable(), (String[])new String[]{"offline_access", "uma_authorization", "realm-composite", "realm-child", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)scopesResource.clientLevel(accountMgmtId).listAll(), (String[])new String[0]);
        Assert.assertNames((List)scopesResource.clientLevel(accountMgmtId).listAvailable(), (String[])new String[]{"view-profile", "manage-account", "manage-account-links", "view-applications", "view-consent", "manage-consent", "delete-account", "view-groups"});
        Assert.assertNames((List)scopesResource.clientLevel(accountMgmtId).listEffective(), (String[])new String[0]);
    }

    @Test
    public void rolesCanBeAddedToScopeEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        Response response = this.managedRealm.admin().clients().create(ClientConfigBuilder.create().clientId("test-client").fullScopeEnabled(false).build());
        String testedClientUuid = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(testedClientUuid).remove());
        this.createRealmRole("realm-composite");
        this.createRealmRole("realm-child");
        this.managedRealm.admin().roles().get("realm-composite").addComposites(List.of(this.managedRealm.admin().roles().get("realm-child").toRepresentation()));
        response = this.managedRealm.admin().clients().create(ClientConfigBuilder.create().clientId("role-container-client").build());
        String roleContainerClientUuid = ApiUtil.getCreatedId((Response)response);
        RolesResource roleContainerClientRolesRsc = this.managedRealm.admin().clients().get(roleContainerClientUuid).roles();
        this.managedRealm.cleanup().add(r -> r.clients().get(roleContainerClientUuid).remove());
        roleContainerClientRolesRsc.create(RoleConfigBuilder.create().name("client-composite").build());
        roleContainerClientRolesRsc.create(RoleConfigBuilder.create().name("client-child").build());
        roleContainerClientRolesRsc.get("client-composite").addComposites(List.of(roleContainerClientRolesRsc.get("client-child").toRepresentation()));
        RoleMappingResource scopesResource = this.managedRealm.admin().clients().get(testedClientUuid).getScopeMappings();
        scopesResource.realmLevel().add(List.of(this.managedRealm.admin().roles().get("realm-composite").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(List.of(roleContainerClientRolesRsc.get("client-composite").toRepresentation()));
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[]{"realm-composite"});
        Assert.assertNames((List)scopesResource.realmLevel().listAvailable(), (String[])new String[]{"realm-child", "offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)scopesResource.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAll(), (String[])new String[]{"client-composite"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), (String[])new String[]{"client-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listEffective(), (String[])new String[]{"client-composite", "client-child"});
        scopesResource.realmLevel().add(List.of(this.managedRealm.admin().roles().get("realm-child").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(List.of(roleContainerClientRolesRsc.get("client-child").toRepresentation()));
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)scopesResource.realmLevel().listAvailable(), (String[])new String[]{"offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)scopesResource.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAll(), (String[])new String[]{"client-composite", "client-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), (String[])new String[0]);
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listEffective(), (String[])new String[]{"client-composite", "client-child"});
    }

    @Test
    public void scopesRoleRemoval() {
        Response response = this.managedRealm.admin().clients().create(ClientConfigBuilder.create().clientId("clientA").fullScopeEnabled(false).build());
        String idA = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(idA).remove());
        response = this.managedRealm.admin().clients().create(ClientConfigBuilder.create().clientId("clientB").fullScopeEnabled(false).build());
        String idB = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(idB).remove());
        this.adminEvents.skip(2);
        RoleMappingResource scopesResource = this.managedRealm.admin().clients().get(idA).getScopeMappings();
        RoleRepresentation realmRoleRep = RoleConfigBuilder.create().name("realm-role").build();
        this.managedRealm.admin().roles().create(realmRoleRep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)realmRoleRep.getName()), (Object)realmRoleRep, (ResourceType)ResourceType.REALM_ROLE);
        RoleRepresentation clientBRoleRep = RoleConfigBuilder.create().name("clientB-role").build();
        this.managedRealm.admin().clients().get(idB).roles().create(clientBRoleRep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)idB, (String)clientBRoleRep.getName()), (Object)clientBRoleRep, (ResourceType)ResourceType.CLIENT_ROLE);
        realmRoleRep = this.managedRealm.admin().roles().get(realmRoleRep.getName()).toRepresentation();
        clientBRoleRep = this.managedRealm.admin().clients().get(idB).roles().get(clientBRoleRep.getName()).toRepresentation();
        scopesResource.realmLevel().add(List.of(realmRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeMappingsRealmLevelPath((String)idA), List.of(realmRoleRep), (ResourceType)ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(idB).add(List.of(clientBRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeMappingsClientLevelPath((String)idA, (String)idB), List.of(clientBRoleRep), (ResourceType)ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[]{realmRoleRep.getName()});
        Assert.assertNames((List)scopesResource.clientLevel(idB).listAll(), (String[])new String[]{clientBRoleRep.getName()});
        this.managedRealm.admin().roles().deleteRole(realmRoleRep.getName());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.roleResourcePath((String)realmRoleRep.getName()), (ResourceType)ResourceType.REALM_ROLE);
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[0]);
        Assert.assertNames((List)scopesResource.clientLevel(idB).listAll(), (String[])new String[]{clientBRoleRep.getName()});
        this.managedRealm.admin().clients().get(idB).roles().deleteRole(clientBRoleRep.getName());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientRoleResourcePath((String)idB, (String)clientBRoleRep.getName()), (ResourceType)ResourceType.CLIENT_ROLE);
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[0]);
        Assert.assertNames((List)scopesResource.clientLevel(idB).listAll(), (String[])new String[0]);
    }

    public void protocolMappersTest(String clientDbId, ProtocolMappersResource mappersResource) {
        List protocolMappers = mappersResource.getMappers();
        String emailMapperId = null;
        String usernameMapperId = null;
        String fooMapperId = null;
        for (ProtocolMapperRepresentation mapper : protocolMappers) {
            if (mapper.getName().equals("email")) {
                emailMapperId = mapper.getId();
                continue;
            }
            if (mapper.getName().equals("username")) {
                usernameMapperId = mapper.getId();
                continue;
            }
            if (!mapper.getName().equals("foo")) continue;
            fooMapperId = mapper.getId();
        }
        Assertions.assertNull(emailMapperId);
        Assertions.assertNull(usernameMapperId);
        Assertions.assertNull(fooMapperId);
        ProtocolMapperRepresentation fooMapper = new ProtocolMapperRepresentation();
        fooMapper.setName("foo");
        fooMapper.setProtocol("openid-connect");
        fooMapper.setProtocolMapper("oidc-hardcoded-claim-mapper");
        Response response = mappersResource.createMapper(fooMapper);
        String location = response.getLocation().toString();
        fooMapperId = location.substring(location.lastIndexOf("/") + 1);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)clientDbId, (String)fooMapperId), (Object)fooMapper, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        fooMapper = mappersResource.getMapperById(fooMapperId);
        Assertions.assertEquals((Object)"foo", (Object)fooMapper.getName());
        mappersResource.update(fooMapperId, fooMapper);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientProtocolMapperPath((String)clientDbId, (String)fooMapperId), (Object)fooMapper, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        fooMapper = mappersResource.getMapperById(fooMapperId);
        mappersResource.delete(fooMapperId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientProtocolMapperPath((String)clientDbId, (String)fooMapperId), (ResourceType)ResourceType.PROTOCOL_MAPPER);
        String finalFooMapperId = fooMapperId;
        Assertions.assertThrows(NotFoundException.class, () -> mappersResource.getMapperById(finalFooMapperId), (String)"Not expected to find deleted mapper");
    }

    @Test
    public void updateClientWithProtocolMapper() {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setClientId("my-app");
        ProtocolMapperRepresentation fooMapper = new ProtocolMapperRepresentation();
        fooMapper.setName("foo");
        fooMapper.setProtocol("openid-connect");
        fooMapper.setProtocolMapper("oidc-hardcoded-claim-mapper");
        rep.setProtocolMappers(Collections.singletonList(fooMapper));
        Response response = this.managedRealm.admin().clients().create(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(id).remove());
        ClientResource clientResource = this.managedRealm.admin().clients().get(id);
        Assertions.assertNotNull((Object)clientResource);
        ClientRepresentation client = clientResource.toRepresentation();
        List protocolMappers = client.getProtocolMappers();
        Assertions.assertEquals((int)1, (int)protocolMappers.size());
        ProtocolMapperRepresentation mapper = (ProtocolMapperRepresentation)protocolMappers.get(0);
        Assertions.assertEquals((Object)"foo", (Object)mapper.getName());
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setId(client.getId());
        newClient.setClientId(client.getClientId());
        ProtocolMapperRepresentation barMapper = new ProtocolMapperRepresentation();
        barMapper.setName("bar");
        barMapper.setProtocol("openid-connect");
        barMapper.setProtocolMapper("oidc-hardcoded-role-mapper");
        protocolMappers.add(barMapper);
        newClient.setProtocolMappers(protocolMappers);
        this.managedRealm.admin().clients().get(client.getId()).update(newClient);
        ClientRepresentation storedClient = this.managedRealm.admin().clients().get(client.getId()).toRepresentation();
        ClientTest.assertClient(client, storedClient);
    }

    public static void assertClient(ClientRepresentation client, ClientRepresentation storedClient) {
        List protocolMappers;
        List webOrigins;
        List redirectUris;
        if (client.getClientId() != null) {
            Assert.assertEquals((Object)client.getClientId(), (Object)storedClient.getClientId());
        }
        if (client.getName() != null) {
            Assert.assertEquals((Object)client.getName(), (Object)storedClient.getName());
        }
        if (client.isEnabled() != null) {
            Assert.assertEquals((Object)client.isEnabled(), (Object)storedClient.isEnabled());
        }
        if (client.isAlwaysDisplayInConsole() != null) {
            Assert.assertEquals((Object)client.isAlwaysDisplayInConsole(), (Object)storedClient.isAlwaysDisplayInConsole());
        }
        if (client.isBearerOnly() != null) {
            Assert.assertEquals((Object)client.isBearerOnly(), (Object)storedClient.isBearerOnly());
        }
        if (client.isPublicClient() != null) {
            Assert.assertEquals((Object)client.isPublicClient(), (Object)storedClient.isPublicClient());
        }
        if (client.isFullScopeAllowed() != null) {
            Assert.assertEquals((Object)client.isFullScopeAllowed(), (Object)storedClient.isFullScopeAllowed());
        }
        if (client.getRootUrl() != null) {
            Assert.assertEquals((Object)client.getRootUrl(), (Object)storedClient.getRootUrl());
        }
        if (client.getAdminUrl() != null) {
            Assert.assertEquals((Object)client.getAdminUrl(), (Object)storedClient.getAdminUrl());
        }
        if (client.getBaseUrl() != null) {
            Assert.assertEquals((Object)client.getBaseUrl(), (Object)storedClient.getBaseUrl());
        }
        if (client.isSurrogateAuthRequired() != null) {
            Assert.assertEquals((Object)client.isSurrogateAuthRequired(), (Object)storedClient.isSurrogateAuthRequired());
        }
        if (client.getClientAuthenticatorType() != null) {
            Assert.assertEquals((Object)client.getClientAuthenticatorType(), (Object)storedClient.getClientAuthenticatorType());
        }
        if (client.getSecret() != null) {
            Assert.assertEquals((Object)client.getSecret(), (Object)storedClient.getSecret());
        }
        if (client.getNotBefore() != null) {
            Assertions.assertEquals((Integer)client.getNotBefore(), (Integer)storedClient.getNotBefore());
        }
        if (client.getDefaultRoles() != null) {
            Set<String> set = Set.of(client.getDefaultRoles());
            Set<String> storedSet = Set.of(storedClient.getDefaultRoles());
            Assertions.assertEquals(set, storedSet);
        }
        if ((redirectUris = client.getRedirectUris()) != null) {
            HashSet set = new HashSet(client.getRedirectUris());
            HashSet storedSet = new HashSet(storedClient.getRedirectUris());
            Assertions.assertEquals(set, storedSet);
        }
        if ((webOrigins = client.getWebOrigins()) != null) {
            HashSet set = new HashSet(client.getWebOrigins());
            HashSet storedSet = new HashSet(storedClient.getWebOrigins());
            Assertions.assertEquals(set, storedSet);
        }
        if ((protocolMappers = client.getProtocolMappers()) != null) {
            Set set = protocolMappers.stream().map(ProtocolMapperRepresentation::getName).collect(Collectors.toSet());
            Set storedSet = storedClient.getProtocolMappers().stream().map(ProtocolMapperRepresentation::getName).collect(Collectors.toSet());
            Assertions.assertEquals(set, storedSet);
        }
    }

    private RoleRepresentation createRealmRole(String roleName) {
        RoleRepresentation role = RoleConfigBuilder.create().name(roleName).build();
        this.managedRealm.admin().roles().create(role);
        String createdId = this.managedRealm.admin().roles().get(role.getName()).toRepresentation().getId();
        this.managedRealm.cleanup().add(r -> r.rolesById().deleteRole(createdId));
        return role;
    }

    private static class ClientTestRealmConfig
    implements RealmConfig {
        private ClientTestRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.addUser("test-user@localhost").enabled(true).email("test-user@localhost").name("Tom", "Brady").password("password");
            return realm;
        }
    }
}

