/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.admin.client.resource.ComponentsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServerWrapper;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.components.TestComponentProvider;
import org.keycloak.testsuite.components.TestComponentProviderFactory;

@KeycloakIntegrationTest(config=ComponentsTestServerConfig.class)
public class ComponentsTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    @InjectAdminEvents
    AdminEvents adminEvents;
    private static final Logger log = Logger.getLogger(ComponentsTest.class);
    private ComponentsResource components;
    private volatile CountDownLatch remainingDeleteSubmissions;
    private static final int NUMBER_OF_THREADS = 4;
    private static final int NUMBER_OF_TASKS = 20;
    private static final int NUMBER_OF_CHILDREN = 3;

    @BeforeEach
    public void before() throws Exception {
        this.components = this.managedRealm.admin().components();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrency(BiConsumer<ExecutorService, Integer> taskCreator) throws InterruptedException {
        ExecutorService s = Executors.newFixedThreadPool(4, (ThreadFactory)new BasicThreadFactory.Builder().daemon(true).uncaughtExceptionHandler((t, e) -> log.error((Object)e.getMessage(), e)).build());
        this.remainingDeleteSubmissions = new CountDownLatch(20);
        for (int i = 0; i < 20; ++i) {
            taskCreator.accept(s, i);
        }
        try {
            Assertions.assertTrue((boolean)this.remainingDeleteSubmissions.await(100L, TimeUnit.SECONDS), (String)"Did not create all components in time");
            s.shutdown();
            Assertions.assertTrue((boolean)s.awaitTermination(100L, TimeUnit.SECONDS), (String)"Did not finish before timeout");
        }
        finally {
            s.shutdownNow();
        }
    }

    @Test
    public void testConcurrencyWithoutChildren() throws InterruptedException {
        this.testConcurrency((s, i) -> s.submit(new CreateAndDeleteComponent((ExecutorService)s, (int)i)));
    }

    @Test
    public void testConcurrencyWithChildren() throws InterruptedException {
        this.testConcurrency((s, i) -> s.submit(new CreateAndDeleteComponentWithFlatChildren((ExecutorService)s, (int)i)));
    }

    @Test
    public void testNotDeadlocked() {
        for (int i = 0; i < 50; ++i) {
            ComponentRepresentation rep = this.createComponentRepresentation("test-" + i);
            rep.getConfig().putSingle((Object)"required", (Object)"required-value");
            this.createComponent(rep);
            List list = this.components.query(this.managedRealm.getId(), TestComponentProvider.class.getName());
            Assertions.assertEquals((int)(i + 1), (int)list.size());
        }
    }

    @Test
    public void testCreateValidation() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        this.createComponentAndAssertError(rep, "'Required' is required");
        rep.getConfig().putSingle((Object)"required", (Object)"Required");
        rep.getConfig().putSingle((Object)"number", (Object)"invalid");
        this.createComponentAndAssertError(rep, "'Number' should be a number");
    }

    @Test
    public void testCreateEmptyValues() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)"");
        rep.getConfig().put((Object)"val2", null);
        rep.getConfig().put((Object)"val3", Collections.emptyList());
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((Object)"foo", (Object)returned.getSubType());
        Assertions.assertEquals((int)1, (int)returned.getConfig().size());
        Assertions.assertTrue((boolean)returned.getConfig().containsKey((Object)"required"));
    }

    @Test
    public void testCreateWithoutGivenId() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.setId(null);
        String id = this.createComponent(rep);
        Assertions.assertNotNull((Object)id);
    }

    @Test
    public void testCreateWithGivenId() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        String componentId = KeycloakModelUtils.generateId();
        rep.setId(componentId);
        String id = this.createComponent(rep);
        Assertions.assertEquals((Object)componentId, (Object)id);
    }

    @Test
    public void failCreateWithLongName() {
        StringBuilder name = new StringBuilder();
        while (name.length() < 30) {
            name.append("invalid");
        }
        ComponentRepresentation rep = this.createComponentRepresentation(name.toString());
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        try (Response response = this.components.add(rep);){
            if (Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() == response.getStatus()) {
                Assertions.assertFalse((boolean)this.components.query().stream().map(ComponentRepresentation::getName).anyMatch(name.toString()::equals));
            } else if (Response.Status.CREATED.getStatusCode() == response.getStatus()) {
                String id = ApiUtil.getCreatedId((Response)response);
                Assertions.assertNotNull((Object)this.components.component(id).toRepresentation());
            } else {
                Assertions.fail((String)"Unexpected response");
            }
        }
    }

    @Test
    public void testUpdate() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)"one");
        rep.getConfig().addFirst((Object)"val2", (Object)"two");
        rep.getConfig().addFirst((Object)"val3", (Object)"three");
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((int)4, (int)returned.getConfig().size());
        Assertions.assertEquals((Object)"foo", (Object)returned.getConfig().getFirst((Object)"required"));
        Assertions.assertEquals((Object)"one", (Object)returned.getConfig().getFirst((Object)"val1"));
        Assertions.assertEquals((Object)"two", (Object)returned.getConfig().getFirst((Object)"val2"));
        Assertions.assertEquals((Object)"three", (Object)returned.getConfig().getFirst((Object)"val3"));
        returned.getConfig().putSingle((Object)"val1", (Object)"one-updated");
        returned.getConfig().putSingle((Object)"not-a-config-key", (Object)"ten");
        returned.getConfig().putSingle((Object)"val2", null);
        this.components.component(id).update(returned);
        returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((int)3, (int)returned.getConfig().size());
        Assertions.assertEquals((Object)"one-updated", (Object)returned.getConfig().getFirst((Object)"val1"));
        Assertions.assertFalse((boolean)returned.getConfig().containsKey((Object)"val2"));
        returned.getConfig().addFirst((Object)"val1", (Object)"");
        this.components.component(id).update(returned);
        returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((int)2, (int)returned.getConfig().size());
        returned.getConfig().put((Object)"val3", Collections.emptyList());
        this.components.component(id).update(returned);
        returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((int)1, (int)returned.getConfig().size());
    }

    @Test
    public void testRename() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((Object)"mycomponent", (Object)returned.getName());
        rep.setName("myupdatedcomponent");
        this.components.component(id).update(rep);
        returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((Object)"myupdatedcomponent", (Object)returned.getName());
    }

    @Test
    public void testSecretConfig() throws Exception {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"secret", (Object)"some secret value!!");
        rep.getConfig().addFirst((Object)"required", (Object)"some required value");
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((Object)"**********", (Object)returned.getConfig().getFirst((Object)"secret"));
        AdminEventRepresentation event = (AdminEventRepresentation)this.adminEvents.poll();
        Assertions.assertFalse((boolean)event.getRepresentation().contains("some secret value!!"));
        Assertions.assertTrue((boolean)event.getRepresentation().contains("**********"));
        Map<String, TestComponentProvider.DetailsRepresentation> details = ((ComponentsDetails)this.runOnServer.fetch((FetchOnServerWrapper)new TestComponents())).componentsDetailsMap();
        Assertions.assertEquals((Object)"some secret value!!", ((List)details.get("mycomponent").getConfig().get("secret")).get(0));
        returned.getConfig().putSingle((Object)"priority", (Object)"200");
        this.components.component(id).update(returned);
        ComponentRepresentation returned2 = this.components.component(id).toRepresentation();
        Assertions.assertEquals((Object)"**********", (Object)returned2.getConfig().getFirst((Object)"secret"));
        event = (AdminEventRepresentation)this.adminEvents.poll();
        MatcherAssert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"some secret value!!")));
        MatcherAssert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.containsString((String)"**********"));
        details = ((ComponentsDetails)this.runOnServer.fetch((FetchOnServerWrapper)new TestComponents())).componentsDetailsMap();
        Assertions.assertEquals((Object)"some secret value!!", ((List)details.get("mycomponent").getConfig().get("secret")).get(0));
        returned2.getConfig().putSingle((Object)"secret", (Object)"updated secret value!!");
        this.components.component(id).update(returned2);
        details = ((ComponentsDetails)this.runOnServer.fetch((FetchOnServerWrapper)new TestComponents())).componentsDetailsMap();
        Assertions.assertEquals((Object)"updated secret value!!", ((List)details.get("mycomponent").getConfig().get("secret")).get(0));
        ComponentRepresentation returned3 = this.components.query().stream().filter(c -> c.getId().equals(returned2.getId())).findFirst().get();
        Assertions.assertEquals((Object)"**********", (Object)returned3.getConfig().getFirst((Object)"secret"));
        returned2.getConfig().putSingle((Object)"secret", (Object)"${vault.value}");
        this.components.component(id).update(returned2);
        details = ((ComponentsDetails)this.runOnServer.fetch((FetchOnServerWrapper)new TestComponents())).componentsDetailsMap();
        MatcherAssert.assertThat((Object)((List)details.get("mycomponent").getConfig().get("secret")), (Matcher)Matchers.contains((Object[])new String[]{"${vault.value}"}));
        ComponentRepresentation returned4 = this.components.query().stream().filter(c -> c.getId().equals(returned2.getId())).findFirst().get();
        MatcherAssert.assertThat((Object)((List)returned4.getConfig().get((Object)"secret")), (Matcher)Matchers.contains((Object[])new String[]{"${vault.value}"}));
    }

    @Test
    public void testCreateLongValue() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        String randomLongString = RandomStringUtils.random((int)5000, (boolean)true, (boolean)true);
        rep.getConfig().putSingle((Object)"required", (Object)"Required");
        rep.getConfig().putSingle((Object)"val1", (Object)randomLongString);
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        MatcherAssert.assertThat((Object)returned.getConfig().size(), (Matcher)Matchers.equalTo((Object)2));
        Assertions.assertNotNull((Object)returned.getConfig().getFirst((Object)"val1"));
        MatcherAssert.assertThat((Object)((String)returned.getConfig().getFirst((Object)"val1")), (Matcher)Matchers.equalTo((Object)randomLongString));
    }

    @Test
    public void testLongValueInComponentConfigAscii() throws Exception {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        String value = StringUtils.repeat((String)"0123456789", (int)400);
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)value);
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((Object)value, (Object)returned.getConfig().getFirst((Object)"val1"));
    }

    @Test
    public void testLongValueInComponentConfigExtLatin() throws Exception {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        String value = StringUtils.repeat((String)"\u011b\u0161\u010d\u0159\u017e\u00fd\u00ed\u016e\u00cd\u00c1", (int)400);
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)value);
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assertions.assertEquals((Object)value, (Object)returned.getConfig().getFirst((Object)"val1"));
    }

    private String createComponent(ComponentRepresentation rep) {
        return this.createComponent(this.managedRealm.admin(), rep);
    }

    private String createComponent(RealmResource realm, ComponentRepresentation rep) {
        ComponentsResource components = realm.components();
        Response response = components.add(rep);
        return ApiUtil.getCreatedId((Response)response);
    }

    private void createComponentAndAssertError(ComponentRepresentation rep, String error) {
        ComponentsResource components = this.managedRealm.admin().components();
        Response response = components.add(rep);
        if (!response.hasEntity()) {
            Assertions.fail((String)"No error message set");
        }
        ErrorRepresentation errorRepresentation = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assertions.assertEquals((Object)error, (Object)errorRepresentation.getErrorMessage());
    }

    private ComponentRepresentation createComponentRepresentation(String name) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId(this.managedRealm.getId());
        rep.setProviderId("test-component");
        rep.setProviderType(TestComponentProvider.class.getName());
        rep.setSubType("foo");
        MultivaluedHashMap config = new MultivaluedHashMap();
        rep.setConfig(config);
        return rep;
    }

    public static class TestComponents
    implements FetchOnServerWrapper<ComponentsDetails> {
        public FetchOnServer getRunOnServer() {
            return (FetchOnServer & Serializable)session -> {
                RealmModel realm = session.getContext().getRealm();
                return new ComponentsDetails(realm.getComponentsStream(realm.getId(), TestComponentProvider.class.getName()).collect(Collectors.toMap(ComponentModel::getName, componentModel -> {
                    ProviderFactory f = session.getKeycloakSessionFactory().getProviderFactory(TestComponentProvider.class, componentModel.getProviderId());
                    TestComponentProviderFactory factory = (TestComponentProviderFactory)f;
                    TestComponentProvider p = (TestComponentProvider)factory.create(session, componentModel);
                    return p.getDetails();
                })));
            };
        }

        public Class<ComponentsDetails> getResultClass() {
            return ComponentsDetails.class;
        }
    }

    private record ComponentsDetails(Map<String, TestComponentProvider.DetailsRepresentation> componentsDetailsMap) {
    }

    private class CreateAndDeleteComponentWithFlatChildren
    extends CreateAndDeleteComponent {
        public CreateAndDeleteComponentWithFlatChildren(ExecutorService s, int i) {
            super(s, i);
        }

        @Override
        protected void createChildren(String id) {
            for (int j = 0; j < 3; ++j) {
                ComponentRepresentation rep = ComponentsTest.this.createComponentRepresentation("test-" + this.i + ":" + j);
                rep.setParentId(id);
                rep.getConfig().putSingle((Object)"required", (Object)"required-value");
                MatcherAssert.assertThat((Object)ComponentsTest.this.createComponent(this.realm, rep), (Matcher)Matchers.notNullValue());
            }
        }
    }

    private class CreateAndDeleteComponent
    extends CreateComponent {
        public CreateAndDeleteComponent(ExecutorService s, int i) {
            super(s, i);
        }

        @Override
        protected void scheduleDeleteComponent(String id) {
            this.s.submit(new DeleteComponent(id));
        }
    }

    public static class ComponentsTestServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.dependency("org.keycloak.tests", "keycloak-tests-custom-providers");
        }
    }

    private class DeleteComponent
    implements Runnable {
        private final String id;

        public DeleteComponent(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            log.debugf("Started, id=%s", (Object)this.id);
            ComponentResource c = ComponentsTest.this.managedRealm.admin().components().component(this.id);
            MatcherAssert.assertThat((Object)c.toRepresentation(), (Matcher)Matchers.notNullValue());
            c.remove();
            log.debugf("Finished, id=%s", (Object)this.id);
        }
    }

    private class CreateComponentWithFlatChildren
    extends CreateComponent {
        public CreateComponentWithFlatChildren(ExecutorService s, int i, RealmResource realm) {
            super(s, i, realm);
        }

        public CreateComponentWithFlatChildren(ExecutorService s, int i) {
            super(s, i);
        }

        @Override
        protected void createChildren(String id) {
            for (int j = 0; j < 3; ++j) {
                ComponentRepresentation rep = ComponentsTest.this.createComponentRepresentation("test-" + this.i + ":" + j);
                rep.setParentId(id);
                rep.getConfig().putSingle((Object)"required", (Object)"required-value");
                MatcherAssert.assertThat((Object)ComponentsTest.this.createComponent(this.realm, rep), (Matcher)Matchers.notNullValue());
            }
        }
    }

    private class CreateComponent
    implements Runnable {
        protected final ExecutorService s;
        protected final int i;
        protected final RealmResource realm;

        public CreateComponent(ExecutorService s, int i, RealmResource realm) {
            this.s = s;
            this.i = i;
            this.realm = realm;
        }

        public CreateComponent(ExecutorService s, int i) {
            this(s, i, componentsTest.managedRealm.admin());
        }

        @Override
        public void run() {
            log.debugf("Started for i=%d ", this.i);
            ComponentRepresentation rep = ComponentsTest.this.createComponentRepresentation("test-" + this.i);
            rep.getConfig().putSingle((Object)"required", (Object)"required-value");
            rep.setParentId(this.realm.toRepresentation().getId());
            String id = ComponentsTest.this.createComponent(this.realm, rep);
            MatcherAssert.assertThat((Object)id, (Matcher)Matchers.notNullValue());
            this.createChildren(id);
            log.debugf("Finished: i=%d, id=%s", this.i, (Object)id);
            this.scheduleDeleteComponent(id);
            ComponentsTest.this.remainingDeleteSubmissions.countDown();
        }

        protected void scheduleDeleteComponent(String id) {
        }

        protected void createChildren(String id) {
        }
    }
}

