/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.Events;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.ConsentPage;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.AccountHelper;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.AuthorizationEndpointResponse;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest
public class ConsentsTest {
    @InjectRealm(ref="user")
    ManagedRealm userRealm;
    @InjectRealm(ref="consumer", config=ConsumerRealmConf.class, lifecycle=LifeCycle.METHOD)
    ManagedRealm consumerRealm;
    @InjectRealm(ref="provider", lifecycle=LifeCycle.METHOD)
    ManagedRealm providerRealm;
    @InjectUser(ref="user", realmRef="user", config=UserRealmUserConf.class)
    ManagedUser userFromUserRealm;
    @InjectUser(ref="provider", realmRef="provider", config=ProviderRealmUserConf.class)
    ManagedUser userFromProviderRealm;
    @InjectClient(realmRef="provider", config=ProviderRealmClientConf.class)
    ManagedClient providerRealmClient;
    @InjectOAuthClient(ref="user", realmRef="user")
    OAuthClient userRealmOAuth;
    @InjectOAuthClient(ref="consumer", realmRef="consumer")
    OAuthClient consumerRealmOAuth;
    @InjectOAuthClient(ref="provider", realmRef="provider")
    OAuthClient providerRealmOAuth;
    @InjectEvents(realmRef="user")
    Events userRealmEvents;
    @InjectWebDriver
    WebDriver driver;
    @InjectPage
    LoginPage loginPage;
    @InjectPage
    ConsentPage consentPage;
    private static final Logger LOGGER = Logger.getLogger(ConsentsTest.class);
    private static final String REALM_PROV_NAME = "provider";
    private static final String REALM_CONS_NAME = "consumer";
    private static final String IDP_OIDC_ALIAS = "kc-oidc-idp";
    private static final String IDP_OIDC_PROVIDER_ID = "keycloak-oidc";
    private static final String CLIENT_ID = "brokerapp";
    private static final String CLIENT_SECRET = "secret";

    @Test
    public void testConsents() {
        this.consumerRealmOAuth.openLoginForm();
        LOGGER.debug((Object)"Clicking social kc-oidc-idp");
        this.loginPage.clickSocial(IDP_OIDC_ALIAS);
        if (!this.driver.getCurrentUrl().contains("/realms/" + this.providerRealm.getName() + "/")) {
            LOGGER.debug((Object)("Not on provider realm page, url: " + this.driver.getCurrentUrl()));
        }
        Assertions.assertTrue((boolean)this.driver.getCurrentUrl().contains("/realms/" + this.providerRealm.getName() + "/"), (String)"Driver should be on the provider realm page right now");
        LOGGER.debug((Object)"Logging in");
        this.loginPage.fillLogin(this.userFromProviderRealm.getUsername(), this.userFromProviderRealm.getPassword());
        this.loginPage.submit();
        this.consentPage.waitForPage();
        this.consentPage.assertCurrent();
        this.consentPage.confirm();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"), (String)"Test user should be successfully logged in.");
        UsersResource consumerUsers = this.consumerRealm.admin().users();
        Assertions.assertTrue((consumerUsers.count() > 0 ? 1 : 0) != 0, (String)"There must be at least one user");
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(5));
        UserRepresentation foundUser = null;
        for (UserRepresentation userRep : users) {
            if (!userRep.getUsername().equals(this.userFromProviderRealm.getUsername()) || !userRep.getEmail().equals(this.userFromProviderRealm.admin().toRepresentation().getEmail())) continue;
            foundUser = userRep;
            break;
        }
        Assertions.assertNotNull(foundUser, (String)("There must be user " + this.userFromProviderRealm.getUsername() + " in realm " + this.consumerRealm.getName()));
        users = this.providerRealm.admin().users().search(null, foundUser.getFirstName(), foundUser.getLastName(), null, Integer.valueOf(0), Integer.valueOf(1));
        Assertions.assertEquals((int)1, (int)users.size(), (String)"Same user should be in provider realm");
        String userId = ((UserRepresentation)users.get(0)).getId();
        UserResource userResource = this.providerRealm.admin().users().get(userId);
        List consents = userResource.getConsents();
        Assertions.assertEquals((int)1, (int)consents.size(), (String)"There should be one consent");
        Map consent = (Map)consents.get(0);
        Assertions.assertEquals((Object)CLIENT_ID, consent.get("clientId"), (String)"Consent should be given to brokerapp");
        List sessions = userResource.getUserSessions();
        Assertions.assertEquals((int)1, (int)sessions.size(), (String)"There should be one active session");
        Assertions.assertEquals((int)1, (int)((UserSessionRepresentation)sessions.get(0)).getClients().size(), (String)"There should be one client in user session");
        userResource.revokeConsent(CLIENT_ID);
        consents = userResource.getConsents();
        Assertions.assertEquals((int)0, (int)consents.size(), (String)"There should be no consents");
        sessions = userResource.getUserSessions();
        Assertions.assertEquals((int)1, (int)sessions.size(), (String)"There should be one active session");
        Assertions.assertEquals((int)0, (int)((UserSessionRepresentation)sessions.get(0)).getClients().size(), (String)"There should be no client in user session");
        AccountHelper.logout((RealmResource)this.providerRealm.admin(), (String)this.userFromProviderRealm.getUsername());
    }

    @Test
    public void testRetrieveConsentsForUserWithClientsWithGrantedOfflineAccess() throws Exception {
        RealmRepresentation providerRealmRep = this.providerRealm.admin().toRepresentation();
        providerRealmRep.setAccountTheme("keycloak");
        this.providerRealm.admin().update(providerRealmRep);
        this.providerRealm.admin().clients().create(ClientConfigBuilder.create().clientId("test-app").redirectUris(new String[]{"*"}).publicClient(true).webOrigins(new String[]{"*"}).build());
        ClientRepresentation providerAccountRep = (ClientRepresentation)this.providerRealm.admin().clients().findByClientId("test-app").get(0);
        ClientScopeRepresentation offlineAccessScope = this.providerRealm.admin().getDefaultOptionalClientScopes().stream().filter(csr -> csr.getName().equals("offline_access")).findFirst().get();
        this.providerRealm.admin().clients().get(providerAccountRep.getId()).removeOptionalClientScope(offlineAccessScope.getId());
        this.providerRealm.admin().clients().get(providerAccountRep.getId()).addDefaultClientScope(offlineAccessScope.getId());
        providerAccountRep.setConsentRequired(Boolean.valueOf(true));
        providerAccountRep.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        this.providerRealm.admin().clients().get(providerAccountRep.getId()).update(providerAccountRep);
        this.providerRealmOAuth.openLoginForm();
        this.loginPage.waitForPage();
        LOGGER.debug((Object)"Logging in");
        this.loginPage.fillLogin(this.userFromProviderRealm.getUsername(), this.userFromProviderRealm.getPassword());
        this.loginPage.submit();
        this.consentPage.waitForPage();
        LOGGER.debug((Object)"Grant consent for offline_access");
        this.consentPage.assertCurrent();
        this.consentPage.confirm();
        providerAccountRep.setConsentRequired(Boolean.valueOf(false));
        this.providerRealm.admin().clients().get(providerAccountRep.getId()).update(providerAccountRep);
        LOGGER.debug((Object)"Obtain offline_token");
        AccessTokenResponse response = ((OAuthClient)this.providerRealmOAuth.scope("openid profile offline_access")).doPasswordGrantRequest(this.userFromProviderRealm.getUsername(), this.userFromProviderRealm.getPassword());
        Assertions.assertNotNull((Object)response.getRefreshToken());
        LOGGER.debug((Object)"Check for Offline Token in consents");
        List consents = this.providerRealm.admin().users().get(this.userFromProviderRealm.getId()).getConsents();
        Assertions.assertFalse((boolean)consents.isEmpty(), (String)"Consents should not be empty");
        Assertions.assertTrue((boolean)consents.toString().contains("Offline Token"));
        AccountHelper.logout((RealmResource)this.providerRealm.admin(), (String)this.userFromProviderRealm.getUsername());
    }

    @Test
    public void testConsentCancel() {
        ClientResource accountClient = ApiUtil.findClientByClientId((RealmResource)this.providerRealm.admin(), (String)"test-app");
        ClientRepresentation clientRepresentation = accountClient.toRepresentation();
        clientRepresentation.setConsentRequired(Boolean.valueOf(true));
        accountClient.update(clientRepresentation);
        this.providerRealmOAuth.openLoginForm();
        this.loginPage.fillLogin(this.userFromProviderRealm.getUsername(), this.userFromProviderRealm.getPassword());
        this.loginPage.submit();
        this.consentPage.assertCurrent();
        this.consentPage.cancel();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"));
        Assertions.assertTrue((boolean)this.driver.getCurrentUrl().contains("error=access_denied"));
        this.providerRealmOAuth.openLoginForm();
        this.loginPage.fillLogin(this.userFromProviderRealm.getUsername(), this.userFromProviderRealm.getPassword());
        this.loginPage.submit();
        this.consentPage.confirm();
        Assertions.assertFalse((boolean)this.driver.getCurrentUrl().contains("error"));
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"), (String)"Test user should be successfully logged in.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientConsentRequiredAfterLogin() {
        AuthorizationEndpointResponse response = this.userRealmOAuth.doLogin(this.userFromUserRealm.getUsername(), this.userFromUserRealm.getPassword());
        AccessTokenResponse accessTokenResponse = this.userRealmOAuth.doAccessTokenRequest(response.getCode());
        Assertions.assertNotNull((Object)this.userRealmOAuth.parseLoginResponse().getCode());
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"), (String)"Test user should be successfully logged in.");
        EventRepresentation loginEvent = (EventRepresentation)this.userRealmEvents.poll();
        Assertions.assertNotNull((Object)loginEvent);
        Assertions.assertEquals((Object)this.userFromUserRealm.getId(), (Object)loginEvent.getUserId());
        Assertions.assertEquals((Object)EventType.LOGIN.toString(), (Object)loginEvent.getType());
        loginEvent.getDetails().forEach((key, value) -> {
            switch (key) {
                case "code_id": {
                    Assertions.assertTrue((boolean)this.isUUID((String)value));
                    break;
                }
                case "username": {
                    Assertions.assertEquals((Object)this.userFromUserRealm.getUsername(), (Object)value);
                    break;
                }
                case "consent": {
                    Assertions.assertEquals((Object)"no_consent_required", (Object)value);
                    break;
                }
                case "redirect_uri": {
                    Assertions.assertEquals((Object)"http://127.0.0.1:8500/callback/oauth", (Object)value);
                }
            }
        });
        this.userRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.enabledEventTypes(new String[]{"REFRESH_TOKEN_ERROR"})});
        String sessionId = loginEvent.getSessionId();
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.userRealm.admin().clients().findByClientId("test-app").get(0);
        try {
            clientRepresentation.setConsentRequired(Boolean.valueOf(true));
            this.userRealm.admin().clients().get(clientRepresentation.getId()).update(clientRepresentation);
            this.userRealmEvents.clear();
            AccessTokenResponse refreshTokenResponse = this.userRealmOAuth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken());
            Assertions.assertEquals((Object)"invalid_scope", (Object)refreshTokenResponse.getError());
            Assertions.assertEquals((Object)"Client no longer has requested consent from user", (Object)refreshTokenResponse.getErrorDescription());
            EventRepresentation refreshEvent = (EventRepresentation)this.userRealmEvents.poll();
            Assertions.assertNotNull((Object)refreshEvent);
            Assertions.assertNull((Object)refreshEvent.getUserId());
            Assertions.assertEquals((Object)EventType.REFRESH_TOKEN_ERROR.toString(), (Object)refreshEvent.getType());
            Assertions.assertNull((Object)refreshTokenResponse.getRefreshToken());
            Assertions.assertEquals((Object)sessionId, (Object)refreshEvent.getSessionId());
            Assertions.assertEquals((Object)"invalid_token", (Object)refreshEvent.getError());
        }
        finally {
            clientRepresentation.setConsentRequired(Boolean.valueOf(false));
            this.userRealm.admin().clients().get(clientRepresentation.getId()).update(clientRepresentation);
        }
        AccountHelper.logout((RealmResource)this.userRealm.admin(), (String)this.userFromUserRealm.getUsername());
    }

    @Test
    public void testConsentWithAdditionalClientAttributes() {
        ClientResource accountClient = ApiUtil.findClientByClientId((RealmResource)this.providerRealm.admin(), (String)"test-app");
        ClientRepresentation clientRepresentation = accountClient.toRepresentation();
        clientRepresentation.setConsentRequired(Boolean.valueOf(true));
        clientRepresentation.getAttributes().put("logoUri", "https://www.keycloak.org/resources/images/keycloak_logo_480x108.png");
        clientRepresentation.getAttributes().put("policyUri", "https://www.keycloak.org/policy");
        clientRepresentation.getAttributes().put("tosUri", "https://www.keycloak.org/tos");
        accountClient.update(clientRepresentation);
        this.providerRealmOAuth.openLoginForm();
        this.loginPage.fillLogin(this.userFromProviderRealm.getUsername(), this.userFromProviderRealm.getPassword());
        this.loginPage.submit();
        this.consentPage.assertCurrent();
        Assertions.assertTrue((boolean)this.driver.findElement(By.xpath((String)"//img[@src='https://www.keycloak.org/resources/images/keycloak_logo_480x108.png']")).isDisplayed(), (String)"logoUri must be presented");
        Assertions.assertTrue((boolean)this.driver.findElement(By.xpath((String)"//a[@href='https://www.keycloak.org/policy']")).isDisplayed(), (String)"policyUri must be presented");
        Assertions.assertTrue((boolean)this.driver.findElement(By.xpath((String)"//a[@href='https://www.keycloak.org/tos']")).isDisplayed(), (String)"tosUri must be presented");
        this.consentPage.confirm();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"), (String)"Test user should be successfully logged in.");
        AccountHelper.logout((RealmResource)this.providerRealm.admin(), (String)this.userFromProviderRealm.getUsername());
    }

    private static IdentityProviderRepresentation setUpIdentityProvider() {
        IdentityProviderRepresentation idp = ConsentsTest.createIdentityProvider(IDP_OIDC_ALIAS, IDP_OIDC_PROVIDER_ID);
        Map config = idp.getConfig();
        config.put("clientId", CLIENT_ID);
        config.put("clientSecret", CLIENT_SECRET);
        config.put("prompt", "login");
        config.put("authorizationUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/auth");
        config.put("tokenUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/token");
        config.put("logoutUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/logout");
        config.put("userInfoUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/userinfo");
        config.put("defaultScope", "email profile");
        config.put("backchannelSupported", "true");
        return idp;
    }

    private static IdentityProviderRepresentation createIdentityProvider(String alias, String providerId) {
        IdentityProviderRepresentation identityProviderRepresentation = new IdentityProviderRepresentation();
        identityProviderRepresentation.setAlias(alias);
        identityProviderRepresentation.setDisplayName(providerId);
        identityProviderRepresentation.setProviderId(providerId);
        identityProviderRepresentation.setEnabled(true);
        return identityProviderRepresentation;
    }

    private boolean isUUID(String uuid) {
        return 36 == uuid.length() && uuid.charAt(8) == '-' && uuid.charAt(13) == '-' && uuid.charAt(18) == '-' && uuid.charAt(23) == '-';
    }

    private static class ConsumerRealmConf
    implements RealmConfig {
        private ConsumerRealmConf() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder builder) {
            builder.identityProvider(ConsentsTest.setUpIdentityProvider());
            return builder;
        }
    }

    private static class ProviderRealmClientConf
    implements ClientConfig {
        private ProviderRealmClientConf() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder builder) {
            builder.clientId(ConsentsTest.CLIENT_ID);
            builder.name(ConsentsTest.CLIENT_ID);
            builder.secret(ConsentsTest.CLIENT_SECRET);
            builder.consentRequired(true);
            builder.redirectUris(new String[]{"http://localhost:8080/realms/consumer/broker/kc-oidc-idp/endpoint/*"});
            builder.adminUrl("http://localhost:8080/realms/consumer/broker/kc-oidc-idp/endpoint");
            return builder;
        }
    }

    private static class ProviderRealmUserConf
    implements UserConfig {
        private ProviderRealmUserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username(ConsentsTest.REALM_PROV_NAME);
            builder.password("password");
            builder.email("provider@local");
            builder.emailVerified(true);
            builder.name("Provider", "User");
            return builder;
        }
    }

    private static class UserRealmUserConf
    implements UserConfig {
        private UserRealmUserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username("user");
            builder.password("password");
            builder.email("user@local");
            builder.emailVerified(true);
            builder.name("Local", "User");
            return builder;
        }
    }
}

