/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Time;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class CrossRealmPermissionsTest {
    @InjectRealm(ref="realm1", config=CrossRealmPermissionsRealmConfig.class)
    ManagedRealm managedRealm1;
    @InjectRealm(ref="realm2", config=CrossRealmPermissionsRealmConfig.class)
    ManagedRealm managedRealm2;

    @Test
    public void users() {
        UserRepresentation user = UserConfigBuilder.create().username("randomuser-" + Time.currentTimeMillis()).build();
        String userUuid = ApiUtil.getCreatedId((Response)this.managedRealm1.admin().users().create(user));
        this.expectNotFound((RealmResource realm) -> realm.users().get(userUuid).toRepresentation(), this.managedRealm2.admin());
        this.expectNotFound((RealmResource realm) -> realm.users().get(userUuid).update(new UserRepresentation()), this.managedRealm2.admin());
        this.expectNotFound((RealmResource realm) -> realm.users().get(userUuid).remove(), this.managedRealm2.admin());
        this.expectNotFound((RealmResource realm) -> realm.users().get(userUuid).getUserSessions(), this.managedRealm2.admin());
    }

    private void expectNotFound(Invocation invocation, RealmResource realm) {
        this.expectNotFound((RealmResource realm1, AtomicReference<Response> response) -> invocation.invoke(realm1), realm);
    }

    private void expectNotFound(InvocationWithResponse invocation, RealmResource realm) {
        int statusCode = 0;
        try {
            AtomicReference<Response> responseReference = new AtomicReference<Response>();
            invocation.invoke(realm, responseReference);
            Response response = responseReference.get();
            if (response != null) {
                statusCode = response.getStatus();
            } else {
                Assertions.fail((String)"Expected failure");
            }
        }
        catch (ClientErrorException e) {
            statusCode = e.getResponse().getStatus();
        }
        Assertions.assertEquals((int)404, (int)statusCode);
    }

    private static interface Invocation {
        public void invoke(RealmResource var1);
    }

    private static interface InvocationWithResponse {
        public void invoke(RealmResource var1, AtomicReference<Response> var2);
    }

    private static class CrossRealmPermissionsRealmConfig
    implements RealmConfig {
        private CrossRealmPermissionsRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.addUser("realm-admin").clientRoles("realm-management", new String[]{"realm-admin"}).password("password");
            return realm;
        }
    }
}

