/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.userprofile.UserProfileUtil;
import org.keycloak.userprofile.DeclarativeUserProfileProvider;
import org.keycloak.userprofile.UserProfileProvider;

@KeycloakIntegrationTest
public class DeclarativeUserTest {
    @InjectRealm(config=DeclarativeRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    private static final String REQUIRED_ATTR_KEY = "required-attr";

    @BeforeEach
    public void onBefore() {
        UserProfileUtil.setUserProfileConfiguration((RealmResource)this.managedRealm.admin(), (String)"{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"aName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-a\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-hidden\"},{\"name\": \"attr1\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
    }

    @Test
    public void testDoNotReturnAttributeIfNotReadble() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "value1user1");
        user1.singleAttribute("attr2", "value2user1");
        String user1Id = this.createUserWithCleanup(user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Map attributes = user1.getAttributes();
        Assertions.assertEquals((int)2, (int)attributes.size());
        Assertions.assertFalse((boolean)attributes.containsKey("custom-hidden"));
        UserProfileUtil.setUserProfileConfiguration((RealmResource)this.managedRealm.admin(), (String)"{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"aName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-a\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-hidden\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr1\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        attributes = user1.getAttributes();
        Assertions.assertEquals((int)2, (int)attributes.size());
        Assertions.assertFalse((boolean)attributes.containsKey("custom-hidden"));
    }

    @Test
    public void testUpdateUnsetAttributeWithEmptyValue() {
        UserProfileUtil.setUserProfileConfiguration((RealmResource)this.managedRealm.admin(), (String)"{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr1\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\"}]}");
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "some-value");
        String user1Id = this.createUserWithCleanup(user1);
        UserProfileUtil.setUserProfileConfiguration((RealmResource)this.managedRealm.admin(), (String)"{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\"}]}");
        UserResource userResource = this.managedRealm.admin().users().get(user1Id);
        user1 = userResource.toRepresentation();
        Assertions.assertNull((Object)user1.getAttributes());
        user1.singleAttribute("attr2", "");
        userResource.update(user1);
        user1 = userResource.toRepresentation();
        Assertions.assertNull((Object)user1.getAttributes());
        user1.setAttributes(new HashMap());
        user1.getAttributes().put("attr2", null);
        userResource.update(user1);
        user1 = userResource.toRepresentation();
        Assertions.assertNull((Object)user1.getAttributes());
    }

    @Test
    public void testValidationUsingExistingAttributes() {
        UserProfileUtil.setUserProfileConfiguration((RealmResource)this.managedRealm.admin(), (String)"{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"required-attr\", \"required\": {}, \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute(REQUIRED_ATTR_KEY, "some-value");
        String user1Id = this.createUserWithCleanup(user1);
        UserResource userResource = this.managedRealm.admin().users().get(user1Id);
        user1 = userResource.toRepresentation();
        user1.setFirstName("changed");
        user1.setAttributes(null);
        userResource.update(user1);
        user1 = userResource.toRepresentation();
        Assertions.assertEquals((Object)"changed", (Object)user1.getFirstName());
        user1.setAttributes(Collections.emptyMap());
        String expectedErrorMessage = "error-user-attribute-required";
        this.verifyUserUpdateFails(this.managedRealm.admin().users(), user1Id, user1, expectedErrorMessage);
    }

    private void verifyUserUpdateFails(UsersResource usersResource, String userId, UserRepresentation user, String expectedErrorMessage) {
        UserResource userResource = usersResource.get(userId);
        try {
            userResource.update(user);
            Assertions.fail((String)("Should fail with errorMessage: " + expectedErrorMessage));
        }
        catch (BadRequestException badRequest) {
            try (Response response = badRequest.getResponse();){
                MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.equalTo((Object)400));
                ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
                MatcherAssert.assertThat((Object)error.getErrorMessage(), (Matcher)CoreMatchers.equalTo((Object)expectedErrorMessage));
            }
        }
    }

    @Test
    public void testDefaultUserProfileProviderIsActive() {
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            Set providers = session.getAllProviders(UserProfileProvider.class);
            MatcherAssert.assertThat((Object)providers, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)providers.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
            UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
            MatcherAssert.assertThat((Object)provider, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)DeclarativeUserProfileProvider.class.getName(), (Matcher)CoreMatchers.is((Object)provider.getClass().getName()));
            MatcherAssert.assertThat((Object)provider, (Matcher)CoreMatchers.instanceOf(DeclarativeUserProfileProvider.class));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserLocale() {
        RealmRepresentation realmRep = this.managedRealm.admin().toRepresentation();
        Boolean internationalizationEnabled = realmRep.isInternationalizationEnabled();
        realmRep.setInternationalizationEnabled(Boolean.valueOf(true));
        this.managedRealm.admin().update(realmRep);
        try {
            UserRepresentation user1 = new UserRepresentation();
            user1.setUsername("user1");
            user1.singleAttribute("locale", "pt_BR");
            String user1Id = this.createUserWithCleanup(user1);
            UserResource userResource = this.managedRealm.admin().users().get(user1Id);
            user1 = userResource.toRepresentation();
            Assertions.assertEquals((Object)"pt_BR", ((List)user1.getAttributes().get("locale")).get(0));
            realmRep.setInternationalizationEnabled(Boolean.valueOf(false));
            this.managedRealm.admin().update(realmRep);
            user1 = userResource.toRepresentation();
            Assertions.assertNull((Object)user1.getAttributes());
        }
        finally {
            realmRep.setInternationalizationEnabled(internationalizationEnabled);
            this.managedRealm.admin().update(realmRep);
        }
    }

    private String createUserWithCleanup(UserRepresentation userRep) {
        Response response = this.managedRealm.admin().users().create(userRep);
        String createdId = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.users().get(createdId).remove());
        return createdId;
    }

    public static class DeclarativeRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.internationalizationEnabled(true).supportedLocales(new String[]{"en", "de"});
            return realm;
        }
    }
}

