/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.Profile;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.admin.AdminClientFactory;
import org.keycloak.testframework.annotations.InjectAdminClientFactory;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;

@KeycloakIntegrationTest(config=IllegalAdminKeycloakServerConf.class)
public class IllegalAdminUpgradeTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectRealm(ref="master", attachTo="master")
    ManagedRealm masterRealm;
    @InjectAdminClientFactory
    AdminClientFactory adminClientFactory;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    private static final String REALM_NAME = "default";
    private static final String MASTER_REALM_NAME = "master";

    public static void setupUsers(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        RealmModel master = session.realms().getRealmByName(MASTER_REALM_NAME);
        ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
        ClientModel realmMasterAdminClient = realm.getMasterAdminClient();
        RoleModel realmManageUsers = realmAdminClient.getRole("manage-users");
        RoleModel masterManageUsers = realmMasterAdminClient.getRole("manage-users");
        RoleModel masterMasterManageUSers = master.getMasterAdminClient().getRole("manage-users");
        UserModel realmUser = session.users().addUser(realm, "userAdmin");
        realmUser.setFirstName("User");
        realmUser.setLastName("Admin");
        realmUser.setEmail("user@admin");
        realmUser.grantRole(realmManageUsers);
        realmUser.setEnabled(true);
        realmUser.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel masterUser = session.users().addUser(master, "userAdmin");
        masterUser.grantRole(masterManageUsers);
        masterUser.setFirstName("User");
        masterUser.setLastName("Admin");
        masterUser.setEmail("user@admin");
        masterUser.setEnabled(true);
        masterUser.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel masterAdmin = session.users().addUser(master, "masterAdmin");
        masterAdmin.grantRole(masterMasterManageUSers);
        masterAdmin.setFirstName("Master");
        masterAdmin.setLastName("Admin");
        masterAdmin.setEmail("master@admin");
        masterAdmin.setEnabled(true);
        masterAdmin.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel user = session.users().addUser(master, "user");
        user.grantRole(masterManageUsers);
        user.setFirstName("User");
        user.setLastName("Foo");
        user.setEmail("user@foo");
        user.setEnabled(true);
        user.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel userDef = session.users().addUser(realm, "user");
        userDef.setFirstName("User");
        userDef.setLastName("Foo");
        userDef.setEmail("user@foo");
        userDef.grantRole(realmManageUsers);
        userDef.setEnabled(true);
        userDef.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
    }

    @Test
    public void testRestEvaluation() throws Exception {
        this.runOnServer.run(IllegalAdminUpgradeTest::setupUsers);
        UserRepresentation realmUser = (UserRepresentation)this.managedRealm.admin().users().search("user").get(0);
        UserRepresentation masterUser = (UserRepresentation)this.masterRealm.admin().users().search("user").get(0);
        ClientRepresentation realmAdminClient = (ClientRepresentation)this.managedRealm.admin().clients().findByClientId("realm-management").get(0);
        RoleRepresentation realmManageAuthorization = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("manage-authorization").toRepresentation();
        RoleRepresentation realmViewAuthorization = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("view-authorization").toRepresentation();
        RoleRepresentation realmManageClients = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("manage-clients").toRepresentation();
        RoleRepresentation realmViewClients = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("view-clients").toRepresentation();
        RoleRepresentation realmManageEvents = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("manage-events").toRepresentation();
        RoleRepresentation realmViewEvents = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("view-events").toRepresentation();
        RoleRepresentation realmManageIdentityProviders = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("manage-identity-providers").toRepresentation();
        RoleRepresentation realmViewIdentityProviders = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("view-identity-providers").toRepresentation();
        RoleRepresentation realmManageRealm = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("manage-realm").toRepresentation();
        RoleRepresentation realmViewRealm = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("view-realm").toRepresentation();
        RoleRepresentation realmImpersonate = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("impersonation").toRepresentation();
        RoleRepresentation realmManageUsers = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("manage-users").toRepresentation();
        RoleRepresentation realmViewUsers = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("view-users").toRepresentation();
        RoleRepresentation realmQueryUsers = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("query-users").toRepresentation();
        RoleRepresentation realmQueryClients = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("query-clients").toRepresentation();
        RoleRepresentation realmQueryGroups = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("query-groups").toRepresentation();
        RoleRepresentation realmAdmin = this.managedRealm.admin().clients().get(realmAdminClient.getId()).roles().get("realm-admin").toRepresentation();
        ClientRepresentation masterClient = (ClientRepresentation)this.masterRealm.admin().clients().findByClientId("default-realm").get(0);
        RoleRepresentation masterManageAuthorization = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("manage-authorization").toRepresentation();
        RoleRepresentation masterViewAuthorization = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("view-authorization").toRepresentation();
        RoleRepresentation masterManageClients = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("manage-clients").toRepresentation();
        RoleRepresentation masterViewClients = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("view-clients").toRepresentation();
        RoleRepresentation masterManageEvents = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("manage-events").toRepresentation();
        RoleRepresentation masterViewEvents = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("view-events").toRepresentation();
        RoleRepresentation masterManageIdentityProviders = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("manage-identity-providers").toRepresentation();
        RoleRepresentation masterViewIdentityProviders = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("view-identity-providers").toRepresentation();
        RoleRepresentation masterManageRealm = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("manage-realm").toRepresentation();
        RoleRepresentation masterViewRealm = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("view-realm").toRepresentation();
        RoleRepresentation masterImpersonate = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("impersonation").toRepresentation();
        RoleRepresentation masterManageUsers = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("manage-users").toRepresentation();
        RoleRepresentation masterViewUsers = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("view-users").toRepresentation();
        RoleRepresentation masterQueryUsers = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("query-users").toRepresentation();
        RoleRepresentation masterQueryClients = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("query-clients").toRepresentation();
        RoleRepresentation masterQueryGroups = this.masterRealm.admin().clients().get(masterClient.getId()).roles().get("query-groups").toRepresentation();
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        ClientRepresentation client = realmAdminClient;
        try (Keycloak realmClient = this.adminClientFactory.create().realm(REALM_NAME).username("userAdmin").password("password").clientId("admin-cli").build();){
            roles.clear();
            roles.add(realmManageAuthorization);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewAuthorization);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmAdmin);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageClients);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewClients);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageEvents);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewEvents);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageIdentityProviders);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewIdentityProviders);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageRealm);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewRealm);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmImpersonate);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryGroups);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryClients);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        client = realmAdminClient;
        realmClient = this.adminClientFactory.create().realm(MASTER_REALM_NAME).username("userAdmin").password("password").clientId("admin-cli").build();
        try {
            roles.clear();
            roles.add(realmManageAuthorization);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewAuthorization);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmAdmin);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageClients);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewClients);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageEvents);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewEvents);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageIdentityProviders);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewIdentityProviders);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageRealm);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewRealm);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmImpersonate);
            try {
                realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryGroups);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryClients);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        client = masterClient;
        realmClient = this.adminClientFactory.create().realm(MASTER_REALM_NAME).username("masterAdmin").password("password").clientId("admin-cli").build();
        try {
            roles.clear();
            roles.add(masterManageAuthorization);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewAuthorization);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageClients);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewClients);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageEvents);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewEvents);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageIdentityProviders);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewIdentityProviders);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageRealm);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewRealm);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterImpersonate);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageUsers);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewUsers);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterQueryUsers);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterQueryGroups);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterQueryClients);
            try {
                realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                MatcherAssert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        client = realmAdminClient;
        realmClient = this.adminClientFactory.create().realm(MASTER_REALM_NAME).username("admin").password("admin").clientId("admin-cli").build();
        try {
            roles.clear();
            roles.add(realmManageAuthorization);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewAuthorization);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageClients);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewClients);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageEvents);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewEvents);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageIdentityProviders);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewIdentityProviders);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageRealm);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewRealm);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmImpersonate);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryUsers);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryGroups);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryClients);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(REALM_NAME).users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        client = masterClient;
        realmClient = this.adminClientFactory.create().realm(MASTER_REALM_NAME).username("admin").password("admin").clientId("admin-cli").build();
        try {
            roles.clear();
            roles.add(masterManageAuthorization);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewAuthorization);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageClients);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewClients);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageEvents);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewEvents);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageIdentityProviders);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewIdentityProviders);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageRealm);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewRealm);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterImpersonate);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageUsers);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewUsers);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterQueryUsers);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterQueryGroups);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterQueryClients);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm(MASTER_REALM_NAME).users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
    }

    public static class IllegalAdminKeycloakServerConf
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder builder) {
            builder.features(new Profile.Feature[]{Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ});
            return builder;
        }
    }
}

