/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.common.Profile;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;

@KeycloakIntegrationTest(config=ServerConfig.class)
public class ImpersonationDisabledTest {
    @InjectRealm
    private ManagedRealm realm;
    @InjectUser
    private ManagedUser user;

    @Test
    public void testImpersonationDisabled() {
        try {
            this.user.admin().impersonate();
            Assertions.fail((String)"Feature impersonation should be disabled.");
        }
        catch (ServerErrorException e) {
            Assertions.assertEquals((int)Response.Status.NOT_IMPLEMENTED.getStatusCode(), (int)e.getResponse().getStatus());
        }
    }

    public static class ServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.featuresDisabled(new Profile.Feature[]{Profile.Feature.IMPERSONATION});
        }
    }
}

