/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.Config;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.cookie.CookieType;
import org.keycloak.events.EventType;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.admin.AdminClientFactory;
import org.keycloak.testframework.annotations.InjectAdminClientFactory;
import org.keycloak.testframework.annotations.InjectEvents;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.EventMatchers;
import org.keycloak.testframework.events.Events;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.TestApp;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectTestApp;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest(config=ImpersonationTestServerConfig.class)
public class ImpersonationTest {
    @InjectRealm(ref="test", config=ImpersonationTestRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectUser(ref="test-user", realmRef="test", config=TestUserConfig.class)
    ManagedUser managedUser;
    @InjectRealm(ref="master", attachTo="master")
    ManagedRealm masterRealm;
    @InjectAdminClientFactory
    AdminClientFactory clientFactory;
    @InjectRunOnServer(realmRef="test")
    RunOnServerClient runOnServer;
    @InjectOAuthClient(realmRef="test")
    OAuthClient oauth;
    @InjectTestApp
    TestApp testApp;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;
    @InjectWebDriver
    WebDriver driver;
    @InjectPage
    LoginPage loginPage;
    @InjectEvents(ref="test-events", realmRef="test")
    Events events;

    @Test
    public void testImpersonateByMasterAdmin() {
        this.testSuccessfulImpersonation("admin", Config.getAdminRealm());
    }

    @Test
    public void testImpersonateByMasterImpersonator() {
        String userId;
        try (Response response = this.masterRealm.admin().users().create(UserConfigBuilder.create().username("master-impersonator").build());){
            userId = ApiUtil.getCreatedId((Response)response);
        }
        UserResource user = this.masterRealm.admin().users().get(userId);
        user.resetPassword(CredentialBuilder.create().password("password").build());
        ClientResource testRealmClient = ApiUtil.findClientByClientId((RealmResource)this.masterRealm.admin(), (String)(this.managedRealm.getName() + "-realm"));
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(ApiUtil.findClientRoleByName((ClientResource)testRealmClient, (String)"view-users").toRepresentation());
        roles.add(ApiUtil.findClientRoleByName((ClientResource)testRealmClient, (String)"impersonation").toRepresentation());
        user.roles().clientLevel(testRealmClient.toRepresentation().getId()).add(roles);
        this.testSuccessfulImpersonation("master-impersonator", Config.getAdminRealm());
        this.masterRealm.admin().users().get(userId).remove();
    }

    @Test
    public void testImpersongetServiceAccountUserateByTestImpersonator() {
        this.testSuccessfulImpersonation("impersonator", this.managedRealm.getName());
    }

    @Test
    public void testImpersonateByTestAdmin() {
        this.testSuccessfulImpersonation("realm-admin", this.managedRealm.getName());
    }

    @Test
    public void testImpersonateByTestBadImpersonator() {
        this.testForbiddenImpersonation("bad-impersonator", this.managedRealm.getName());
    }

    @Test
    public void testImpersonationFailsForDisabledUser() {
        UserResource impersonatedUserResource = this.managedRealm.admin().users().get(this.managedUser.getId());
        UserRepresentation impersonatedUserRepresentation = impersonatedUserResource.toRepresentation();
        impersonatedUserRepresentation.setEnabled(Boolean.valueOf(false));
        impersonatedUserResource.update(impersonatedUserRepresentation);
        try {
            this.testBadRequestImpersonation("impersonator", this.managedRealm.getName(), this.managedUser.getId(), this.managedRealm.getName(), "User is disabled");
        }
        finally {
            impersonatedUserRepresentation.setEnabled(Boolean.valueOf(true));
            impersonatedUserResource.update(impersonatedUserRepresentation);
        }
    }

    @Test
    public void testImpersonateByMastertBadImpersonator() {
        String userId;
        try (Response response = this.masterRealm.admin().users().create(UserConfigBuilder.create().username("master-bad-impersonator").build());){
            userId = ApiUtil.getCreatedId((Response)response);
        }
        this.masterRealm.admin().users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.testForbiddenImpersonation("master-bad-impersonator", Config.getAdminRealm());
        this.masterRealm.admin().users().get(userId).remove();
    }

    @Test
    public void testImpersonationWorksWhenAuthenticationSessionExists() throws Exception {
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        for (Cookie cookie : this.testSuccessfulImpersonation("realm-admin", this.managedRealm.getName())) {
            this.driver.manage().addCookie(cookie);
        }
        this.oauth.openLoginForm();
        Assertions.assertTrue((boolean)Objects.requireNonNull(this.driver.getCurrentUrl()).contains(this.testApp.getRedirectionUri()));
    }

    @Test
    public void testImpersonationBySameRealmServiceAccount() throws Exception {
        ClientRepresentation clientApp = ClientConfigBuilder.create().clientId("service-account-cl").secret("password").serviceAccountsEnabled(true).build();
        clientApp.setServiceAccountsEnabled(Boolean.valueOf(true));
        this.managedRealm.admin().clients().create(clientApp);
        UserRepresentation user = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"service-account-cl").getServiceAccountUser();
        user.setServiceAccountClientId("service-account-cl");
        ApiUtil.assignClientRoles((RealmResource)this.managedRealm.admin(), (String)user.getId(), (String)"realm-management", (String[])new String[]{"impersonation"});
        this.testSuccessfulServiceAccountImpersonation(user, this.managedRealm.getName());
        this.testBadRequestImpersonation("impersonator", this.managedRealm.getName(), user.getId(), this.managedRealm.getName(), "Service accounts cannot be impersonated");
        ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"service-account-cl").remove();
    }

    @Test
    public void testImpersonationByMasterRealmServiceAccount() throws Exception {
        ClientRepresentation clientApp = ClientConfigBuilder.create().clientId("service-account-cl").secret("password").serviceAccountsEnabled(true).build();
        this.masterRealm.admin().clients().create(clientApp);
        UserRepresentation user = ApiUtil.findClientByClientId((RealmResource)this.masterRealm.admin(), (String)"service-account-cl").getServiceAccountUser();
        user.setServiceAccountClientId("service-account-cl");
        ApiUtil.assignRealmRoles((RealmResource)this.masterRealm.admin(), (String)user.getId(), (String[])new String[]{"admin"});
        this.testSuccessfulServiceAccountImpersonation(user, this.masterRealm.getName());
        ApiUtil.findClientByClientId((RealmResource)this.masterRealm.admin(), (String)"service-account-cl").remove();
    }

    private Set<Cookie> testSuccessfulImpersonation(String admin, String adminRealm) {
        try (Keycloak client = this.login(admin, adminRealm);){
            Set<Cookie> set = this.impersonate(client, admin, adminRealm);
            return set;
        }
    }

    private Set<Cookie> impersonate(Keycloak adminClient, String admin, String adminRealm) {
        Set<Cookie> set;
        block8: {
            BasicCookieStore cookieStore = new BasicCookieStore();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();
            try {
                HttpUriRequest req = RequestBuilder.post().setUri(this.keycloakUrls.getBase() + "/admin/realms/test/users/" + this.managedUser.getId() + "/impersonation").addHeader("Authorization", "Bearer " + adminClient.tokenManager().getAccessTokenString()).build();
                CloseableHttpResponse res = httpClient.execute(req);
                String resBody = EntityUtils.toString((HttpEntity)res.getEntity());
                Assertions.assertNotNull((Object)resBody);
                Assertions.assertTrue((boolean)resBody.contains("redirect"));
                EventRepresentation event = (EventRepresentation)this.events.poll();
                Assertions.assertEquals((Object)event.getType(), (Object)EventType.IMPERSONATE.toString());
                MatcherAssert.assertThat((Object)event.getSessionId(), (Matcher)EventMatchers.isUUID());
                Assertions.assertEquals((Object)event.getUserId(), (Object)this.managedUser.getId());
                Assertions.assertTrue((boolean)event.getDetails().values().stream().anyMatch(f -> f.equals(admin)));
                Assertions.assertTrue((boolean)event.getDetails().values().stream().anyMatch(f -> f.equals(adminRealm)));
                String testRealm = this.managedRealm.getName();
                String userId = this.managedUser.getId();
                UserSessionNotesHolder notesHolder = (UserSessionNotesHolder)this.runOnServer.fetch((FetchOnServer & Serializable)session -> {
                    RealmModel realm = session.realms().getRealmByName(testRealm);
                    UserModel user = session.users().getUserById(realm, userId);
                    UserSessionModel userSession = session.sessions().getUserSessionsStream(realm, user).filter(u -> u.getNotes().containsValue(admin)).findFirst().get();
                    return new UserSessionNotesHolder(userSession.getNotes());
                }, UserSessionNotesHolder.class);
                Map<String, String> notes = notesHolder.getNotes();
                Assertions.assertNotNull((Object)notes.get(ImpersonationSessionNote.IMPERSONATOR_ID.toString()));
                Assertions.assertEquals((Object)admin, (Object)notes.get(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString()));
                Set<Cookie> cookies = cookieStore.getCookies().stream().filter(c -> c.getName().startsWith(CookieType.IDENTITY.getName())).map(c -> new Cookie(c.getName(), c.getValue(), c.getDomain(), c.getPath(), c.getExpiryDate(), c.isSecure(), true)).collect(Collectors.toSet());
                Assertions.assertNotNull(cookies);
                MatcherAssert.assertThat(cookies, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
                httpClient.close();
                set = cookies;
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            httpClient.close();
        }
        return set;
    }

    private void testForbiddenImpersonation(String admin, String adminRealm) {
        try (Keycloak client = this.createAdminClient(adminRealm, this.establishClientId(adminRealm), admin);){
            client.realms().realm(this.managedRealm.getName()).users().get(this.managedUser.getId()).impersonate();
            Assertions.fail((String)"Expected ClientErrorException wasn't thrown.");
        }
        catch (ClientErrorException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"403 Forbidden"));
        }
    }

    private void testBadRequestImpersonation(String admin, String adminRealm, String impersonatedId, String impersonatedRealm, String errorExpected) {
        try (Keycloak client = this.createAdminClient(adminRealm, this.establishClientId(adminRealm), admin);){
            client.realms().realm(impersonatedRealm).users().get(impersonatedId).impersonate();
            Assertions.fail((String)"Expected ClientErrorException wasn't thrown.");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)e.getResponse().getStatusInfo());
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)errorExpected, (Object)error.getErrorMessage());
        }
    }

    private String establishClientId(String realm) {
        return realm.equals("master") ? "admin-cli" : "myclient";
    }

    private Keycloak createAdminClient(String realm, String clientId, String username) {
        String password = username.equals("admin") ? "admin" : "password";
        return this.clientFactory.create().realm(realm).username(username).password(password).clientId(clientId).grantType("password").build();
    }

    private Keycloak login(String username, String realm) {
        String clientId = this.establishClientId(realm);
        Keycloak client = this.createAdminClient(realm, clientId, username);
        client.tokenManager().grantToken();
        if (!realm.equals("master")) {
            EventRepresentation e = (EventRepresentation)this.events.poll();
            Assertions.assertEquals((Object)EventType.LOGIN.toString(), (Object)e.getType(), (String)"Event type");
            Assertions.assertEquals((Object)clientId, (Object)e.getClientId(), (String)"Client ID");
        }
        return client;
    }

    private Set<Cookie> testSuccessfulServiceAccountImpersonation(UserRepresentation serviceAccount, String serviceAccountRealm) {
        try (Keycloak client = this.loginServiceAccount(serviceAccount, serviceAccountRealm);){
            Set<Cookie> set = this.impersonateServiceAccount(client);
            return set;
        }
    }

    private Keycloak loginServiceAccount(UserRepresentation serviceAccount, String serviceAccountRealm) {
        Keycloak client = this.createServiceAccountClient(serviceAccountRealm, serviceAccount);
        client.tokenManager().getAccessToken();
        return client;
    }

    private Keycloak createServiceAccountClient(String serviceAccountRealm, UserRepresentation serviceAccount) {
        return this.clientFactory.create().realm(serviceAccountRealm).clientId(serviceAccount.getServiceAccountClientId()).clientSecret("password").grantType("client_credentials").build();
    }

    private Set<Cookie> impersonateServiceAccount(Keycloak adminClient) {
        Set<Cookie> set;
        block8: {
            BasicCookieStore cookieStore = new BasicCookieStore();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();
            try {
                HttpUriRequest req = RequestBuilder.post().setUri(this.keycloakUrls.getBase() + "/admin/realms/test/users/" + this.managedUser.getId() + "/impersonation").addHeader("Authorization", "Bearer " + adminClient.tokenManager().getAccessTokenString()).build();
                CloseableHttpResponse res = httpClient.execute(req);
                String resBody = EntityUtils.toString((HttpEntity)res.getEntity());
                Assertions.assertNotNull((Object)resBody);
                Assertions.assertTrue((boolean)resBody.contains("redirect"));
                Set<Cookie> cookies = cookieStore.getCookies().stream().filter(c -> c.getName().startsWith(CookieType.IDENTITY.getName())).map(c -> new Cookie(c.getName(), c.getValue(), c.getDomain(), c.getPath(), c.getExpiryDate(), c.isSecure(), true)).collect(Collectors.toSet());
                Assertions.assertNotNull(cookies);
                MatcherAssert.assertThat(cookies, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
                httpClient.close();
                set = cookies;
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            httpClient.close();
        }
        return set;
    }

    private static class UserSessionNotesHolder {
        private Map<String, String> notes = new HashMap<String, String>();

        public UserSessionNotesHolder() {
        }

        public UserSessionNotesHolder(Map<String, String> notes) {
            this.notes = notes;
        }

        public void setNotes(Map<String, String> notes) {
            this.notes = notes;
        }

        public Map<String, String> getNotes() {
            return this.notes;
        }
    }

    private static class TestUserConfig
    implements UserConfig {
        private TestUserConfig() {
        }

        public UserConfigBuilder configure(UserConfigBuilder user) {
            user.username("test-user");
            user.password("password");
            user.name("My", "Test");
            user.email("test@email.org");
            user.emailVerified(true);
            return user;
        }
    }

    private static class ImpersonationTestRealmConfig
    implements RealmConfig {
        private ImpersonationTestRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder config) {
            config.addClient("myclient").clientId("myclient").publicClient(true).directAccessGrantsEnabled(true);
            config.addUser("realm-admin").password("password").name("My", "Test Admin").email("my-test-admin@email.org").emailVerified(true).clientRoles("realm-management", new String[]{"realm-admin"});
            config.addUser("impersonator").password("password").name("My", "Test Impersonator").email("my-test-impersonator@email.org").emailVerified(true).clientRoles("realm-management", new String[]{"impersonation"}).clientRoles("realm-management", new String[]{"view-users"});
            config.addUser("bad-impersonator").password("password").name("My", "Test Bad Impersonator").email("my-test-bad-impersonator@email.org").emailVerified(true).clientRoles("realm-management", new String[]{"manage-users"});
            return config;
        }
    }

    public static class ImpersonationTestServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder server) {
            server.features(new Profile.Feature[]{Profile.Feature.IMPERSONATION});
            return server;
        }
    }
}

