/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.BadRequestException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.remote.timeoffset.InjectTimeOffSet;
import org.keycloak.testframework.remote.timeoffset.TimeOffSet;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class InitialAccessTokenResourceTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;
    @InjectTimeOffSet
    TimeOffSet timeOffSet;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    private ClientInitialAccessResource resource;

    @BeforeEach
    public void before() {
        this.resource = this.managedRealm.admin().clientInitialAccess();
    }

    @Test
    public void testInitialAccessTokens() {
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(2));
        rep.setExpiration(Integer.valueOf(100));
        int time = Time.currentTime();
        ClientInitialAccessPresentation response = this.resource.create(rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientInitialAccessPath((String)response.getId()), (Object)rep, (ResourceType)ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        Assertions.assertNotNull((Object)response.getId());
        Assertions.assertEquals((Integer)2, (Integer)response.getCount());
        Assertions.assertEquals((Integer)2, (Integer)response.getRemainingCount());
        Assertions.assertEquals((Integer)100, (Integer)response.getExpiration());
        MatcherAssert.assertThat((Object)response.getTimestamp(), (Matcher)CoreMatchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(time)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(Time.currentTime()))));
        Assertions.assertNotNull((Object)response.getToken());
        rep.setCount(Integer.valueOf(3));
        response = this.resource.create(rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientInitialAccessPath((String)response.getId()), (Object)rep, (ResourceType)ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        rep.setCount(Integer.valueOf(4));
        response = this.resource.create(rep);
        String lastId = response.getId();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientInitialAccessPath((String)lastId), (Object)rep, (ResourceType)ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        List list = this.resource.list();
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((int)9, (int)(((ClientInitialAccessPresentation)list.get(0)).getCount() + ((ClientInitialAccessPresentation)list.get(1)).getCount() + ((ClientInitialAccessPresentation)list.get(2)).getCount()));
        Assertions.assertNull((Object)((ClientInitialAccessPresentation)list.get(0)).getToken());
        this.resource.delete(lastId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientInitialAccessPath((String)lastId), (ResourceType)ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        list = this.resource.list();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((int)5, (int)(((ClientInitialAccessPresentation)list.get(0)).getCount() + ((ClientInitialAccessPresentation)list.get(1)).getCount()));
    }

    @Test
    public void testInvalidParametersWhileCreatingInitialAccessTokens() {
        OAuth2ErrorRepresentation error;
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(-1));
        rep.setExpiration(Integer.valueOf(100));
        try {
            this.resource.create(rep);
            Assertions.fail((String)"Invalid value for count");
        }
        catch (BadRequestException e) {
            error = (OAuth2ErrorRepresentation)e.getResponse().readEntity(OAuth2ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Invalid value for count", (Object)error.getError());
            Assertions.assertEquals((Object)"The count cannot be less than 0", (Object)error.getErrorDescription());
        }
        rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(100));
        rep.setExpiration(Integer.valueOf(-10));
        try {
            this.resource.create(rep);
            Assertions.fail((String)"Invalid value for expiration");
        }
        catch (BadRequestException e) {
            error = (OAuth2ErrorRepresentation)e.getResponse().readEntity(OAuth2ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Invalid value for expiration", (Object)error.getError());
            Assertions.assertEquals((Object)"The expiration time interval cannot be less than 0", (Object)error.getErrorDescription());
        }
    }

    private void removeExpired(String realmUuid) {
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm(realmUuid);
            session.sessions().removeExpired(realm);
            session.authenticationSessions().removeExpired(realm);
            session.realms().removeExpiredClientInitialAccess();
        });
    }

    @Test
    public void testPeriodicExpiration() {
        ClientInitialAccessPresentation response1 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(1), Integer.valueOf(1)));
        ClientInitialAccessPresentation response2 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(1000), Integer.valueOf(1)));
        ClientInitialAccessPresentation response3 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(1000), Integer.valueOf(0)));
        ClientInitialAccessPresentation response4 = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(1)));
        List list = this.resource.list();
        Assertions.assertEquals((int)4, (int)list.size());
        this.timeOffSet.set(10);
        String realmUuid = this.managedRealm.getId();
        this.removeExpired(realmUuid);
        list = this.resource.list();
        Assertions.assertEquals((int)2, (int)list.size());
        List remainingIds = list.stream().map(ClientInitialAccessPresentation::getId).collect(Collectors.toList());
        Assert.assertNames(remainingIds, (String[])new String[]{response2.getId(), response4.getId()});
        this.timeOffSet.set(2000);
        this.removeExpired(realmUuid);
        list = this.resource.list();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)((ClientInitialAccessPresentation)list.get(0)).getId(), (Object)response4.getId());
        this.managedRealm.admin().clientInitialAccess().delete(response4.getId());
    }
}

