/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.ManagementPermissionRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest(config=ServerConfig.class)
public class ManagementPermissionsTest {
    @InjectRealm
    private ManagedRealm realm;

    @Test
    public void updateGroupPermissions() {
        RealmResource realmResource = this.realm.admin();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("perm-group-test");
        Response response = realmResource.groups().add(group);
        String id = ApiUtil.getCreatedId((Response)response);
        GroupResource groupResource = realmResource.groups().group(id);
        ManagementPermissionReference result = groupResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = groupResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = groupResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
    }

    @Test
    public void updateClientPermissions() {
        RealmResource realmResource = this.realm.admin();
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setName("perm-client-test");
        Response response = realmResource.clients().create(clientRepresentation);
        String id = ApiUtil.getCreatedId((Response)response);
        ClientResource clientResource = realmResource.clients().get(id);
        ManagementPermissionReference result = clientResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = clientResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = clientResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
    }

    @Test
    public void updateRealmRolePermissions() {
        RealmResource realmResource = this.realm.admin();
        RoleRepresentation roleRepresentation = new RoleRepresentation();
        roleRepresentation.setName("perm-role-test");
        realmResource.roles().create(roleRepresentation);
        RoleResource roleResource = realmResource.roles().get("perm-role-test");
        ManagementPermissionReference result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
    }

    @Test
    public void updateClientRolePermissions() {
        RealmResource realmResource = this.realm.admin();
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setName("perm-client-test");
        Response response = realmResource.clients().create(clientRepresentation);
        String id = ApiUtil.getCreatedId((Response)response);
        ClientResource clientResource = realmResource.clients().get(id);
        RoleRepresentation roleRepresentation = new RoleRepresentation();
        roleRepresentation.setName("perm-client-role-test");
        clientResource.roles().create(roleRepresentation);
        RoleResource roleResource = clientResource.roles().get("perm-client-role-test");
        ManagementPermissionReference result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(true));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.setPermissions(new ManagementPermissionRepresentation(false));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
        result = roleResource.getPermissions();
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isEnabled());
    }

    public static class ServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.features(new Profile.Feature[]{Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ});
        }
    }
}

