/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jgroups.util.UUID;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.KeyStoreConfig;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.info.ServerInfoRepresentation;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.AbstractPermissionsTest;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.FederatedIdentityBuilder;
import org.keycloak.testsuite.util.IdentityProviderBuilder;

@KeycloakIntegrationTest
public class PermissionsTest
extends AbstractPermissionsTest {
    @InjectRealm(config=AbstractPermissionsTest.PermissionsTestRealmConfig1.class, ref="realm1")
    ManagedRealm managedRealm1;
    @InjectRealm(config=AbstractPermissionsTest.PermissionsTestRealmConfig2.class, ref="realm2")
    ManagedRealm managedRealm2;

    @Test
    public void realmLogoutAll() {
        AbstractPermissionsTest.Invocation invocation = RealmResource::logoutAll;
        this.invoke(invocation, (Keycloak)this.clients.get("master-none"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("master-view-realm"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("REALM2"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("none"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("view-users"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("manage-realm"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("master-manage-realm"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("manage-users"), true);
        this.invoke(invocation, (Keycloak)this.clients.get("master-manage-users"), true);
    }

    @Test
    public void events() {
        this.invoke(RealmResource::getRealmEventsConfig, AdminAuth.Resource.EVENTS, false);
        this.invoke((RealmResource realm) -> realm.updateRealmEventsConfig(new RealmEventsConfigRepresentation()), AdminAuth.Resource.EVENTS, true);
        this.invoke(RealmResource::getEvents, AdminAuth.Resource.EVENTS, false);
        this.invoke(RealmResource::getAdminEvents, AdminAuth.Resource.EVENTS, false);
        this.invoke(RealmResource::clearEvents, AdminAuth.Resource.EVENTS, true);
        this.invoke(RealmResource::clearAdminEvents, AdminAuth.Resource.EVENTS, true);
    }

    @Test
    public void attackDetection() {
        UserRepresentation newUser = UserConfigBuilder.create().username("attacked").enabled(true).build();
        String userUuid = ApiUtil.getCreatedId((Response)this.managedRealm1.admin().users().create(newUser));
        this.managedRealm1.cleanup().add(r -> r.users().delete(userUuid).close());
        UserRepresentation user = this.managedRealm1.admin().users().get(userUuid).toRepresentation();
        this.invoke((RealmResource realm) -> realm.attackDetection().bruteForceUserStatus(userUuid), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.attackDetection().clearBruteForceForUser(userUuid), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.attackDetection().clearAllBruteForce(), AdminAuth.Resource.USER, true);
    }

    @Test
    public void clients() {
        this.invoke((RealmResource realm) -> realm.clients().findAll(), AdminAuth.Resource.CLIENT, false, true);
        List l = ((Keycloak)this.clients.get("query-clients")).realm("permissions-test").clients().findAll();
        MatcherAssert.assertThat((Object)l, (Matcher)Matchers.empty());
        l = ((Keycloak)this.clients.get("view-clients")).realm("permissions-test").clients().findAll();
        MatcherAssert.assertThat((Object)l, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        ClientRepresentation client = (ClientRepresentation)l.get(0);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(((Keycloak)this.clients.get("query-users")).realm("permissions-test").clients().create(client)), (Keycloak)this.clients.get("query-users"), false);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("query-users")).realm("permissions-test").clients().get(client.getId()).toRepresentation(), (Keycloak)this.clients.get("query-users"), false);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("query-users")).realm("permissions-test").clients().get(client.getId()).update(client), (Keycloak)this.clients.get("query-users"), false);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("query-users")).realm("permissions-test").clients().get(client.getId()).remove(), (Keycloak)this.clients.get("query-users"), false);
        this.invoke((RealmResource realm) -> realm.convertClientDescription("blahblah"), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.clients().create(ClientConfigBuilder.create().clientId("foo").build())), AdminAuth.Resource.CLIENT, true);
        ClientRepresentation foo = (ClientRepresentation)this.managedRealm1.admin().clients().findByClientId("foo").get(0);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).toRepresentation(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getInstallationProvider("nosuch"), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).update(foo), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> {
            realm.clients().get(foo.getId()).remove();
            realm.clients().create(foo);
            ClientRepresentation temp = (ClientRepresentation)realm.clients().findByClientId("foo").get(0);
            foo.setId(temp.getId());
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).generateNewSecret(), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).regenerateRegistrationAccessToken(), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getSecret(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getServiceAccountUser(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).pushRevocation(), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getApplicationSessionCount(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getUserSessions(Integer.valueOf(0), Integer.valueOf(100)), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getOfflineSessionCount(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getOfflineUserSessions(Integer.valueOf(0), Integer.valueOf(100)), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).registerNode(Map.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).unregisterNode("nosuch"), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).testNodesAvailable(), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getCertficateResource("nosuch").generate(), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getCertficateResource("nosuch").generateAndGetKeystore(new KeyStoreConfig()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getCertficateResource("nosuch").getKeyInfo(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getCertficateResource("nosuch").getKeystore(new KeyStoreConfig()), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getCertficateResource("nosuch").uploadJks(null), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getCertficateResource("nosuch").uploadJksCertificate(null), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getProtocolMappers().createMapper(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.clients().get(foo.getId()).getProtocolMappers().createMapper(new ProtocolMapperRepresentation())), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getProtocolMappers().getMapperById("nosuch"), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getProtocolMappers().getMappers(), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getProtocolMappers().getMappersPerProtocol("nosuch"), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getProtocolMappers().update("nosuch", new ProtocolMapperRepresentation()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getProtocolMappers().delete("nosuch"), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getScopeMappings().getAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getScopeMappings().realmLevel().listAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getScopeMappings().realmLevel().listEffective(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getScopeMappings().realmLevel().listAvailable(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getScopeMappings().realmLevel().add(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).getScopeMappings().realmLevel().remove(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(UUID.randomUUID().toString()).roles().list(), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().create(new RoleRepresentation()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().get("nosuch").toRepresentation(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().deleteRole("nosuch"), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().get("nosuch").update(new RoleRepresentation()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().get("nosuch").addComposites(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().get("nosuch").deleteComposites(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().get("nosuch").getRoleComposites(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().get("nosuch").getRealmRoleComposites(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).roles().get("nosuch").getClientRoleComposites("nosuch"), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.flows().getFlows(), (Keycloak)this.clients.get("query-clients"), true);
        this.invoke((RealmResource realm) -> realm.flows().getClientAuthenticatorProviders(), (Keycloak)this.clients.get("query-clients"), true);
        this.invoke((RealmResource realm) -> realm.flows().getClientAuthenticatorProviders(), (Keycloak)this.clients.get("view-clients"), true);
        this.invoke((RealmResource realm) -> realm.flows().getClientAuthenticatorProviders(), (Keycloak)this.clients.get("manage-clients"), true);
        this.invoke((RealmResource realm) -> realm.flows().getClientAuthenticatorProviders(), (Keycloak)this.clients.get("query-users"), false);
        this.invoke((RealmResource realm) -> realm.flows().getPerClientConfigDescription(), (Keycloak)this.clients.get("query-clients"), true);
    }

    @Test
    public void clientScopes() {
        this.invoke((RealmResource realm) -> realm.clientScopes().findAll(), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            ClientScopeRepresentation scope = new ClientScopeRepresentation();
            scope.setName("scope");
            response.set(realm.clientScopes().create(scope));
        }, AdminAuth.Resource.CLIENT, true);
        ClientScopeRepresentation scope = (ClientScopeRepresentation)this.managedRealm1.admin().clientScopes().findAll().get(0);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).toRepresentation(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).update(scope), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> {
            realm.clientScopes().get(scope.getId()).remove();
            realm.clientScopes().create(scope);
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().getMappers(), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().getMappersPerProtocol("nosuch"), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().getMapperById("nosuch"), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().update("nosuch", new ProtocolMapperRepresentation()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.clientScopes().get(scope.getId()).getProtocolMappers().createMapper(new ProtocolMapperRepresentation())), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().createMapper(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().delete("nosuch"), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().getAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().listAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().listAvailable(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().listEffective(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().add(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().remove(List.of()), AdminAuth.Resource.CLIENT, true);
        ClientRepresentation realmAccessClient = (ClientRepresentation)this.adminClient.realms().realm("permissions-test").clients().findByClientId("realm-management").get(0);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).listAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).listAvailable(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).listEffective(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).add(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).remove(List.of()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("query-users")).realm("permissions-test").clientScopes().findAll(), (Keycloak)this.clients.get("query-users"), false);
    }

    @Test
    public void clientInitialAccess() {
        this.invoke((RealmResource realm) -> realm.clientInitialAccess().list(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientInitialAccess().create(new ClientInitialAccessCreatePresentation()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientInitialAccess().delete("nosuch"), AdminAuth.Resource.CLIENT, true);
    }

    @Test
    public void roles() {
        RoleRepresentation newRole = RoleConfigBuilder.create().name("sample-role").build();
        this.managedRealm1.admin().roles().create(newRole);
        this.managedRealm1.cleanup().add(r -> r.roles().deleteRole("sample-role"));
        this.invoke((RealmResource realm) -> realm.roles().list(), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("create-client")).realm("permissions-test").roles().list(), (Keycloak)this.clients.get("create-client"), false);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").toRepresentation(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").update(newRole), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.roles().create(new RoleRepresentation()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> {
            realm.roles().deleteRole("sample-role");
            realm.roles().create(newRole);
        }, AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").getRoleComposites(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").addComposites(List.of()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").deleteComposites(List.of()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").getRoleComposites(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").getRealmRoleComposites(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.roles().get("sample-role").getClientRoleComposites(KeycloakModelUtils.generateId()), AdminAuth.Resource.REALM, false);
    }

    @Test
    public void rolesById() {
        RoleRepresentation newRole = RoleConfigBuilder.create().name("role-by-id").build();
        this.managedRealm1.admin().roles().create(newRole);
        RoleRepresentation role = this.managedRealm1.admin().roles().get("role-by-id").toRepresentation();
        this.managedRealm1.cleanup().add(r -> r.roles().deleteRole("role-by-id"));
        this.invoke((RealmResource realm) -> realm.rolesById().getRole(role.getId()), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> realm.rolesById().updateRole(role.getId(), role), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> {
            realm.rolesById().deleteRole(role.getId());
            realm.roles().create(newRole);
            RoleRepresentation temp = realm.roles().get("role-by-id").toRepresentation();
            role.setId(temp.getId());
        }, AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.rolesById().getRoleComposites(role.getId()), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> realm.rolesById().addComposites(role.getId(), List.of()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.rolesById().deleteComposites(role.getId(), List.of()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.rolesById().getRoleComposites(role.getId()), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> realm.rolesById().getRealmRoleComposites(role.getId()), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> realm.rolesById().getClientRoleComposites(role.getId(), KeycloakModelUtils.generateId()), AdminAuth.Resource.REALM, false, true);
    }

    @Test
    public void groups() {
        this.invoke((RealmResource realm) -> realm.groups().groups(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().count(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("mygroup");
            response.set(realm.groups().add(group));
        }, AdminAuth.Resource.USER, true);
        GroupRepresentation group = this.managedRealm1.admin().getGroupByPath("mygroup");
        ClientRepresentation realmAccessClient = (ClientRepresentation)this.managedRealm1.admin().clients().findByClientId("realm-management").get(0);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("create-client")).realm("permissions-test").groups().groups(), (Keycloak)this.clients.get("create-client"), false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).toRepresentation(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).update(group), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).members(Integer.valueOf(0), Integer.valueOf(100)), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            GroupRepresentation subgroup = new GroupRepresentation();
            subgroup.setName("sub");
            response.set(realm.groups().group(group.getId()).subGroup(subgroup));
        }, AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().getAll(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().realmLevel().listAll(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().realmLevel().listEffective(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().realmLevel().listAvailable(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().realmLevel().add(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().realmLevel().remove(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).listAll(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).listEffective(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).listAvailable(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).add(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).remove(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> {
            realm.groups().group(group.getId()).remove();
            group.setId(null);
            realm.groups().add(group);
            GroupRepresentation temp = realm.getGroupByPath("mygroup");
            group.setId(temp.getId());
        }, AdminAuth.Resource.USER, true);
    }

    @Test
    public void users() {
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.users().create(UserConfigBuilder.create().username("testuser").build())), AdminAuth.Resource.USER, true);
        UserRepresentation user = (UserRepresentation)this.managedRealm1.admin().users().search("testuser").get(0);
        this.invoke((RealmResource realm) -> {
            realm.users().get(user.getId()).remove();
            realm.users().create(user);
            UserRepresentation temp = (UserRepresentation)realm.users().search("testuser").get(0);
            user.setId(temp.getId());
        }, AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).toRepresentation(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).getUnmanagedAttributes(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).update(user), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().count(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).getUserSessions(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).getOfflineSessions(KeycloakModelUtils.generateId()), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).getFederatedIdentity(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.users().get(user.getId()).addFederatedIdentity("nosuch", FederatedIdentityBuilder.create().identityProvider("nosuch").userId("nosuch").userName("nosuch").build())), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).removeFederatedIdentity("nosuch"), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).getConsents(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).revokeConsent("testclient"), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).logout(), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).resetPassword(CredentialBuilder.create().password("password").build()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> {
            CredentialRepresentation totpCredential = realm.users().get(user.getId()).credentials().stream().filter(c -> "otp".equals(c.getType())).findFirst().orElse(null);
            if (totpCredential != null) {
                realm.users().get(user.getId()).removeCredential(totpCredential.getId());
            } else {
                realm.users().get(user.getId()).removeCredential("123");
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).executeActionsEmail(List.of(UserModel.RequiredAction.UPDATE_PASSWORD.name())), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).executeActionsEmail(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).sendVerifyEmail(), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).groups(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).leaveGroup("nosuch"), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).joinGroup("nosuch"), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().getAll(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().realmLevel().listAll(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().realmLevel().listAvailable(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().realmLevel().listEffective(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().realmLevel().add(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().realmLevel().remove(List.of()), AdminAuth.Resource.USER, true);
        ClientRepresentation realmAccessClient = (ClientRepresentation)this.managedRealm1.admin().clients().findByClientId("realm-management").get(0);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).listAll(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).listAvailable(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).listEffective(), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).add(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).remove(List.of()), AdminAuth.Resource.USER, true);
        this.invoke((RealmResource realm) -> realm.users().search("foo", Integer.valueOf(0), Integer.valueOf(1)), AdminAuth.Resource.USER, false);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("query-clients")).realm("permissions-test").users().list(), (Keycloak)this.clients.get("query-clients"), false);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(((Keycloak)this.clients.get("query-clients")).realm("permissions-test").users().create(user)), (Keycloak)this.clients.get("query-clients"), false);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("query-clients")).realm("permissions-test").users().search("test"), (Keycloak)this.clients.get("query-clients"), false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).toRepresentation(), (Keycloak)this.clients.get("query-clients"), false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).remove(), (Keycloak)this.clients.get("query-clients"), false);
        this.invoke((RealmResource realm) -> realm.users().get(user.getId()).update(user), (Keycloak)this.clients.get("query-clients"), false);
        this.invoke((RealmResource realm) -> realm.flows().getRequiredActions(), (Keycloak)this.clients.get("query-users"), true);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("view-users")).realm("permissions-test").users().get(user.getId()).getConfiguredUserStorageCredentialTypes(), (Keycloak)this.clients.get("view-users"), true);
    }

    @Test
    public void identityProviders() {
        this.invoke((RealmResource realm) -> realm.identityProviders().findAll(), AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.identityProviders().create(IdentityProviderBuilder.create().providerId("oidc").displayName("nosuch-foo").alias("foo").setAttribute("clientId", "foo").setAttribute("clientSecret", "foo").build())), AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke((RealmResource realm) -> realm.identityProviders().get("nosuch").toRepresentation(), AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke((RealmResource realm) -> realm.identityProviders().get("nosuch").update(new IdentityProviderRepresentation()), AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.identityProviders().get("nosuch").export("saml")), AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke((RealmResource realm) -> realm.identityProviders().get("nosuch").remove(), AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.identityProviders().get("nosuch").addMapper(new IdentityProviderMapperRepresentation())), AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke((RealmResource realm) -> realm.identityProviders().get("nosuch").delete("nosuch"), AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke((RealmResource realm) -> realm.identityProviders().get("nosuch").getMappers(), AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke((RealmResource realm) -> realm.identityProviders().get("nosuch").getMapperById("nosuch"), AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke((RealmResource realm) -> realm.identityProviders().get("nosuch").getMapperTypes(), AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke((RealmResource realm) -> realm.identityProviders().importFrom(Map.of()), AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke((RealmResource realm) -> realm.identityProviders().importFrom(null), AdminAuth.Resource.IDENTITY_PROVIDER, true);
    }

    @Test
    public void components() {
        this.invoke((RealmResource realm) -> realm.components().query(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.components().query("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.clientRegistrationPolicy().getProviders(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.components().add(new ComponentRepresentation())), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.components().component("nosuch").toRepresentation(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.components().component("nosuch").update(new ComponentRepresentation()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.components().component("nosuch").remove(), AdminAuth.Resource.REALM, true);
    }

    @Test
    public void partialExport() {
        this.invoke((RealmResource realm) -> realm.partialExport(Boolean.valueOf(false), Boolean.valueOf(false)), (Keycloak)this.clients.get("view-realm"), false);
        this.invoke((RealmResource realm) -> realm.partialExport(Boolean.valueOf(false), Boolean.valueOf(false)), (Keycloak)this.clients.get("manage-realm"), true);
        this.invoke((RealmResource realm) -> realm.partialExport(Boolean.valueOf(true), Boolean.valueOf(false)), (Keycloak)this.clients.get("manage-realm"), false);
        this.invoke((RealmResource realm) -> realm.partialExport(Boolean.valueOf(false), Boolean.valueOf(true)), (Keycloak)this.clients.get("manage-realm"), false);
        this.invoke((RealmResource realm) -> realm.partialExport(Boolean.valueOf(true), Boolean.valueOf(true)), (Keycloak)this.clients.get("multi"), true);
        this.invoke((RealmResource realm) -> realm.partialExport(Boolean.valueOf(false), Boolean.valueOf(false)), (Keycloak)this.clients.get("none"), false);
    }

    @Test
    public void localizations() {
        this.verifyAnyAdminRoleReqired(realm -> realm.localization().getRealmSpecificLocales());
        this.verifyAnyAdminRoleReqired(realm -> realm.localization().getRealmLocalizationText("en", "test"));
        this.verifyAnyAdminRoleReqired(realm -> realm.localization().getRealmLocalizationTexts("en"));
        this.verifyAnyAdminRoleReqired(realm -> realm.localization().getRealmLocalizationTexts("en", Boolean.valueOf(false)));
        this.invoke((RealmResource realm) -> realm.localization().createOrUpdateRealmLocalizationTexts("en", Map.of()), (Keycloak)this.clients.get("view-realm"), false);
        this.invoke((RealmResource realm) -> realm.localization().createOrUpdateRealmLocalizationTexts("en", Map.of()), (Keycloak)this.clients.get("manage-realm"), true);
        this.invoke((RealmResource realm) -> realm.localization().createOrUpdateRealmLocalizationTexts("en", Map.of()), (Keycloak)this.clients.get("master-admin"), true);
        this.invoke((RealmResource realm) -> realm.localization().createOrUpdateRealmLocalizationTexts("en", Map.of()), (Keycloak)this.clients.get("none"), false);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationText("en", "test"), (Keycloak)this.clients.get("REALM2"), false);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationText("en", "test"), (Keycloak)this.clients.get("view-realm"), false);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationText("en", "test"), (Keycloak)this.clients.get("manage-realm"), true);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationText("en", "test"), (Keycloak)this.clients.get("master-admin"), true);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationText("en", "test"), (Keycloak)this.clients.get("none"), false);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationText("en", "test"), (Keycloak)this.clients.get("REALM2"), false);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationTexts("en"), (Keycloak)this.clients.get("view-realm"), false);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationTexts("en"), (Keycloak)this.clients.get("manage-realm"), true);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationTexts("en"), (Keycloak)this.clients.get("master-admin"), true);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationTexts("en"), (Keycloak)this.clients.get("none"), false);
        this.invoke((RealmResource realm) -> realm.localization().deleteRealmLocalizationTexts("en"), (Keycloak)this.clients.get("REALM2"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerInfo() throws Exception {
        Assert.assertThrows(ForbiddenException.class, () -> ((Keycloak)this.clients.get("master-none")).serverInfo().getInfo());
        ServerInfoRepresentation serverInfo = ((Keycloak)this.clients.get("master-view-realm")).serverInfo().getInfo();
        Assert.assertNotNull((Object)serverInfo.getSystemInfo());
        Assert.assertNotNull((Object)serverInfo.getCpuInfo());
        Assert.assertNotNull((Object)serverInfo.getMemoryInfo());
        Assert.assertThrows(ForbiddenException.class, () -> ((Keycloak)this.clients.get("none")).serverInfo().getInfo());
        serverInfo = ((Keycloak)this.clients.get("view-realm")).serverInfo().getInfo();
        Assert.assertNull((Object)serverInfo.getSystemInfo());
        Assert.assertNull((Object)serverInfo.getCpuInfo());
        Assert.assertNull((Object)serverInfo.getMemoryInfo());
        serverInfo = ((Keycloak)this.clients.get("manage-users")).serverInfo().getInfo();
        Assert.assertNull((Object)serverInfo.getSystemInfo());
        Assert.assertNull((Object)serverInfo.getCpuInfo());
        Assert.assertNull((Object)serverInfo.getMemoryInfo());
        ClientRepresentation realmMgtRep = (ClientRepresentation)this.adminClient.realm("permissions-test").clients().findByClientId("realm-management").get(0);
        ClientResource realmMgtRes = this.adminClient.realm("permissions-test").clients().get(realmMgtRep.getId());
        RoleRepresentation viewSystem = new RoleRepresentation();
        viewSystem.setName("view-system");
        realmMgtRes.roles().create(viewSystem);
        viewSystem = realmMgtRes.roles().get("view-system").toRepresentation();
        UserRepresentation userRep = (UserRepresentation)this.adminClient.realm("permissions-test").users().search("view-realm", Boolean.TRUE).get(0);
        UserResource userRes = this.adminClient.realm("permissions-test").users().get(userRep.getId());
        userRes.roles().clientLevel(realmMgtRep.getId()).add(Collections.singletonList(viewSystem));
        try (Keycloak keycloak = this.adminClientFactory.create().realm("permissions-test").username(userRep.getUsername()).password("password").clientId("test-client").build();){
            serverInfo = keycloak.serverInfo().getInfo();
            Assert.assertNotNull((Object)serverInfo.getSystemInfo());
            Assert.assertNotNull((Object)serverInfo.getCpuInfo());
            Assert.assertNotNull((Object)serverInfo.getMemoryInfo());
        }
        finally {
            userRes.roles().clientLevel(realmMgtRep.getId()).remove(Collections.singletonList(viewSystem));
            realmMgtRes.roles().get("view-system").remove();
        }
    }

    private void verifyAnyAdminRoleReqired(AbstractPermissionsTest.Invocation invocation) {
        this.invoke(invocation, (Keycloak)this.clients.get("view-realm"), true);
        this.invoke(invocation, (Keycloak)this.clients.get("manage-realm"), true);
        this.invoke(invocation, (Keycloak)this.clients.get("multi"), true);
        this.invoke(invocation, (Keycloak)this.clients.get("master-admin"), true);
        this.invoke(invocation, (Keycloak)this.clients.get("none"), false);
        this.invoke(invocation, (Keycloak)this.clients.get("REALM2"), false);
    }
}

