/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.admin.AbstractPermissionsTest;
import org.keycloak.tests.admin.authz.fgap.KeycloakAdminPermissionsV1ServerConfig;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest(config=KeycloakAdminPermissionsV1ServerConfig.class)
public class PermissionsTestV1
extends AbstractPermissionsTest {
    @InjectRealm(config=AbstractPermissionsTest.PermissionsTestRealmConfig1.class, ref="realm1")
    ManagedRealm managedRealm1;
    @InjectRealm(config=AbstractPermissionsTest.PermissionsTestRealmConfig2.class, ref="realm2")
    ManagedRealm managedRealm2;

    @Test
    public void clientAuthorization() {
        String fooAuthzClientUuid = ApiUtil.getCreatedId((Response)this.managedRealm1.admin().clients().create(ClientConfigBuilder.create().clientId("foo-authz").build()));
        ClientRepresentation foo = this.managedRealm1.admin().clients().get(fooAuthzClientUuid).toRepresentation();
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            foo.setServiceAccountsEnabled(Boolean.valueOf(true));
            foo.setAuthorizationServicesEnabled(Boolean.valueOf(true));
            realm.clients().get(foo.getId()).update(foo);
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clients().get(foo.getId()).authorization().getSettings(), AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            ResourceServerRepresentation settings = authorization.getSettings();
            authorization.update(settings);
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.resources().resources();
        }, AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.scopes().scopes();
        }, AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.policies().policies();
        }, AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            response.set(authorization.resources().create(new ResourceRepresentation("Test", Collections.emptySet())));
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            response.set(authorization.scopes().create(new ScopeRepresentation("Test")));
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
            representation.setName("Test PermissionsTest");
            representation.addResource("Default Resource");
            response.set(authorization.permissions().resource().create(representation));
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.resources().resource("nosuch").update(new ResourceRepresentation());
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.scopes().scope("nosuch").update(new ScopeRepresentation());
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.policies().policy("nosuch").update(new PolicyRepresentation());
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.resources().resource("nosuch").remove();
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.scopes().scope("nosuch").remove();
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke((RealmResource realm) -> {
            AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
            authorization.policies().policy("nosuch").remove();
        }, AdminAuth.Resource.AUTHORIZATION, true);
    }
}

