/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.AdminRoles;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.admin.AbstractPermissionsTest;
import org.keycloak.tests.utils.Assert;

@KeycloakIntegrationTest
public class PermissionsWithRemovalTest
extends AbstractPermissionsTest {
    @Override
    @BeforeEach
    public void beforeEach() {
        this.recreatePermissionRealm();
        AbstractPermissionsTest.PermissionsTestRealmConfig2 realm2Config = new AbstractPermissionsTest.PermissionsTestRealmConfig2();
        RealmRepresentation realm2 = realm2Config.configure(RealmConfigBuilder.create()).build();
        this.adminClient.realms().create(realm2);
        super.beforeEach();
    }

    public void recreatePermissionRealm() {
        AbstractPermissionsTest.PermissionsTestRealmConfig1 realm1Config = new AbstractPermissionsTest.PermissionsTestRealmConfig1();
        RealmRepresentation realm1 = realm1Config.configure(RealmConfigBuilder.create()).build();
        this.adminClient.realms().create(realm1);
    }

    @AfterEach
    public void afterEach() {
        this.adminClient.realms().realm("realm2").remove();
        this.adminClient.realms().realm("permissions-test").remove();
    }

    @Test
    public void realms() throws Exception {
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("master-none")).realms().findAll(), (Keycloak)this.clients.get("none"), false);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("none")).realms().findAll(), (Keycloak)this.clients.get("none"), false);
        Assert.assertNames((List)((Keycloak)this.clients.get("master-admin")).realms().findAll(), (String[])new String[]{"master", "permissions-test", "realm2"});
        Assert.assertNames((List)((Keycloak)this.clients.get("realm-admin")).realms().findAll(), (String[])new String[]{"permissions-test"});
        Assert.assertNames((List)((Keycloak)this.clients.get("REALM2")).realms().findAll(), (String[])new String[]{"realm2"});
        List realms = ((Keycloak)this.clients.get("view-users")).realms().findAll();
        Assert.assertNames((List)realms, (String[])new String[]{"permissions-test"});
        this.assertGettersEmpty((RealmRepresentation)realms.get(0));
        realms = ((Keycloak)this.clients.get("view-realm")).realms().findAll();
        Assert.assertNames((List)realms, (String[])new String[]{"permissions-test"});
        Assertions.assertNotNull((Object)((RealmRepresentation)realms.get(0)).getAccessTokenLifespan());
        realms = ((Keycloak)this.clients.get("master-view-users")).realms().findAll();
        Assert.assertNames((List)realms, (String[])new String[]{"permissions-test"});
        this.assertGettersEmpty((RealmRepresentation)realms.get(0));
        realms = ((Keycloak)this.clients.get("master-view-realm")).realms().findAll();
        Assert.assertNames((List)realms, (String[])new String[]{"permissions-test"});
        Assertions.assertNotNull((Object)((RealmRepresentation)realms.get(0)).getAccessTokenLifespan());
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("master-admin")).realms().create(RealmConfigBuilder.create().name("master").build()), this.adminClient, true);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("master-manage-users")).realms().create(RealmConfigBuilder.create().name("master").build()), this.adminClient, false);
        this.invoke((RealmResource realm) -> ((Keycloak)this.clients.get("realm-admin")).realms().create(RealmConfigBuilder.create().name("master").build()), this.adminClient, false);
        this.invoke(RealmResource::toRepresentation, AdminAuth.Resource.REALM, false, true);
        RealmRepresentation realm12 = ((Keycloak)this.clients.get("query-realms")).realm("permissions-test").toRepresentation();
        this.assertGettersEmpty(realm12);
        Assertions.assertNull((Object)realm12.isRegistrationEmailAsUsername());
        Assertions.assertNull((Object)realm12.getAttributes());
        realm12 = ((Keycloak)this.clients.get("view-users")).realm("permissions-test").toRepresentation();
        Assertions.assertNotNull((Object)realm12.isRegistrationEmailAsUsername());
        realm12 = ((Keycloak)this.clients.get("manage-users")).realm("permissions-test").toRepresentation();
        Assertions.assertNotNull((Object)realm12.isRegistrationEmailAsUsername());
        realm12 = ((Keycloak)this.clients.get("query-users")).realm("permissions-test").toRepresentation();
        Assertions.assertNull((Object)realm12.isRegistrationEmailAsUsername());
        Assertions.assertNull((Object)realm12.getAttributes());
        for (String role : AdminRoles.ALL_QUERY_ROLES) {
            this.invoke((RealmResource realmm) -> ((Keycloak)this.clients.get(role)).realms().realm("permissions-test").toRepresentation(), (Keycloak)this.clients.get(role), true);
        }
        this.invoke((RealmResource realm1) -> realm1.update(new RealmRepresentation()), AdminAuth.Resource.REALM, true);
        this.invoke(RealmResource::pushRevocation, AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm4) -> realm4.deleteSession("nosuch", false), AdminAuth.Resource.USER, true);
        this.invoke(RealmResource::getClientSessionStats, AdminAuth.Resource.REALM, false);
        this.invoke(RealmResource::getDefaultGroups, AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm7) -> realm7.addDefaultGroup("nosuch"), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm9) -> realm9.removeDefaultGroup("nosuch"), AdminAuth.Resource.REALM, true);
        GroupRepresentation newGroup = new GroupRepresentation();
        newGroup.setName("sample");
        this.adminClient.realm("permissions-test").groups().add(newGroup);
        GroupRepresentation group = this.adminClient.realms().realm("permissions-test").getGroupByPath("sample");
        this.invoke((RealmResource realm2) -> realm2.getGroupByPath("sample"), AdminAuth.Resource.USER, false);
        this.adminClient.realms().realm("permissions-test").groups().group(group.getId()).remove();
        this.invoke((RealmResource realm5, AtomicReference<Response> response) -> {
            TestLdapConnectionRepresentation config = new TestLdapConnectionRepresentation("nosuch", "nosuch", "nosuch", "nosuch", "nosuch", "nosuch");
            response.set(realm5.testLDAPConnection(config.getAction(), config.getConnectionUrl(), config.getBindDn(), config.getBindCredential(), config.getUseTruststoreSpi(), config.getConnectionTimeout()));
            response.set(realm5.testLDAPConnection(config));
        }, AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm3, AtomicReference<Response> response) -> response.set(realm3.partialImport(new PartialImportRepresentation())), AdminAuth.Resource.REALM, true);
        this.invoke(RealmResource::clearRealmCache, AdminAuth.Resource.REALM, true);
        this.invoke(RealmResource::clearUserCache, AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm6) -> ((Keycloak)this.clients.get("master-admin")).realms().realm("nosuch").remove(), this.adminClient, true);
        this.invoke((RealmResource realm8) -> ((Keycloak)this.clients.get("REALM2")).realms().realm("permissions-test").remove(), this.adminClient, false);
        this.invoke((RealmResource realm11) -> ((Keycloak)this.clients.get("manage-users")).realms().realm("permissions-test").remove(), this.adminClient, false);
        this.invoke((RealmResource realm10) -> ((Keycloak)this.clients.get("realm-admin")).realms().realm("permissions-test").remove(), this.adminClient, true);
        this.recreatePermissionRealm();
    }

    private void assertGettersEmpty(RealmRepresentation rep) {
        this.assertGettersEmpty(rep, "getRealm", "getAttributesOrEmpty", "getDisplayNameHtml", "getDisplayName", "getDefaultLocale", "getSupportedLocales");
    }

    private void assertGettersEmpty(Object rep, String ... ignore) {
        List<String> ignoreList = Arrays.asList(ignore);
        for (Method m : rep.getClass().getDeclaredMethods()) {
            if (m.getParameterCount() != 0 || !m.getName().startsWith("get") || ignoreList.contains(m.getName())) continue;
            try {
                Object o = m.invoke(rep, new Object[0]);
                Assertions.assertNull((Object)o, (String)("Expected " + m.getName() + " to be null"));
            }
            catch (Exception e) {
                Assertions.fail((String)e.getMessage());
            }
        }
    }

    @Test
    public void flows() {
        this.invoke((RealmResource realm) -> realm.flows().getFormProviders(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().getAuthenticatorProviders(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().getClientAuthenticatorProviders(), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> realm.flows().getFormActionProviders(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().getFlows(), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.flows().createFlow(new AuthenticationFlowRepresentation())), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().getFlow("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().deleteFlow("nosuch"), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.flows().copy("nosuch", Map.of())), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().addExecutionFlow("nosuch", Map.of()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().addExecution("nosuch", Map.of()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().getExecutions("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().getExecution("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().updateExecutions("nosuch", new AuthenticationExecutionInfoRepresentation()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
            rep.setAuthenticator("auth-cookie");
            rep.setRequirement("CONDITIONAL");
            response.set(realm.flows().addExecution(rep));
        }, AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().raisePriority("nosuch"), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().lowerPriority("nosuch"), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().removeExecution("nosuch"), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.flows().newExecutionConfig("nosuch", new AuthenticatorConfigRepresentation())), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().getAuthenticatorConfig("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().getUnregisteredRequiredActions(), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().registerRequiredAction(new RequiredActionProviderSimpleRepresentation()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().getRequiredActions(), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> realm.flows().getRequiredAction("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().removeRequiredAction("nosuch"), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().updateRequiredAction("nosuch", new RequiredActionProviderRepresentation()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().getAuthenticatorConfigDescription("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().getPerClientConfigDescription(), AdminAuth.Resource.REALM, false, true);
        this.invoke((RealmResource realm) -> realm.flows().getAuthenticatorConfig("nosuch"), AdminAuth.Resource.REALM, false);
        this.invoke((RealmResource realm) -> realm.flows().removeAuthenticatorConfig("nosuch"), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> realm.flows().updateAuthenticatorConfig("nosuch", new AuthenticatorConfigRepresentation()), AdminAuth.Resource.REALM, true);
        this.invoke((RealmResource realm) -> {
            ((Keycloak)this.clients.get("view-realm")).realm("permissions-test").flows().getPerClientConfigDescription();
            ((Keycloak)this.clients.get("view-realm")).realm("permissions-test").flows().getClientAuthenticatorProviders();
            ((Keycloak)this.clients.get("view-realm")).realm("permissions-test").flows().getRequiredActions();
        }, this.adminClient, true);
        this.adminClient.realm("permissions-test").remove();
        this.recreatePermissionRealm();
    }
}

