/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.NotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;

@KeycloakIntegrationTest
public class RealmLocalizationResourceTest {
    @InjectRealm(config=RealmLocaleConfig.class)
    private ManagedRealm realm;

    @Test
    public void getRealmSpecificLocales() {
        List languages = this.realm.admin().localization().getRealmSpecificLocales();
        Assertions.assertEquals((int)2, (int)languages.size());
        MatcherAssert.assertThat((Object)languages, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"en", "de"}));
    }

    @Test
    public void getRealmLocalizationTexts() {
        Map localizations = this.realm.admin().localization().getRealmLocalizationTexts("en");
        Assertions.assertNotNull((Object)localizations);
        Assertions.assertEquals((int)2, (int)localizations.size());
        Assertions.assertEquals((Object)"text-a_en", localizations.get("key-a"));
        Assertions.assertEquals((Object)"text-b_en", localizations.get("key-b"));
    }

    @Test
    public void getRealmLocalizationTextsWithFallback() {
        Map localizations = this.realm.admin().localization().getRealmLocalizationTexts("de", Boolean.valueOf(true));
        Assertions.assertNotNull((Object)localizations);
        Assertions.assertEquals((int)2, (int)localizations.size());
        Assertions.assertEquals((Object)"text-a_de", localizations.get("key-a"));
        Assertions.assertEquals((Object)"text-b_en", localizations.get("key-b"));
    }

    @Test
    public void getRealmLocalizationsNotExists() {
        Map localizations = this.realm.admin().localization().getRealmLocalizationTexts("zz");
        Assertions.assertNotNull((Object)localizations);
        Assertions.assertEquals((int)0, (int)localizations.size());
    }

    @Test
    public void getRealmLocalizationText() {
        String localizationText = this.realm.admin().localization().getRealmLocalizationText("en", "key-a");
        Assertions.assertNotNull((Object)localizationText);
        Assertions.assertEquals((Object)"text-a_en", (Object)localizationText);
    }

    @Test
    public void getRealmLocalizationTextNotExists() {
        Assertions.assertThrows(NotFoundException.class, () -> this.realm.admin().localization().getRealmLocalizationText("en", "key-zz"));
    }

    @Test
    public void addRealmLocalizationText() {
        this.realm.cleanup().add(r -> r.localization().deleteRealmLocalizationText("en", "key-c"));
        this.realm.admin().localization().saveRealmLocalizationText("en", "key-c", "text-c");
        String localizationText = this.realm.admin().localization().getRealmLocalizationText("en", "key-c");
        Assertions.assertNotNull((Object)localizationText);
        Assertions.assertEquals((Object)"text-c", (Object)localizationText);
    }

    @Test
    public void updateRealmLocalizationText() {
        this.realm.cleanup().add(r -> r.localization().saveRealmLocalizationText("en", "key-b", "text-b_en"));
        this.realm.admin().localization().saveRealmLocalizationText("en", "key-b", "text-b-new");
        String localizationText = this.realm.admin().localization().getRealmLocalizationText("en", "key-b");
        Assertions.assertNotNull((Object)localizationText);
        Assertions.assertEquals((Object)"text-b-new", (Object)localizationText);
    }

    @Test
    public void deleteRealmLocalizationText() {
        this.realm.cleanup().add(r -> r.localization().saveRealmLocalizationText("en", "key-a", "text-a_en"));
        this.realm.admin().localization().deleteRealmLocalizationText("en", "key-a");
        Map localizations = this.realm.admin().localization().getRealmLocalizationTexts("en");
        Assertions.assertEquals((int)1, (int)localizations.size());
        Assertions.assertEquals((Object)"text-b_en", localizations.get("key-b"));
    }

    @Test
    public void deleteRealmLocalizationTextNotExists() {
        Assertions.assertThrows(NotFoundException.class, () -> this.realm.admin().localization().deleteRealmLocalizationText("en", "zz"));
    }

    @Test
    public void deleteRealmLocalizationTexts() {
        this.realm.cleanup().add(r -> r.localization().saveRealmLocalizationText("en", "key-a", "text-a_en"));
        this.realm.cleanup().add(r -> r.localization().saveRealmLocalizationText("en", "key-b", "text-b_en"));
        this.realm.admin().localization().deleteRealmLocalizationTexts("en");
        List localizations = this.realm.admin().localization().getRealmSpecificLocales();
        Assertions.assertEquals((int)1, (int)localizations.size());
        MatcherAssert.assertThat((Object)localizations, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"de"}));
    }

    @Test
    public void createOrUpdateRealmLocalizationWhenLocaleDoesNotYetExist() {
        this.realm.cleanup().add(r -> r.localization().deleteRealmLocalizationTexts("es"));
        HashMap<String, String> newLocalizationTexts = new HashMap<String, String>();
        newLocalizationTexts.put("key-a", "text-a_es");
        newLocalizationTexts.put("key-b", "text-b_es");
        this.realm.admin().localization().createOrUpdateRealmLocalizationTexts("es", newLocalizationTexts);
        Map persistedLocalizationTexts = this.realm.admin().localization().getRealmLocalizationTexts("es");
        Assertions.assertEquals(newLocalizationTexts, (Object)persistedLocalizationTexts);
    }

    @Test
    public void createOrUpdateRealmLocalizationWhenLocaleAlreadyExists() {
        this.realm.cleanup().add(r -> r.localization().saveRealmLocalizationText("en", "key-b", "text-b_en"));
        HashMap<String, String> newLocalizationTexts = new HashMap<String, String>();
        newLocalizationTexts.put("key-b", "text-b_changed_en");
        newLocalizationTexts.put("key-c", "text-c_en");
        this.realm.admin().localization().createOrUpdateRealmLocalizationTexts("en", newLocalizationTexts);
        HashMap<String, String> expectedLocalizationTexts = new HashMap<String, String>();
        expectedLocalizationTexts.put("key-a", "text-a_en");
        expectedLocalizationTexts.putAll(newLocalizationTexts);
        Map persistedLocalizationTexts = this.realm.admin().localization().getRealmLocalizationTexts("en");
        Assertions.assertEquals(expectedLocalizationTexts, (Object)persistedLocalizationTexts);
    }

    private static class RealmLocaleConfig
    implements RealmConfig {
        private RealmLocaleConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            RealmRepresentation rep = realm.build();
            rep.setDefaultLocale("en");
            rep.setLocalizationTexts(Map.of("en", Map.of("key-a", "text-a_en", "key-b", "text-b_en"), "de", Map.of("key-a", "text-a_de")));
            rep.setEnabled(Boolean.valueOf(true));
            return RealmConfigBuilder.update((RealmRepresentation)rep);
        }
    }
}

