/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class RoleByIdResourceTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectClient(lifecycle=LifeCycle.METHOD)
    ManagedClient managedClient;
    @InjectAdminEvents
    AdminEvents adminEvents;
    private RoleByIdResource resource;
    private final String roleNameA = "role-a";
    private final String roleNameB = "role-b";
    private final String roleNameC = "role-c";
    private final String roleNameD = "role-d";
    private final String roleNameCompositeWihD = "composite-role-with-d";
    private Map<String, String> roleIds = new HashMap<String, String>();

    @BeforeEach
    public void before() {
        this.managedRealm.admin().roles().create(RoleConfigBuilder.create().name("role-a").description("Role A").build());
        this.managedRealm.admin().roles().create(RoleConfigBuilder.create().name("role-b").description("Role B").build());
        RoleRepresentation roleD = RoleConfigBuilder.create().name("role-d").description("Role D").build();
        this.managedRealm.admin().roles().create(roleD);
        this.managedRealm.admin().roles().create(RoleConfigBuilder.create().name("composite-role-with-d").description("Composite Role with Role D").composite(true).realmComposite(roleD.getName()).build());
        this.managedRealm.admin().clients().get(this.managedClient.getId()).roles().create(RoleConfigBuilder.create().name("role-c").description("Role C").build());
        this.managedRealm.admin().roles().list().forEach(r -> this.roleIds.put(r.getName(), r.getId()));
        this.managedRealm.admin().clients().get(this.managedClient.getId()).roles().list().forEach(r -> this.roleIds.put(r.getName(), r.getId()));
        this.resource = this.managedRealm.admin().rolesById();
        this.adminEvents.skipAll();
    }

    @Test
    public void getRole() {
        RoleRepresentation role = this.resource.getRole(this.roleIds.get("role-a"));
        Assertions.assertNotNull((Object)role);
        Assertions.assertEquals((Object)"role-a", (Object)role.getName());
        Assertions.assertEquals((Object)"Role A", (Object)role.getDescription());
        Assertions.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void updateRole() {
        RoleRepresentation role = this.resource.getRole(this.roleIds.get("role-a"));
        role.setName("role-a-new");
        role.setDescription("Role A New");
        this.resource.updateRole(this.roleIds.get("role-a"), role);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.roleByIdResourcePath((String)this.roleIds.get("role-a")), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        role = this.resource.getRole(this.roleIds.get("role-a"));
        Assertions.assertNotNull((Object)role);
        Assertions.assertEquals((Object)"role-a-new", (Object)role.getName());
        Assertions.assertEquals((Object)"Role A New", (Object)role.getDescription());
        Assertions.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void deleteRole() {
        Assertions.assertNotNull((Object)this.resource.getRole(this.roleIds.get("role-a")));
        this.resource.deleteRole(this.roleIds.get("role-a"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.roleByIdResourcePath((String)this.roleIds.get("role-a")), (ResourceType)ResourceType.REALM_ROLE);
        try {
            this.resource.getRole(this.roleIds.get("role-a"));
            Assertions.fail((String)"Expected 404");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void composites() {
        Assertions.assertFalse((boolean)this.resource.getRole(this.roleIds.get("role-a")).isComposite());
        Assertions.assertEquals((int)0, (int)this.resource.getRoleComposites(this.roleIds.get("role-a")).size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(RoleConfigBuilder.create().id(this.roleIds.get("role-b")).build());
        l.add(RoleConfigBuilder.create().id(this.roleIds.get("role-c")).build());
        this.resource.addComposites(this.roleIds.get("role-a"), l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleByIdResourceCompositesPath((String)this.roleIds.get("role-a")), l, (ResourceType)ResourceType.REALM_ROLE);
        Set composites = this.resource.getRoleComposites(this.roleIds.get("role-a"));
        Assertions.assertTrue((boolean)this.resource.getRole(this.roleIds.get("role-a")).isComposite());
        Assert.assertNames((Set)composites, (String[])new String[]{"role-b", "role-c"});
        Set realmComposites = this.resource.getRealmRoleComposites(this.roleIds.get("role-a"));
        Assert.assertNames((Set)realmComposites, (String[])new String[]{"role-b"});
        Set clientComposites = this.resource.getClientRoleComposites(this.roleIds.get("role-a"), this.managedClient.getId());
        Assert.assertNames((Set)clientComposites, (String[])new String[]{"role-c"});
        composites = this.resource.searchRoleComposites(this.roleIds.get("role-a"), null, null, null);
        Assert.assertNames((Set)composites, (String[])new String[]{"role-b", "role-c"});
        composites = this.resource.searchRoleComposites(this.roleIds.get("role-a"), "b", null, null);
        Assert.assertNames((Set)composites, (String[])new String[]{"role-b"});
        composites = this.resource.searchRoleComposites(this.roleIds.get("role-a"), null, Integer.valueOf(0), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)composites, (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        composites = this.resource.searchRoleComposites(this.roleIds.get("role-a"), null, Integer.valueOf(0), Integer.valueOf(1));
        Assert.assertNames((Set)composites, (String[])new String[]{"role-b"});
        composites = this.resource.searchRoleComposites(this.roleIds.get("role-a"), null, Integer.valueOf(1), Integer.valueOf(1));
        Assert.assertNames((Set)composites, (String[])new String[]{"role-c"});
        this.resource.deleteComposites(this.roleIds.get("role-a"), l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.roleByIdResourceCompositesPath((String)this.roleIds.get("role-a")), l, (ResourceType)ResourceType.REALM_ROLE);
        Assertions.assertFalse((boolean)this.resource.getRole(this.roleIds.get("role-a")).isComposite());
        Assertions.assertEquals((int)0, (int)this.resource.getRoleComposites(this.roleIds.get("role-a")).size());
    }

    @Test
    public void createNewMixedRealmCompositeRole() {
        RoleRepresentation newRoleComp = RoleConfigBuilder.create().name("role-mixed-comp").composite(true).realmComposite("role-a").realmComposite("composite-role-with-d").clientComposite(this.managedClient.getClientId(), "role-c").build();
        this.managedRealm.admin().roles().create(newRoleComp);
        RoleRepresentation roleMixedComp = this.managedRealm.admin().roles().get(newRoleComp.getName()).toRepresentation();
        Assertions.assertTrue((boolean)roleMixedComp.isComposite());
        Predicate<RoleRepresentation> isClientRole = RoleRepresentation::getClientRole;
        Set roleComposites = this.resource.getRoleComposites(roleMixedComp.getId());
        Set containedRealmRoles = roleComposites.stream().filter(isClientRole.negate()).collect(Collectors.toSet());
        Assertions.assertFalse((boolean)containedRealmRoles.isEmpty());
        Assertions.assertTrue((boolean)containedRealmRoles.stream().anyMatch(r -> r.getName().equals("role-a")));
        Assertions.assertTrue((boolean)containedRealmRoles.stream().anyMatch(r -> r.getName().equals("composite-role-with-d")));
        Set containedClientRoles = roleComposites.stream().filter(isClientRole).collect(Collectors.toSet());
        Assertions.assertFalse((boolean)containedClientRoles.isEmpty());
        Assertions.assertTrue((boolean)containedClientRoles.stream().anyMatch(r -> r.getContainerId().equals(this.managedClient.getId()) && r.getName().equals("role-c")));
        int expectedCompositeCount = newRoleComp.getComposites().getRealm().size() + newRoleComp.getComposites().getClient().size();
        Assertions.assertEquals((int)expectedCompositeCount, (int)roleComposites.size());
    }

    @Test
    public void createNewMixedRealmCompositeRoleWithUnknownRealmRoleShouldThrow() {
        String unknownRealmRole = "realm-role-unknown";
        RoleRepresentation newRoleComp = RoleConfigBuilder.create().name("role-broken-comp1").composite(true).realmComposite(unknownRealmRole).clientComposite(this.managedRealm.getId(), "role-c").build();
        Assertions.assertThrowsExactly(NotFoundException.class, () -> this.managedRealm.admin().roles().create(newRoleComp));
    }

    @Test
    public void createNewMixedRealmCompositeRoleWithUnknownClientRoleShouldThrow() {
        String unknownClientRole = "client-role-unknown";
        RoleRepresentation newRoleComp = RoleConfigBuilder.create().name("role-broken-comp2").composite(true).realmComposite("role-a").clientComposite(this.managedClient.getClientId(), unknownClientRole).build();
        Assertions.assertThrowsExactly(NotFoundException.class, () -> this.managedRealm.admin().roles().create(newRoleComp));
    }

    @Test
    public void attributes() {
        for (String id : this.roleIds.values()) {
            RoleRepresentation role = this.resource.getRole(id);
            Assertions.assertNotNull((Object)role.getAttributes());
            Assertions.assertTrue((boolean)role.getAttributes().isEmpty());
            HashMap attributes = new HashMap();
            ArrayList<String> attributeValues = new ArrayList<String>();
            attributeValues.add("value1");
            attributes.put("key1", attributeValues);
            attributeValues = new ArrayList();
            attributeValues.add("value2.1");
            attributeValues.add("value2.2");
            attributes.put("key2", attributeValues);
            role.setAttributes(attributes);
            this.resource.updateRole(id, role);
            role = this.resource.getRole(id);
            Assertions.assertNotNull((Object)role);
            Map roleAttributes = role.getAttributes();
            Assertions.assertNotNull((Object)roleAttributes);
            Assert.assertRoleAttributes(attributes, (Map)roleAttributes);
            attributes.remove("key2");
            role.setAttributes(attributes);
            this.resource.updateRole(id, role);
            role = this.resource.getRole(id);
            Assertions.assertNotNull((Object)role);
            roleAttributes = role.getAttributes();
            Assertions.assertNotNull((Object)roleAttributes);
            Assert.assertRoleAttributes(attributes, (Map)roleAttributes);
        }
    }

    @Test
    public void deleteDefaultRole() {
        RoleRepresentation role = this.managedRealm.admin().roles().get("default-roles-" + this.managedRealm.getName()).toRepresentation();
        Assertions.assertThrowsExactly(BadRequestException.class, () -> this.resource.deleteRole(role.getId()));
    }

    @Test
    public void renameRoleToNamePreviouslyCached() {
        String roleName = "realm-role-new-" + new Random().nextInt();
        RoleRepresentation newRoleRepresentation = RoleConfigBuilder.create().name(roleName).build();
        this.managedRealm.admin().roles().create(newRoleRepresentation);
        RoleRepresentation roleRepresentation = this.managedRealm.admin().roles().get(roleName).toRepresentation();
        String newRoleName = "realm-role-renamed-" + new Random().nextInt();
        this.cacheMissingRoleName(newRoleName);
        RoleRepresentation updatedRoleRepresentation = RoleConfigBuilder.create().id(roleRepresentation.getId()).name(newRoleName).build();
        this.resource.updateRole(roleRepresentation.getId(), updatedRoleRepresentation);
        try {
            this.managedRealm.admin().roles().get(newRoleName).toRepresentation();
        }
        catch (NotFoundException e) {
            Assertions.fail((String)"Role is incorrectly cached");
        }
    }

    @Test
    public void createRolePreviouslyCached() {
        String roleName = "realm-role-new-" + new Random().nextInt();
        RoleRepresentation roleRepresentation = RoleConfigBuilder.create().name(roleName).build();
        this.cacheMissingRoleName(roleName);
        this.managedRealm.admin().roles().create(roleRepresentation);
        try {
            this.managedRealm.admin().roles().get(roleName).toRepresentation();
        }
        catch (NotFoundException e) {
            Assertions.fail((String)"Role is incorrectly cached");
        }
    }

    private void cacheMissingRoleName(String missingRoleName) {
        Assertions.assertThrows(NotFoundException.class, () -> this.managedRealm.admin().roles().get(missingRoleName).toRepresentation());
    }
}

