/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.mail.Address;
import jakarta.mail.internet.MimeMessage;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.mail.MailServer;
import org.keycloak.testframework.mail.annotations.InjectMailServer;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@KeycloakIntegrationTest
public class SMTPConnectionTest {
    @InjectRealm(config=SMTPRealmWithClientAndUser.class)
    private ManagedRealm managedRealm;
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    private Keycloak adminClient;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    @InjectMailServer
    private MailServer mailServer;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;

    @Test
    @Order(value=1)
    public void testWithNullSettings() throws Exception {
        Response response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.settings(null, null, null, null, null, null, null, null));
        this.assertStatus(response, 500);
    }

    @Test
    @Order(value=2)
    public void testWithProperSettings() throws Exception {
        Response response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", null, null, null, null, null));
        this.assertStatus(response, 204);
        this.assertMailReceived(new String[0]);
    }

    @Test
    @Order(value=3)
    public void testWithAuthEnabledCredentialsEmpty() throws Exception {
        Response response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, null, null));
        this.assertStatus(response, 500);
    }

    @Test
    @Order(value=4)
    public void testWithAuthEnabledValidCredentials() throws Exception {
        String password = "admin";
        this.mailServer.credentials("admin@localhost", password);
        Response response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", password));
        this.assertStatus(response, 204);
    }

    @Test
    @Order(value=5)
    public void testAuthEnabledAndSavedCredentials() throws Exception {
        String password = "admin";
        RealmResource realm = this.adminClient.realms().realm(this.managedRealm.getName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setSmtpServer(this.smtpMap("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", password, null, null, null));
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> RealmConfigBuilder.update((RealmRepresentation)realmRep)});
        this.mailServer.credentials("admin@localhost", password);
        Response response = realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", "**********"));
        this.assertStatus(response, 204);
        this.mailServer.credentials("admin@localhost", password);
        response = realm.testSMTPConnection(this.settings("localhost", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", "**********"));
        this.assertStatus(response, 500);
    }

    @Test
    @Order(value=6)
    public void testWithTokenAuthEnabledAndTokenCacheAndSavedCredentials() throws Exception {
        RealmResource realm = this.adminClient.realms().realm(this.managedRealm.getName());
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setSmtpServer(this.smtpMapForTokenAuth("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.keycloakUrls.getToken(this.managedRealm.getName()), "test-smtp-client-I", "secret", "basic", null, null));
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> RealmConfigBuilder.update((RealmRepresentation)realmRep)});
        this.mailServer.credentials("admin@localhost", token -> {
            AccessToken accessToken = (AccessToken)this.oAuthClient.verifyToken(token, AccessToken.class);
            return accessToken.isActive();
        });
        Response firstResponse = realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.keycloakUrls.getToken(this.managedRealm.getName()), "test-smtp-client-I", "**********", "basic"));
        this.assertStatus(firstResponse, 204);
        this.assertMailReceived(new String[0]);
        this.assertClientLoginEventsCountAndClear(realm, "test-smtp-client-I", 1);
        this.assertEventsEmpty(realm);
        Response secondResponse = realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.keycloakUrls.getToken(this.managedRealm.getName()), "test-smtp-client-I", "**********", "basic"));
        this.assertStatus(secondResponse, 204);
        this.assertMailReceived(new String[0]);
        this.assertEventsEmpty(realm);
        Response thirdResponse = realm.testSMTPConnection(this.settings("localhost", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.keycloakUrls.getToken(this.managedRealm.getName()), "test-smtp-client-I", "**********", "basic"));
        this.assertStatus(thirdResponse, 500);
    }

    @Test
    @Order(value=7)
    public void testWithTokenAuthEnabledRetryGivesUp() throws Exception {
        RealmResource realm = this.adminClient.realms().realm(this.managedRealm.getName());
        RealmRepresentation realmRep = realm.toRepresentation();
        this.mailServer.credentials("admin@localhost", token -> false);
        Response response = realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.keycloakUrls.getToken(this.managedRealm.getName()), "test-smtp-client-II", "secret", "basic"));
        this.assertStatus(response, 500);
        this.assertMailNotReceived();
        this.assertClientLoginEventsCountAndClear(realm, "test-smtp-client-II", 2);
        this.assertEventsEmpty(realm);
    }

    @Test
    @Order(value=8)
    public void testWithTokenAuthEnabledAndRetryWithValidTokenInSecondTry() throws Exception {
        RealmResource realm = this.adminClient.realms().realm(this.managedRealm.getName());
        ArrayList tempAccessToken = new ArrayList();
        this.mailServer.credentials("admin@localhost", token -> {
            AccessToken accessToken = (AccessToken)this.oAuthClient.verifyToken(token, AccessToken.class);
            if (tempAccessToken.isEmpty()) {
                tempAccessToken.add(accessToken);
                return false;
            }
            Assertions.assertNotEquals((Object)((AccessToken)tempAccessToken.stream().findFirst().orElseThrow()).getId(), (Object)accessToken.getId());
            tempAccessToken.clear();
            return accessToken.isActive();
        });
        Response response = realm.testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", "true", null, null, "admin@localhost", this.keycloakUrls.getToken(this.managedRealm.getName()), "test-smtp-client-III", "secret", "basic"));
        this.assertStatus(response, 204);
        this.assertMailReceived(new String[0]);
        this.assertClientLoginEventsCountAndClear(realm, "test-smtp-client-III", 2);
        this.assertEventsEmpty(realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Order(value=9)
    public void testAllowUTF8() throws Exception {
        Response response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.settings("127.0.0.1", "3025", "auto\u00f1@keycloak.org", null, null, null, null, null));
        this.assertStatus(response, 500);
        response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak\u00f1.org", null, null, null, null, null));
        this.assertStatus(response, 204);
        this.assertMailReceived("auto@xn--keycloak-k3a.org");
        response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.smtpMap("127.0.0.1", "3025", "auto\u00f1@keycloak.org", null, null, null, null, null, null, null, "true"));
        this.assertStatus(response, 204);
        this.assertMailReceived(new String[0]);
        RealmResource realmRes = this.adminClient.realms().realm(this.managedRealm.getName());
        RealmRepresentation realmRep = realmRes.toRepresentation();
        realmRep.getSmtpServer().put("allowutf8", Boolean.TRUE.toString());
        realmRes.update(realmRep);
        AccessToken token = (AccessToken)this.oAuthClient.parseToken(this.adminClient.tokenManager().getAccessToken().getToken(), AccessToken.class);
        UserResource userRes = this.adminClient.realm("default").users().get(token.getSubject());
        UserRepresentation userRep = userRes.toRepresentation();
        String previousEmail = userRep.getEmail();
        userRep.setEmail("admin\u00f1@localhost");
        userRes.update(userRep);
        try {
            response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.settings("127.0.0.1", "3025", "auto@keycloak.org", null, null, null, null, null));
            this.assertStatus(response, 500);
            response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(this.smtpMap("127.0.0.1", "3025", "auto@keycloak.org", null, null, null, null, null, null, null, "true"));
            this.assertStatus(response, 204);
            this.assertMailReceived(new String[0]);
        }
        finally {
            userRep.setEmail(previousEmail);
            userRes.update(userRep);
            realmRep.getSmtpServer().remove("allowutf8");
            realmRes.update(realmRep);
        }
    }

    private Map<String, String> settings(String host, String port, String from, String auth, String ssl, String starttls, String username, String password) throws Exception {
        return this.smtpMap(host, port, from, auth, ssl, starttls, username, password, "", "", null);
    }

    private Map<String, String> settings(String host, String port, String from, String auth, String ssl, String starttls, String username, String authTokenUrl, String authTokenClientId, String authTokenClientSecret, String authTokenScope) throws Exception {
        return this.smtpMapForTokenAuth(host, port, from, auth, ssl, starttls, username, authTokenUrl, authTokenClientId, authTokenClientSecret, authTokenScope, "", "");
    }

    private Map<String, String> smtpMapForTokenAuth(String host, String port, String from, String auth, String ssl, String starttls, String username, String authTokenUrl, String authTokenClientId, String authTokenClientSecret, String authTokenScope, String replyTo, String envelopeFrom) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("host", host);
        config.put("port", port);
        config.put("from", from);
        config.put("ssl", ssl);
        config.put("starttls", starttls);
        config.put("user", username);
        config.put("auth", auth);
        config.put("authType", "token");
        config.put("authTokenUrl", authTokenUrl);
        config.put("authTokenClientId", authTokenClientId);
        config.put("authTokenClientSecret", authTokenClientSecret);
        config.put("authTokenScope", authTokenScope);
        config.put("replyTo", replyTo);
        config.put("envelopeFrom", envelopeFrom);
        return config;
    }

    private Map<String, String> smtpMap(String host, String port, String from, String auth, String ssl, String starttls, String username, String password, String replyTo, String envelopeFrom, String allowutf8) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("host", host);
        config.put("port", port);
        config.put("from", from);
        config.put("auth", auth);
        config.put("authType", "basic");
        config.put("ssl", ssl);
        config.put("starttls", starttls);
        config.put("user", username);
        config.put("password", password);
        config.put("replyTo", replyTo);
        config.put("envelopeFrom", envelopeFrom);
        if (allowutf8 != null) {
            config.put("allowutf8", allowutf8);
        }
        return config;
    }

    private void assertClientLoginEventsCountAndClear(RealmResource realm, String clientId, int count) {
        List events = realm.getEvents();
        Assertions.assertEquals((long)count, (long)events.stream().filter(e -> clientId.equals(e.getClientId())).count());
        events.stream().filter(e -> clientId.equals(e.getClientId())).forEach(event -> Assertions.assertEquals((Object)"CLIENT_LOGIN", (Object)event.getType()));
        realm.clearEvents();
    }

    private void assertEventsEmpty(RealmResource realm) {
        Assertions.assertTrue((boolean)realm.getEvents().isEmpty());
    }

    private void assertStatus(Response response, int status) {
        Assertions.assertEquals((int)status, (int)response.getStatus());
        response.close();
    }

    private void assertMailReceived(String ... from) {
        if (this.mailServer.getReceivedMessages().length == 1) {
            try {
                MimeMessage message = this.mailServer.getReceivedMessages()[0];
                if (from.length > 0) {
                    Assertions.assertArrayEquals((Object[])from, (Object[])Arrays.stream(message.getFrom()).map(Address::toString).toArray(String[]::new));
                }
                Assertions.assertEquals((Object)"[KEYCLOAK] - SMTP test message", (Object)message.getSubject());
                this.mailServer.runCleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Assertions.fail((String)"E-mail was not received");
        }
    }

    private void assertMailNotReceived() {
        Assertions.assertEquals((int)0, (int)this.mailServer.getReceivedMessages().length);
    }

    public static class SMTPRealmWithClientAndUser
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.eventsEnabled(true);
            realm.addClient("myclient").secret("mysecret").directAccessGrantsEnabled(true);
            realm.addClient("test-smtp-client-I").secret("secret").serviceAccountsEnabled(true);
            realm.addClient("test-smtp-client-II").secret("secret").serviceAccountsEnabled(true);
            realm.addClient("test-smtp-client-III").secret("secret").serviceAccountsEnabled(true);
            realm.addUser("myadmin").name("My", "Admin").email("admin@localhost").emailVerified(true).password("myadmin").clientRoles("realm-management", new String[]{"realm-admin"});
            return realm;
        }
    }
}

