/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import jakarta.ws.rs.core.Response;
import java.net.URL;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.mail.MailServer;
import org.keycloak.testframework.mail.annotations.InjectMailServer;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.SMTPConnectionTest;

@KeycloakIntegrationTest(config=SMTPVaultConfig.class)
public class SMTPConnectionVaultTest {
    @InjectRealm(config=SMTPConnectionTest.SMTPRealmWithClientAndUser.class)
    private ManagedRealm managedRealm;
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    private Keycloak adminClient;
    @InjectMailServer
    private MailServer mailServer;

    @Test
    public void testWithAuthEnabledValidCredentials() throws Exception {
        String password = "admin";
        String vaultPassword = "${vault.smtp_password}";
        this.mailServer.credentials("admin@localhost", password);
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("host", "127.0.0.1");
        settings.put("port", "3025");
        settings.put("from", "auto@keycloak.org");
        settings.put("auth", "true");
        settings.put("ssl", null);
        settings.put("starttls", null);
        settings.put("user", "admin@localhost");
        settings.put("password", vaultPassword);
        settings.put("replyTo", "");
        settings.put("envelopeFrom", "");
        Response response = this.adminClient.realms().realm(this.managedRealm.getName()).testSMTPConnection(settings);
        Assertions.assertEquals((int)204, (int)response.getStatus());
        response.close();
    }

    public static class SMTPVaultConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            URL url = SMTPConnectionVaultTest.class.getResource("vault");
            if (url == null) {
                throw new RuntimeException("Unable to find the vault folder in the classpath for the default_smtp__password file!");
            }
            return config.option("vault", "file").option("vault-dir", url.getPath());
        }
    }
}

