/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin;

import java.io.Serializable;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserProvider;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;

@KeycloakIntegrationTest
public class UsersTest {
    private static final String realmName = "default";
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm realm;
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests", "org.keycloak.admin"})
    RunOnServerClient runOnServer;

    @Test
    public void searchUserWithWildcards() {
        this.createUser("User", "firstName", "lastName", "user@example.com");
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Use%", null, null), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Use_", null, null), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Us_r", null, null), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Use", null, null), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Use*", null, null), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Us*e", null, null), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void searchUserDefaultSettings() throws Exception {
        this.createUser("User", "firstName", "lastName", "user@example.com");
        this.assertCaseInsensitiveSearch();
    }

    @Test
    public void searchUserMatchUsersCount() {
        this.createUser("john.doe", "John", "Doe Smith", "john.doe@keycloak.org");
        String search = "jo do";
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(search), (Matcher)CoreMatchers.is((Object)1));
        List users = this.realm.admin().users().search(search, null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((UserRepresentation)users.get(0)).getUsername(), (Matcher)CoreMatchers.is((Object)"john.doe"));
    }

    @Test
    public void findUsersByEmailVerifiedStatus() {
        this.createUser(UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").emailVerified(true).enabled(true).build());
        this.createUser(UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").enabled(true).build());
        boolean emailVerified = true;
        List usersEmailVerified = this.realm.admin().users().search(null, null, null, null, Boolean.valueOf(emailVerified), null, null, null, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)usersEmailVerified, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)((UserRepresentation)usersEmailVerified.get(0)).getUsername(), (Matcher)CoreMatchers.is((Object)"user1"));
        this.createUser(UserConfigBuilder.create().username("testuser2").password("password").name("testuser2", "testuser2").email("testuser2@example.com").emailVerified(true).enabled(true).build());
        usersEmailVerified = this.realm.admin().users().search("user", null, null, null, Boolean.valueOf(emailVerified), null, null, null);
        MatcherAssert.assertThat((Object)usersEmailVerified, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)usersEmailVerified.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((UserRepresentation)usersEmailVerified.get(0)).getUsername(), (Matcher)CoreMatchers.is((Object)"user1"));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("user", null, null, null, Boolean.valueOf(emailVerified), null, null, null), (Matcher)CoreMatchers.is((Object)1));
        emailVerified = false;
        List usersEmailNotVerified = this.realm.admin().users().search(null, null, null, null, Boolean.valueOf(emailVerified), null, null, null, Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)usersEmailNotVerified, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)((UserRepresentation)usersEmailNotVerified.get(0)).getUsername(), (Matcher)CoreMatchers.is((Object)"user2"));
        this.createUser(UserConfigBuilder.create().username("testuser3").password("password").name("testuser3", "testuser3").email("testuser3@example.com").enabled(true).build());
        usersEmailVerified = this.realm.admin().users().search("user", null, null, null, Boolean.valueOf(emailVerified), null, null, null);
        MatcherAssert.assertThat((Object)usersEmailVerified, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)usersEmailVerified.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((UserRepresentation)usersEmailVerified.get(0)).getUsername(), (Matcher)CoreMatchers.is((Object)"user2"));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("user", null, null, null, Boolean.valueOf(emailVerified), null, null, null), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testCountUsersByEnabledStatus() {
        this.createUser(UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").emailVerified(true).enabled(true).build());
        this.createUser(UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").enabled(false).build());
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("user", null, null, null, null, null, Boolean.valueOf(true), null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("user", null, null, null, null, null, Boolean.valueOf(false), null), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testCountUsersByFederatedIdentity() {
        this.createUser(UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").emailVerified(true).enabled(true).build());
        this.createUser(UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").enabled(false).build());
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName(realmName);
            session.getContext().setRealm(realm);
            UserProvider users = session.users();
            users.addFederatedIdentity(realm, users.getUserById(realm, users.getUserByUsername(realm, "user1").getId()), new FederatedIdentityModel("user1Broker", "user1BrokerId", "user1BrokerUsername"));
            users.addFederatedIdentity(realm, users.getUserById(realm, users.getUserByUsername(realm, "user2").getId()), new FederatedIdentityModel("user2Broker", "user2BrokerId", "user2BrokerUsername"));
        });
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "user", null, null, null, null, null, "user1Broker", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "user", null, null, null, null, null, "user1Broker", "user1BrokerId", null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "user", null, null, null, null, null, "user1Broker", "invalidId", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "user", null, null, null, null, Boolean.valueOf(false), "user2Broker", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "user", null, null, null, null, Boolean.valueOf(false), "user2Broker", "user1BrokerId", null), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void countUsersByEmailVerifiedStatus() {
        this.createUser(UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").emailVerified(true).enabled(true).build());
        this.createUser(UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").enabled(true).build());
        this.createUser(UserConfigBuilder.create().username("user3").password("password").name("user3FirstName", "user3LastName").email("user3@example.com").emailVerified(true).enabled(true).build());
        boolean emailVerified = true;
        MatcherAssert.assertThat((Object)this.realm.admin().users().countEmailVerified(Boolean.valueOf(emailVerified)), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, null, Boolean.valueOf(emailVerified), null), (Matcher)CoreMatchers.is((Object)2));
        emailVerified = false;
        MatcherAssert.assertThat((Object)this.realm.admin().users().countEmailVerified(Boolean.valueOf(emailVerified)), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, null, Boolean.valueOf(emailVerified), null), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void countUsersWithViewPermission() {
        this.createUser("user1", "user1FirstName", "user1LastName", "user1@example.com");
        this.createUser("user2", "user2FirstName", "user2LastName", "user2@example.com");
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void countUsersBySearchWithViewPermission() {
        this.createUser(UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").emailVerified(true).enabled(true).build());
        this.createUser(UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").enabled(true).build());
        this.createUser(UserConfigBuilder.create().username("user3").password("password").name("user3FirstName", "user3LastName").email("user3@example.com").emailVerified(true).enabled(true).build());
        this.assertSearchMatchesCount(this.realm.admin(), "user", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "user*", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "er", 0);
        this.assertSearchMatchesCount(this.realm.admin(), "", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "*", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "user2FirstName", 1);
        this.assertSearchMatchesCount(this.realm.admin(), "user2First", 1);
        this.assertSearchMatchesCount(this.realm.admin(), "user2First*", 1);
        this.assertSearchMatchesCount(this.realm.admin(), "user1@example", 1);
        this.assertSearchMatchesCount(this.realm.admin(), "user1@example*", 1);
        this.assertSearchMatchesCount(this.realm.admin(), null, 3);
        this.assertSearchMatchesCount(this.realm.admin(), "*user*", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "**", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "*foobar*", 0);
        this.assertSearchMatchesCount(this.realm.admin(), "*LastName*", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "*FirstName*", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "*@example.com*", 3);
        this.assertSearchMatchesCount(this.realm.admin(), "\"user1\"", 1);
        this.assertSearchMatchesCount(this.realm.admin(), "\"1\"", 0);
        this.assertSearchMatchesCount(this.realm.admin(), "\"\"", 0);
        this.assertSearchMatchesCount(this.realm.admin(), "\"user1FirstName\"", 1);
        this.assertSearchMatchesCount(this.realm.admin(), "\"user1LastName\"", 1);
        this.assertSearchMatchesCount(this.realm.admin(), "\"user1@example.com\"", 1);
    }

    @Test
    public void countUsersByFiltersWithViewPermission() {
        this.createUser("user1", "user1FirstName", "user1LastName", "user1@example.com");
        this.createUser("user2", "user2FirstName", "user2LastName", "user2@example.com");
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.realm.admin().users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)2));
    }

    private void assertSearchMatchesCount(RealmResource realmResource, String search, Integer expectedCount) {
        Integer count = realmResource.users().count(search);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)expectedCount));
        MatcherAssert.assertThat((Object)realmResource.users().search(search, null, null), (Matcher)Matchers.hasSize((int)count));
    }

    private void assertCaseInsensitiveSearch() {
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("user"), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("User"), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("USER"), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Use"), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("user", Boolean.valueOf(true)), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("User", Boolean.valueOf(true)), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("USER", Boolean.valueOf(true)), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.realm.admin().users().search("Use", Boolean.valueOf(true)), (Matcher)Matchers.hasSize((int)0));
    }

    private void createUser(UserRepresentation user) {
        this.realm.admin().users().create(user).close();
    }

    private void createUser(String username, String firstName, String lastName, String email) {
        this.createUser(UserConfigBuilder.create().username(username).password("password").name(firstName, lastName).email(email).enabled(true).build());
    }
}

