/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

public abstract class AbstractAuthenticationTest {
    static final String REQUIRED = "REQUIRED";
    static final String CONDITIONAL = "CONDITIONAL";
    static final String DISABLED = "DISABLED";
    static final String ALTERNATIVE = "ALTERNATIVE";
    @InjectRealm
    ManagedRealm managedRealm;
    RealmResource realmResource;
    AuthenticationManagementResource authMgmtResource;
    protected String testRealmId;
    @InjectAdminEvents
    public AdminEvents adminEvents;

    @BeforeEach
    public void before() {
        this.realmResource = this.managedRealm.admin();
        this.authMgmtResource = this.realmResource.flows();
        this.testRealmId = this.managedRealm.getId();
    }

    public static AuthenticationExecutionInfoRepresentation findExecutionByProvider(String provider, List<AuthenticationExecutionInfoRepresentation> executions) {
        for (AuthenticationExecutionInfoRepresentation exec : executions) {
            if (!provider.equals(exec.getProviderId())) continue;
            return exec;
        }
        return null;
    }

    public static AuthenticationExecutionInfoRepresentation findPreviousExecution(AuthenticationExecutionInfoRepresentation execution, List<AuthenticationExecutionInfoRepresentation> executions) {
        for (AuthenticationExecutionInfoRepresentation exec : executions) {
            if (exec.getLevel() != execution.getLevel() || exec.getIndex() != execution.getIndex() - 1) continue;
            return exec;
        }
        return null;
    }

    public static AuthenticationFlowRepresentation findFlowByAlias(String alias, List<AuthenticationFlowRepresentation> flows) {
        for (AuthenticationFlowRepresentation flow : flows) {
            if (!alias.equals(flow.getAlias())) continue;
            return flow;
        }
        return null;
    }

    void compareExecution(AuthenticationExecutionInfoRepresentation expected, AuthenticationExecutionInfoRepresentation actual) {
        Assertions.assertEquals((Object)expected.getRequirement(), (Object)actual.getRequirement(), (String)("Execution requirement - " + actual.getProviderId()));
        Assertions.assertEquals((Object)expected.getDisplayName(), (Object)actual.getDisplayName(), (String)("Execution display name - " + actual.getProviderId()));
        Assertions.assertEquals((Object)expected.getConfigurable(), (Object)actual.getConfigurable(), (String)("Execution configurable - " + actual.getProviderId()));
        Assertions.assertEquals((Object)expected.getProviderId(), (Object)actual.getProviderId(), (String)("Execution provider id - " + actual.getProviderId()));
        Assertions.assertEquals((int)expected.getLevel(), (int)actual.getLevel(), (String)("Execution level - " + actual.getProviderId()));
        Assertions.assertEquals((int)expected.getIndex(), (int)actual.getIndex(), (String)("Execution index - " + actual.getProviderId()));
        Assertions.assertEquals((int)expected.getPriority(), (int)actual.getPriority(), (String)("Execution priority - " + actual.getProviderId()));
        Assertions.assertEquals((Object)expected.getAuthenticationFlow(), (Object)actual.getAuthenticationFlow(), (String)("Execution authentication flow - " + actual.getProviderId()));
        Assertions.assertEquals((Object)expected.getRequirementChoices(), (Object)actual.getRequirementChoices(), (String)("Execution requirement choices - " + actual.getProviderId()));
    }

    void compareExecution(AuthenticationExecutionExportRepresentation expected, AuthenticationExecutionExportRepresentation actual) {
        Assertions.assertEquals((Object)expected.getFlowAlias(), (Object)actual.getFlowAlias(), (String)("Execution flowAlias - " + actual.getFlowAlias()));
        Assertions.assertEquals((Object)expected.getAuthenticator(), (Object)actual.getAuthenticator(), (String)("Execution authenticator - " + actual.getAuthenticator()));
        Assertions.assertEquals((Object)expected.isUserSetupAllowed(), (Object)actual.isUserSetupAllowed(), (String)("Execution userSetupAllowed - " + actual.getAuthenticator()));
        Assertions.assertEquals((Object)expected.isAuthenticatorFlow(), (Object)actual.isAuthenticatorFlow(), (String)("Execution authenticatorFlow - " + actual.getAuthenticator()));
        Assertions.assertEquals((Object)expected.getAuthenticatorConfig(), (Object)actual.getAuthenticatorConfig(), (String)("Execution authenticatorConfig - " + actual.getAuthenticatorConfig()));
        Assertions.assertEquals((Integer)expected.getPriority(), (Integer)actual.getPriority(), (String)("Execution priority - " + actual.getAuthenticator()));
        Assertions.assertEquals((Object)expected.getRequirement(), (Object)actual.getRequirement(), (String)("Execution requirement - " + actual.getAuthenticator()));
    }

    void compareExecutions(List<AuthenticationExecutionExportRepresentation> expected, List<AuthenticationExecutionExportRepresentation> actual) {
        Assertions.assertNotNull(actual, (String)"Executions should not be null");
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Size");
        for (int i = 0; i < expected.size(); ++i) {
            this.compareExecution(expected.get(i), actual.get(i));
        }
    }

    void compareFlows(AuthenticationFlowRepresentation expected, AuthenticationFlowRepresentation actual) {
        Assertions.assertEquals((Object)expected.getAlias(), (Object)actual.getAlias(), (String)"Flow alias");
        Assertions.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription(), (String)"Flow description");
        Assertions.assertEquals((Object)expected.getProviderId(), (Object)actual.getProviderId(), (String)"Flow providerId");
        Assertions.assertEquals((Object)expected.isTopLevel(), (Object)actual.isTopLevel(), (String)"Flow top level");
        Assertions.assertEquals((Object)expected.isBuiltIn(), (Object)actual.isBuiltIn(), (String)"Flow built-in");
        List expectedExecs = expected.getAuthenticationExecutions();
        List actualExecs = actual.getAuthenticationExecutions();
        if (expectedExecs == null) {
            Assertions.assertTrue((actualExecs == null || actualExecs.size() == 0 ? 1 : 0) != 0, (String)"Executions should be null or empty");
        } else {
            this.compareExecutions(expectedExecs, actualExecs);
        }
    }

    AuthenticationFlowRepresentation newFlow(String alias, String description, String providerId, boolean topLevel, boolean builtIn) {
        AuthenticationFlowRepresentation flow = new AuthenticationFlowRepresentation();
        flow.setAlias(alias);
        flow.setDescription(description);
        flow.setProviderId(providerId);
        flow.setTopLevel(topLevel);
        flow.setBuiltIn(builtIn);
        return flow;
    }

    AuthenticationExecutionInfoRepresentation newExecInfo(String displayName, String providerId, Boolean configurable, int level, int index, String requirement, Boolean authFlow, String[] choices, int priority) {
        AuthenticationExecutionInfoRepresentation execution = new AuthenticationExecutionInfoRepresentation();
        execution.setRequirement(requirement);
        execution.setDisplayName(displayName);
        execution.setConfigurable(configurable);
        execution.setProviderId(providerId);
        execution.setLevel(level);
        execution.setIndex(index);
        execution.setAuthenticationFlow(authFlow);
        execution.setPriority(priority);
        if (choices != null) {
            execution.setRequirementChoices(Arrays.asList(choices));
        }
        return execution;
    }

    void addExecInfo(List<AuthenticationExecutionInfoRepresentation> target, String displayName, String providerId, Boolean configurable, int level, int index, String requirement, Boolean authFlow, String[] choices, int priority) {
        AuthenticationExecutionInfoRepresentation exec = this.newExecInfo(displayName, providerId, configurable, level, index, requirement, authFlow, choices, priority);
        target.add(exec);
    }

    AuthenticatorConfigRepresentation newConfig(String alias, String[] keyvalues) {
        AuthenticatorConfigRepresentation config = new AuthenticatorConfigRepresentation();
        config.setAlias(alias);
        if (keyvalues == null) {
            throw new IllegalArgumentException("keyvalues == null");
        }
        if (keyvalues.length % 2 != 0) {
            throw new IllegalArgumentException("keyvalues should have even number of elements");
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (int i = 0; i < keyvalues.length; i += 2) {
            params.put(keyvalues[i], keyvalues[i + 1]);
        }
        config.setConfig(params);
        return config;
    }

    String createFlow(AuthenticationFlowRepresentation flowRep) {
        return this.createFlow(flowRep, true);
    }

    String createFlow(AuthenticationFlowRepresentation flowRep, boolean autoDelete) {
        Response response = this.authMgmtResource.createFlow(flowRep);
        Assertions.assertEquals((int)201, (int)response.getStatus());
        response.close();
        String flowId = ApiUtil.getCreatedId((Response)response);
        if (autoDelete) {
            this.managedRealm.cleanup().add(r -> r.flows().deleteFlow(flowId));
        }
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.CREATE).resourcePath(new String[]{AdminEventPaths.authFlowPath((String)flowId)}).representation((Object)flowRep).resourceType(ResourceType.AUTH_FLOW);
        return flowId;
    }
}

