/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigInfoRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class AuthenticatorConfigTest
extends AbstractAuthenticationTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    private String flowId;
    private String executionId;
    private String executionId2;

    @BeforeEach
    public void beforeConfigTest() {
        AuthenticationFlowRepresentation flowRep = this.newFlow("firstBrokerLogin2", "firstBrokerLogin2", "basic-flow", true, false);
        this.flowId = this.createFlow(flowRep);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("provider", "idp-create-user-if-unique");
        this.authMgmtResource.addExecution("firstBrokerLogin2", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionPath((String)"firstBrokerLogin2"), params, (ResourceType)ResourceType.AUTH_EXECUTION);
        params.put("provider", "idp-detect-existing-broker-user");
        this.authMgmtResource.addExecution("firstBrokerLogin2", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionPath((String)"firstBrokerLogin2"), params, (ResourceType)ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions("firstBrokerLogin2");
        AuthenticationExecutionInfoRepresentation exec = AuthenticatorConfigTest.findExecutionByProvider("idp-create-user-if-unique", executionReps);
        Assertions.assertNotNull((Object)exec);
        this.executionId = exec.getId();
        exec = AuthenticatorConfigTest.findExecutionByProvider("idp-detect-existing-broker-user", executionReps);
        Assertions.assertNotNull((Object)exec);
        this.executionId2 = exec.getId();
    }

    @Test
    public void testCreateConfigWithReservedChar() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("f!oo", "require.password.update.after.registration", "true");
        Response resp = this.authMgmtResource.newExecutionConfig(this.executionId, cfg);
        Assertions.assertEquals((int)400, (int)resp.getStatus());
    }

    @Test
    public void testCreateConfig() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        try (Response response = this.authMgmtResource.newExecutionConfig("exec-id-doesnt-exists", cfg);){
            Assertions.assertEquals((int)404, (int)response.getStatus());
        }
        String cfgId = this.createConfig(this.executionId, cfg);
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        this.assertConfig(cfgRep, cfgId, "foo", "require.password.update.after.registration", "true");
        this.authMgmtResource.removeAuthenticatorConfig(cfgId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authExecutionConfigPath((String)cfgId), (ResourceType)ResourceType.AUTHENTICATOR_CONFIG);
    }

    @Test
    public void testUpdateConfigWithBadChar() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        String cfgId = this.createConfig(this.executionId, cfg);
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        cfgRep.setAlias("Bad@Char");
        Assertions.assertThrows(BadRequestException.class, () -> this.authMgmtResource.updateAuthenticatorConfig(cfgRep.getId(), cfgRep));
    }

    @Test
    public void testUpdateConfig() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        String cfgId = this.createConfig(this.executionId, cfg);
        AuthenticatorConfigRepresentation cfgRepNonExistent = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        NotFoundException nfe = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> this.authMgmtResource.updateAuthenticatorConfig("not-existent", cfgRepNonExistent));
        Assertions.assertEquals((int)404, (int)nfe.getResponse().getStatus());
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        this.assertConfig(cfgRep, cfgId, "foo", "require.password.update.after.registration", "true");
        cfgRep.setAlias("foo2");
        cfgRep.getConfig().put("configKey2", "configValue2");
        this.authMgmtResource.updateAuthenticatorConfig(cfgRep.getId(), cfgRep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authExecutionConfigPath((String)cfgId), (Object)cfgRep, (ResourceType)ResourceType.AUTHENTICATOR_CONFIG);
        cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgRep.getId());
        this.assertConfig(cfgRep, cfgId, "foo2", "require.password.update.after.registration", "true", "configKey2", "configValue2");
    }

    @Test
    public void testRemoveConfig() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        String cfgId = this.createConfig(this.executionId, cfg);
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        AuthenticationExecutionInfoRepresentation execution = AuthenticatorConfigTest.findExecutionByProvider("idp-create-user-if-unique", this.authMgmtResource.getExecutions("firstBrokerLogin2"));
        Assertions.assertEquals((Object)cfgRep.getId(), (Object)execution.getAuthenticationConfig());
        NotFoundException nfe = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> this.authMgmtResource.removeAuthenticatorConfig("not-existent"));
        Assertions.assertEquals((int)404, (int)nfe.getResponse().getStatus());
        this.authMgmtResource.removeAuthenticatorConfig(cfgId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authExecutionConfigPath((String)cfgId), (ResourceType)ResourceType.AUTHENTICATOR_CONFIG);
        nfe = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> this.authMgmtResource.getAuthenticatorConfig(cfgRep.getId()));
        Assertions.assertEquals((int)404, (int)nfe.getResponse().getStatus());
        execution = AuthenticatorConfigTest.findExecutionByProvider("idp-create-user-if-unique", this.authMgmtResource.getExecutions("firstBrokerLogin2"));
        Assertions.assertNull((Object)execution.getAuthenticationConfig());
    }

    @Test
    public void testNullsafetyIterationOverProperties() {
        String providerId = "auth-cookie";
        String providerName = "Cookie";
        AuthenticatorConfigInfoRepresentation description = this.authMgmtResource.getAuthenticatorConfigDescription(providerId);
        Assertions.assertEquals((Object)providerName, (Object)description.getName());
        Assertions.assertTrue((boolean)description.getProperties().isEmpty());
    }

    @Test
    public void testDuplicateAuthenticatorConfigAlias() {
        AuthenticatorConfigRepresentation config1 = new AuthenticatorConfigRepresentation();
        config1.setAlias("test-config-1");
        config1.setConfig(Map.of("key", "value"));
        String config1Id = this.createConfig(this.executionId, config1);
        try (Response response = this.authMgmtResource.newExecutionConfig(this.executionId2, config1);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
        }
        AuthenticatorConfigRepresentation config2 = new AuthenticatorConfigRepresentation();
        config2.setAlias("test-config-2");
        config2.setConfig(Map.of("key", "value"));
        String config2Id = this.createConfig(this.executionId, config2);
        AuthenticatorConfigRepresentation config3 = new AuthenticatorConfigRepresentation();
        config3.setAlias("test-config-1-modified");
        config3.setConfig(Map.of("key", "value"));
        String tmpConfig3Id = this.createConfig(this.executionId, config3);
        NotFoundException nfe = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> this.authMgmtResource.getAuthenticatorConfig(config1Id));
        Assertions.assertEquals((int)404, (int)nfe.getResponse().getStatus());
        String config3Id = this.createConfig(this.executionId, config3);
        nfe = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> this.authMgmtResource.getAuthenticatorConfig(tmpConfig3Id));
        Assertions.assertEquals((int)404, (int)nfe.getResponse().getStatus());
        this.authMgmtResource.removeExecution(this.executionId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authExecutionPath((String)this.executionId), (ResourceType)ResourceType.AUTH_EXECUTION);
        nfe = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> this.authMgmtResource.getAuthenticatorConfig(config3Id));
        Assertions.assertEquals((int)404, (int)nfe.getResponse().getStatus());
    }

    @Test
    public void testMissingConfig() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        String cfgId = this.createConfig(this.executionId, cfg);
        String realmId = this.testRealmId;
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        Assertions.assertNotNull((Object)cfgRep);
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm(realmId);
            AuthenticatorConfigModel config = realm.getAuthenticatorConfigById(cfgId);
            realm.removeAuthenticatorConfig(config);
        });
        AuthenticationFlowRepresentation flow = this.authMgmtResource.getFlow(this.flowId);
        AuthenticationExecutionExportRepresentation execExport = flow.getAuthenticationExecutions().stream().filter(ae -> "idp-create-user-if-unique".equals(ae.getAuthenticator())).findAny().orElse(null);
        Assertions.assertNotNull((Object)execExport);
        Assertions.assertNull((Object)execExport.getAuthenticatorConfig());
        AuthenticationExecutionInfoRepresentation execInfo = AuthenticatorConfigTest.findExecutionByProvider("idp-create-user-if-unique", this.authMgmtResource.getExecutions("firstBrokerLogin2"));
        Assertions.assertNull((Object)execInfo.getAuthenticationConfig());
    }

    private String createConfig(String executionId, AuthenticatorConfigRepresentation cfg) {
        try (Response resp = this.authMgmtResource.newExecutionConfig(executionId, cfg);){
            Assertions.assertEquals((int)201, (int)resp.getStatus());
            String cfgId = ApiUtil.getCreatedId((Response)resp);
            Assertions.assertNotNull((Object)cfgId);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionConfigPath((String)executionId), (Object)cfg, (ResourceType)ResourceType.AUTHENTICATOR_CONFIG);
            String string = cfgId;
            return string;
        }
    }

    private AuthenticatorConfigRepresentation newConfig(String alias, String cfgKey, String cfgValue) {
        AuthenticatorConfigRepresentation cfg = new AuthenticatorConfigRepresentation();
        cfg.setAlias(alias);
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        cfgMap.put(cfgKey, cfgValue);
        cfg.setConfig(cfgMap);
        return cfg;
    }

    private void assertConfig(AuthenticatorConfigRepresentation cfgRep, String id, String alias, String ... fields) {
        Assertions.assertEquals((Object)id, (Object)cfgRep.getId());
        Assertions.assertEquals((Object)alias, (Object)cfgRep.getAlias());
        Assert.assertMap((Map)cfgRep.getConfig(), (String[])fields);
    }
}

