/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class ExecutionTest
extends AbstractAuthenticationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateAuthenticatorConfig() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "new-browser-flow");
        Response response = this.authMgmtResource.copy("browser", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), params, (ResourceType)ResourceType.AUTH_FLOW);
        try {
            Assertions.assertEquals((int)201, (int)response.getStatus(), (String)"Copy flow");
        }
        finally {
            response.close();
        }
        params.put("provider", "auth-conditional-otp-form");
        this.authMgmtResource.addExecution("new-browser-flow", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionPath((String)"new-browser-flow"), params, (ResourceType)ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions("new-browser-flow");
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider("auth-conditional-otp-form", executionReps);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("defaultOtpOutcome", "skip");
        config.put("otpControlAttribute", "test");
        config.put("forceOtpForHeaderPattern", "");
        config.put("forceOtpRole", "");
        config.put("noOtpRequiredForHeaderPattern", "");
        config.put("skipOtpRole", "");
        AuthenticatorConfigRepresentation authConfigRep = new AuthenticatorConfigRepresentation();
        authConfigRep.setAlias("conditional-otp-form-config-alias");
        authConfigRep.setConfig(config);
        response = this.authMgmtResource.newExecutionConfig(exec.getId(), authConfigRep);
        try {
            authConfigRep.setId(ApiUtil.getCreatedId((Response)response));
        }
        finally {
            response.close();
        }
        config.put("otpControlAttribute", "test-updated");
        authConfigRep.setConfig(config);
        this.authMgmtResource.updateAuthenticatorConfig(authConfigRep.getId(), authConfigRep);
        AuthenticatorConfigRepresentation updated = this.authMgmtResource.getAuthenticatorConfig(authConfigRep.getId());
        MatcherAssert.assertThat(updated.getConfig().values(), (Matcher)Matchers.hasItems((Object[])new String[]{"test-updated", "skip"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveExecution() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("provider", "idp-review-profile");
        try {
            this.authMgmtResource.addExecution("browser", params);
            Assertions.fail((String)"add execution to built-in flow should fail");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        try {
            this.authMgmtResource.addExecution("not-existent", params);
            Assertions.fail((String)"add execution to not-existent flow should fail");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        params.put("newName", "Copy-of-browser");
        Response response = this.authMgmtResource.copy("browser", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), params, (ResourceType)ResourceType.AUTH_FLOW);
        try {
            Assertions.assertEquals((int)201, (int)response.getStatus(), (String)"Copy flow");
        }
        finally {
            response.close();
        }
        params.put("provider", "test-execution");
        try {
            this.authMgmtResource.addExecution("CopyOfBrowser", params);
            Assertions.fail((String)"add execution with inexistent provider should fail");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        params.put("provider", "idp-review-profile");
        this.authMgmtResource.addExecution("Copy-of-browser", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionPath((String)"Copy-of-browser"), params, (ResourceType)ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions("Copy-of-browser");
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider("idp-review-profile", executionReps);
        Assertions.assertNotNull((Object)exec, (String)"idp-review-profile added");
        AuthenticationExecutionInfoRepresentation authCookieExec = ExecutionTest.findExecutionByProvider("auth-cookie", executionReps);
        AuthenticationExecutionInfoRepresentation previousExecution = ExecutionTest.findPreviousExecution(exec, executionReps);
        Assertions.assertNotNull((Object)previousExecution);
        this.compareExecution(this.newExecInfo("Review Profile", "idp-review-profile", true, 0, 5, "DISABLED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, previousExecution.getPriority() + 1), exec);
        this.authMgmtResource.removeExecution(exec.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authExecutionPath((String)exec.getId()), (ResourceType)ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("Copy-of-browser");
        exec = ExecutionTest.findExecutionByProvider("idp-review-profile", executionReps);
        Assertions.assertNull((Object)exec, (String)"idp-review-profile removed");
        this.authMgmtResource.removeExecution(authCookieExec.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authExecutionPath((String)authCookieExec.getId()), (ResourceType)ResourceType.AUTH_EXECUTION);
        AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
        rep.setPriority(Integer.valueOf(10));
        rep.setAuthenticator("auth-cookie");
        rep.setRequirement("CONDITIONAL");
        response = this.authMgmtResource.addExecution(rep);
        try {
            Assertions.assertEquals((int)400, (int)response.getStatus(), (String)"added execution missing parent flow");
        }
        finally {
            response.close();
        }
        rep.setParentFlow("not-existent-id");
        response = this.authMgmtResource.addExecution(rep);
        try {
            Assertions.assertEquals((int)400, (int)response.getStatus(), (String)"added execution missing parent flow");
        }
        finally {
            response.close();
        }
        AuthenticationFlowRepresentation browserFlow = ExecutionTest.findFlowByAlias("browser", this.authMgmtResource.getFlows());
        rep.setParentFlow(browserFlow.getId());
        response = this.authMgmtResource.addExecution(rep);
        try {
            Assertions.assertEquals((int)400, (int)response.getStatus(), (String)"added execution to builtin flow");
        }
        finally {
            response.close();
        }
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation flow = ExecutionTest.findFlowByAlias("Copy-of-browser", flows);
        rep.setParentFlow(flow.getId());
        String createdId = ApiUtil.getCreatedId((Response)this.authMgmtResource.addExecution(rep));
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.CREATE).resourcePath(new String[]{AdminEventPaths.authMgmtBasePath(), "executions", createdId}).representation((Object)rep).resourceType(ResourceType.AUTH_EXECUTION);
        List executions = this.authMgmtResource.getExecutions("Copy-of-browser");
        exec = ExecutionTest.findExecutionByProvider("auth-cookie", executions);
        Assertions.assertNotNull((Object)exec, (String)"auth-cookie added");
        this.compareExecution(this.newExecInfo("Cookie", "auth-cookie", false, 0, 0, "CONDITIONAL", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 10), exec);
    }

    @Test
    public void testUpdateExecution() {
        List executionReps = this.authMgmtResource.getExecutions("browser");
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider("auth-cookie", executionReps);
        Assertions.assertEquals((Object)"ALTERNATIVE", (Object)exec.getRequirement(), (String)"auth-cookie set to ALTERNATIVE");
        Assertions.assertEquals((int)exec.getIndex(), (int)0, (String)"auth-cookie is first in the flow");
        exec.setRequirement("DISABLED");
        exec.setPriority(Integer.MAX_VALUE);
        this.authMgmtResource.updateExecutions("browser", exec);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"browser"), (Object)exec, (ResourceType)ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("browser");
        AuthenticationExecutionInfoRepresentation exec2 = ExecutionTest.findExecutionByProvider("auth-cookie", executionReps);
        long expectedIndex = executionReps.stream().filter(r -> r.getLevel() == exec2.getLevel()).count() - 1L;
        exec.setIndex(Math.toIntExact(expectedIndex));
        this.compareExecution(exec, exec2);
    }

    @Test
    public void testClientFlowExecutions() {
        AuthenticationFlowRepresentation clientFlow = this.newFlow("new-client-flow", "desc", "client-flow", true, false);
        this.createFlow(clientFlow);
        HashMap<String, String> executionData = new HashMap<String, String>();
        executionData.put("provider", "client-secret");
        this.authMgmtResource.addExecution("new-client-flow", executionData);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionPath((String)"new-client-flow"), executionData, (ResourceType)ResourceType.AUTH_EXECUTION);
        try {
            this.authMgmtResource.getExecutions("not-existent");
            Assertions.fail((String)"Not expected to find executions");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        List executions = this.authMgmtResource.getExecutions("new-client-flow");
        AuthenticationExecutionInfoRepresentation executionRep = ExecutionTest.findExecutionByProvider("client-secret", executions);
        Assertions.assertNotNull((Object)executionRep);
        try {
            this.authMgmtResource.updateExecutions("not-existent", executionRep);
            Assertions.fail((String)"Not expected to update execution with not-existent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        AuthenticationExecutionInfoRepresentation executionRep2 = new AuthenticationExecutionInfoRepresentation();
        executionRep2.setId("not-existent");
        try {
            this.authMgmtResource.updateExecutions("new-client-flow", executionRep2);
            Assertions.fail((String)"Not expected to update not-existent execution");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        executionRep.setRequirement("ALTERNATIVE");
        this.authMgmtResource.updateExecutions("new-client-flow", executionRep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"new-client-flow"), (Object)executionRep, (ResourceType)ResourceType.AUTH_EXECUTION);
        executionRep = ExecutionTest.findExecutionByProvider("client-secret", this.authMgmtResource.getExecutions("new-client-flow"));
        Assertions.assertEquals((Object)"ALTERNATIVE", (Object)executionRep.getRequirement());
        try {
            this.authMgmtResource.removeExecution("not-existent");
            Assertions.fail((String)"Didn't expect to find execution");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.removeExecution(executionRep.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authExecutionPath((String)executionRep.getId()), (ResourceType)ResourceType.AUTH_EXECUTION);
    }

    @Test
    public void testRequirementsInExecution() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String newBrowserFlow = "new-exec-flow";
        params.put("newName", newBrowserFlow);
        try (Response response = this.authMgmtResource.copy("browser", params);){
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), params, (ResourceType)ResourceType.AUTH_FLOW);
            Assertions.assertEquals((int)201, (int)response.getStatus(), (String)"Copy flow");
        }
        this.addExecutionCheckReq(newBrowserFlow, "auth-username-form", params, "REQUIRED");
        this.addExecutionCheckReq(newBrowserFlow, "webauthn-authenticator", params, "DISABLED");
        AuthenticationFlowRepresentation rep = ExecutionTest.findFlowByAlias(newBrowserFlow, this.authMgmtResource.getFlows());
        Assertions.assertNotNull((Object)rep);
        this.authMgmtResource.deleteFlow(rep.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authFlowPath((String)rep.getId()), (ResourceType)ResourceType.AUTH_FLOW);
    }

    private void addExecutionCheckReq(String flow, String providerID, HashMap<String, Object> params, String expectedRequirement) {
        params.put("provider", providerID);
        this.authMgmtResource.addExecution(flow, params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionPath((String)flow), params, (ResourceType)ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions(flow);
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider(providerID, executionReps);
        Assertions.assertNotNull((Object)exec);
        Assertions.assertEquals((Object)expectedRequirement, (Object)exec.getRequirement());
        this.authMgmtResource.removeExecution(exec.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authExecutionPath((String)exec.getId()), (ResourceType)ResourceType.AUTH_EXECUTION);
    }
}

