/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.CreatedResponseUtil;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class FlowTest
extends AbstractAuthenticationTest {
    @Test
    public void testRemoveSubflows() {
        this.createFlow(this.newFlow("Foo", "Foo flow", "generic", true, false), false);
        this.addFlowToParent("Foo", "child");
        this.addFlowToParent("child", "grandchild");
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation found = FlowTest.findFlowByAlias("Foo", flows);
        this.authMgmtResource.deleteFlow(found.getId());
        this.adminEvents.skipAll();
        this.createFlow(this.newFlow("Foo", "Foo flow", "generic", true, false), false);
        this.addFlowToParent("Foo", "child");
        this.addFlowToParent("child", "grandchild");
        this.authMgmtResource.deleteFlow(FlowTest.findFlowByAlias("Foo", this.authMgmtResource.getFlows()).getId());
    }

    @Test
    public void testRemoveExecutionSubflow() {
        this.createFlow(this.newFlow("Foo", "Foo flow", "generic", true, false));
        this.addFlowToParent("Foo", "child");
        this.addFlowToParent("child", "grandchild");
        List fooExecutions = this.authMgmtResource.getExecutions("Foo");
        AuthenticationExecutionInfoRepresentation childExececution = fooExecutions.stream().filter(r -> "child".equals(r.getDisplayName()) && r.getLevel() == 0).findAny().orElse(null);
        Assert.assertNotNull((Object)childExececution);
        this.authMgmtResource.removeExecution(childExececution.getId());
        this.adminEvents.skip();
        this.addFlowToParent("Foo", "child");
        this.addFlowToParent("child", "grandchild");
    }

    private void addFlowToParent(String parentAlias, String childAlias) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("alias", childAlias);
        data.put("type", "generic");
        data.put("description", childAlias + " flow");
        this.authMgmtResource.addExecutionFlow(parentAlias, data);
    }

    @Test
    public void testAddFlowWithRestrictedCharInAlias() {
        Response resp = this.authMgmtResource.createFlow(this.newFlow("fo]o", "Browser flow", "basic-flow", true, false));
        Assertions.assertEquals((int)400, (int)resp.getStatus());
        try {
            CreatedResponseUtil.getCreatedId((Response)resp);
            Assertions.fail((String)"Not expected getCreatedId to success");
        }
        catch (WebApplicationException wae) {
            MatcherAssert.assertThat((Object)wae.getMessage(), (Matcher)Matchers.endsWith((String)"Error: Character ']' not allowed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveFlow() {
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation builtInFlow = flows.stream().filter(AuthenticationFlowRepresentation::isBuiltIn).findAny().orElse(null);
        Assertions.assertNotNull((Object)builtInFlow, (String)"No built in flow in the realm");
        try {
            this.authMgmtResource.deleteFlow(builtInFlow.getId());
            Assertions.fail((String)"deleteFlow should fail for built in flow");
        }
        catch (BadRequestException e) {
            OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)e.getResponse().readEntity(OAuth2ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Can't delete built in flow", (Object)error.getError());
        }
        try (Response response = this.authMgmtResource.createFlow(this.newFlow("browser", "Browser flow", "basic-flow", true, false));){
            Assertions.assertEquals((int)409, (int)response.getStatus(), (String)"createFlow using the alias of existing flow should fail");
        }
        response = this.authMgmtResource.createFlow(this.newFlow(null, "Browser flow", "basic-flow", true, false));
        try {
            Assertions.assertEquals((int)409, (int)response.getStatus(), (String)"createFlow using the alias of existing flow should fail");
        }
        finally {
            response.close();
        }
        AuthenticationFlowRepresentation newFlow = this.newFlow("browser-2", "Browser flow", "basic-flow", true, false);
        this.createFlow(newFlow, false);
        flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation found = FlowTest.findFlowByAlias("browser-2", flows);
        Assertions.assertNotNull((Object)found, (String)"created flow visible in parent");
        this.compareFlows(newFlow, found);
        try {
            this.authMgmtResource.getFlow("id-123-notExistent");
            Assertions.fail((String)"Not expected to find unexistent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        AuthenticationFlowRepresentation found2 = this.authMgmtResource.getFlow(found.getId());
        Assertions.assertNotNull((Object)found2, (String)"created flow visible directly");
        this.compareFlows(newFlow, found2);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("alias", "SomeFlow");
        data.put("type", "basic-flow");
        data.put("description", "Test flow");
        data.put("provider", "registration-page-form");
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("alias", "SomeFlow2");
        data2.put("type", "form-flow");
        data2.put("description", "Test flow 2");
        data2.put("provider", "registration-page-form");
        try {
            this.authMgmtResource.addExecutionFlow("inexistent-parent-flow-alias", data);
            Assertions.fail((String)"addExecutionFlow for inexistent parent should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            data.put("alias", "browser");
            this.authMgmtResource.addExecutionFlow("browser-2", data);
            Assertions.fail((String)"addExecutionFlow should have failed as browser flow already exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        data.put("alias", "SomeFlow");
        this.authMgmtResource.addExecutionFlow("browser-2", data);
        this.authMgmtResource.addExecutionFlow("browser-2", data2);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"browser-2"), data, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"browser-2"), data2, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        flows = this.authMgmtResource.getFlows();
        found2 = FlowTest.findFlowByAlias("browser-2", flows);
        Assertions.assertNotNull((Object)found2, (String)"created flow visible in parent");
        List execs = found2.getAuthenticationExecutions();
        Assertions.assertNotNull((Object)execs);
        Assertions.assertEquals((int)2, (int)execs.size(), (String)"Size two");
        AuthenticationExecutionExportRepresentation expected = new AuthenticationExecutionExportRepresentation();
        expected.setFlowAlias("SomeFlow");
        expected.setUserSetupAllowed(false);
        expected.setAuthenticatorFlow(true);
        expected.setRequirement("DISABLED");
        expected.setPriority(Integer.valueOf(0));
        this.compareExecution(expected, (AuthenticationExecutionExportRepresentation)execs.get(0));
        expected = new AuthenticationExecutionExportRepresentation();
        expected.setFlowAlias("SomeFlow2");
        expected.setUserSetupAllowed(false);
        expected.setAuthenticator("registration-page-form");
        expected.setAuthenticatorFlow(true);
        expected.setRequirement("DISABLED");
        expected.setPriority(Integer.valueOf(1));
        this.compareExecution(expected, (AuthenticationExecutionExportRepresentation)execs.get(1));
        this.authMgmtResource.deleteFlow(found.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authFlowPath((String)found.getId()), (ResourceType)ResourceType.AUTH_FLOW);
        flows = this.authMgmtResource.getFlows();
        found = FlowTest.findFlowByAlias("browser-2", flows);
        Assertions.assertNull((Object)found, (String)"flow deleted");
        try {
            this.authMgmtResource.deleteFlow("id-123-notExistent");
            Assertions.fail((String)"Not expected to delete flow, which doesn't exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveUsedFlow() {
        String flowAlias = "test";
        String flowId = this.createFlow(this.newFlow(flowAlias, "Test flow", "generic", true, false));
        Runnable assertRemoveFail = () -> {
            try {
                this.authMgmtResource.deleteFlow(flowId);
                Assertions.fail((String)"Not expected to delete flow that is in use.");
            }
            catch (WebApplicationException e) {
                OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)e.getResponse().readEntity(OAuth2ErrorRepresentation.class);
                Assertions.assertEquals((Object)"For more on this error consult the server log.", (Object)error.getErrorDescription());
            }
        };
        RealmRepresentation realm = this.realmResource.toRepresentation();
        BiConsumer<Supplier, Consumer> assertRemoveFailInRealm = (rollbackFlow, updateFlow) -> {
            String rollbackValue = (String)rollbackFlow.get();
            try {
                updateFlow.accept(flowAlias);
                this.realmResource.update(realm);
                assertRemoveFail.run();
            }
            finally {
                updateFlow.accept(rollbackValue);
                this.realmResource.update(realm);
            }
        };
        assertRemoveFailInRealm.accept(() -> ((RealmRepresentation)realm).getBrowserFlow(), arg_0 -> ((RealmRepresentation)realm).setBrowserFlow(arg_0));
        assertRemoveFailInRealm.accept(() -> ((RealmRepresentation)realm).getRegistrationFlow(), arg_0 -> ((RealmRepresentation)realm).setRegistrationFlow(arg_0));
        assertRemoveFailInRealm.accept(() -> ((RealmRepresentation)realm).getClientAuthenticationFlow(), arg_0 -> ((RealmRepresentation)realm).setClientAuthenticationFlow(arg_0));
        assertRemoveFailInRealm.accept(() -> ((RealmRepresentation)realm).getDirectGrantFlow(), arg_0 -> ((RealmRepresentation)realm).setDirectGrantFlow(arg_0));
        assertRemoveFailInRealm.accept(() -> ((RealmRepresentation)realm).getResetCredentialsFlow(), arg_0 -> ((RealmRepresentation)realm).setResetCredentialsFlow(arg_0));
        assertRemoveFailInRealm.accept(() -> ((RealmRepresentation)realm).getDockerAuthenticationFlow(), arg_0 -> ((RealmRepresentation)realm).setDockerAuthenticationFlow(arg_0));
        assertRemoveFailInRealm.accept(() -> ((RealmRepresentation)realm).getFirstBrokerLoginFlow(), arg_0 -> ((RealmRepresentation)realm).setFirstBrokerLoginFlow(arg_0));
        ClientRepresentation client = (ClientRepresentation)this.realmResource.clients().findByClientId("account").get(0);
        ClientResource clientResource = this.realmResource.clients().get(client.getId());
        try {
            client.setAuthenticationFlowBindingOverrides(Map.of("browser", flowId));
            clientResource.update(client);
            assertRemoveFail.run();
        }
        finally {
            client.setAuthenticationFlowBindingOverrides(Map.of("browser", ""));
            clientResource.update(client);
        }
        IdentityProviderRepresentation idp = new IdentityProviderRepresentation();
        idp.setAlias("idp");
        idp.setProviderId("oidc");
        Response response = this.realmResource.identityProviders().create(idp);
        Assertions.assertNotNull((Object)ApiUtil.getCreatedId((Response)response));
        response.close();
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(idp.getAlias()).remove());
        IdentityProviderResource idpResource = this.realmResource.identityProviders().get("idp");
        BiConsumer<Supplier, Consumer> assertRemoveFailByIdp = (rollbackIdp, updateIdp) -> {
            String rollbackValue = (String)rollbackIdp.get();
            try {
                updateIdp.accept(flowAlias);
                idpResource.update(idp);
                assertRemoveFail.run();
            }
            finally {
                updateIdp.accept(rollbackValue);
                idpResource.update(idp);
            }
        };
        assertRemoveFailByIdp.accept(() -> ((IdentityProviderRepresentation)idp).getFirstBrokerLoginFlowAlias(), arg_0 -> ((IdentityProviderRepresentation)idp).setFirstBrokerLoginFlowAlias(arg_0));
        assertRemoveFailByIdp.accept(() -> ((IdentityProviderRepresentation)idp).getPostBrokerLoginFlowAlias(), arg_0 -> ((IdentityProviderRepresentation)idp).setPostBrokerLoginFlowAlias(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFlow() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "clients");
        try (Response response = this.authMgmtResource.copy("browser", params);){
            MatcherAssert.assertThat((String)"Copy flow using the new alias of existing flow should fail", (Object)response, (Matcher)org.keycloak.tests.utils.matchers.Matchers.statusCodeIs((Response.Status)Response.Status.CONFLICT));
            MatcherAssert.assertThat((String)"Copy flow using the new alias of existing flow should fail", (Object)response, (Matcher)org.keycloak.tests.utils.matchers.Matchers.body((Matcher)Matchers.containsString((String)"already exists")));
            MatcherAssert.assertThat((String)"Copy flow using the new alias of existing flow should fail", (Object)response, (Matcher)org.keycloak.tests.utils.matchers.Matchers.body((Matcher)Matchers.containsString((String)"flow alias")));
        }
        params.clear();
        response = this.authMgmtResource.copy("non-existent", params);
        try {
            MatcherAssert.assertThat((String)"Copy non-existing flow", (Object)response, (Matcher)org.keycloak.tests.utils.matchers.Matchers.statusCodeIs((Response.Status)Response.Status.NOT_FOUND));
        }
        finally {
            response.close();
        }
        params.put("newName", "Copy of browser");
        response = this.authMgmtResource.copy("browser", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), params, (ResourceType)ResourceType.AUTH_FLOW);
        try {
            MatcherAssert.assertThat((String)"Copy flow", (Object)response, (Matcher)org.keycloak.tests.utils.matchers.Matchers.statusCodeIs((Response.Status)Response.Status.CREATED));
        }
        finally {
            response.close();
        }
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation browser = FlowTest.findFlowByAlias("browser", flows);
        AuthenticationFlowRepresentation copyOfBrowser = FlowTest.findFlowByAlias("Copy of browser", flows);
        Assertions.assertNotNull((Object)browser);
        Assertions.assertNotNull((Object)copyOfBrowser);
        browser.setAlias("Copy of browser");
        browser.setBuiltIn(false);
        ((AuthenticationExecutionExportRepresentation)browser.getAuthenticationExecutions().get(3)).setFlowAlias("Copy of browser Organization");
        ((AuthenticationExecutionExportRepresentation)browser.getAuthenticationExecutions().get(4)).setFlowAlias("Copy of browser forms");
        this.compareFlows(browser, copyOfBrowser);
        copyOfBrowser = this.authMgmtResource.getFlow(copyOfBrowser.getId());
        Assertions.assertNotNull((Object)copyOfBrowser);
        this.compareFlows(browser, copyOfBrowser);
        this.authMgmtResource.deleteFlow(copyOfBrowser.getId());
    }

    @Test
    public void addExecutionFlow() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "parent");
        Response response = this.authMgmtResource.copy("browser", params);
        Assertions.assertEquals((int)201, (int)response.getStatus());
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), params, (ResourceType)ResourceType.AUTH_FLOW);
        params = new HashMap();
        params.put("alias", "child");
        params.put("description", "Description");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        this.authMgmtResource.addExecutionFlow("parent", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"parent"), params, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        this.authMgmtResource.deleteFlow(FlowTest.findFlowByAlias("parent", this.authMgmtResource.getFlows()).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void editFlowTest() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "Copy of browser");
        Response response = this.authMgmtResource.copy("browser", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), params, (ResourceType)ResourceType.AUTH_FLOW);
        try {
            Assertions.assertEquals((int)201, (int)response.getStatus(), (String)"Copy flow");
        }
        finally {
            response.close();
        }
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation testFlow = FlowTest.findFlowByAlias("Copy of browser", flows);
        testFlow.setAlias("Copy of browser2");
        this.authMgmtResource.updateFlow(testFlow.getId(), testFlow);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authEditFlowPath((String)testFlow.getId()), (ResourceType)ResourceType.AUTH_FLOW);
        flows = this.authMgmtResource.getFlows();
        Assertions.assertEquals((Object)"Copy of browser2", (Object)FlowTest.findFlowByAlias("Copy of browser2", flows).getAlias());
        AuthenticationFlowRepresentation newFlow = this.newFlow("New Flow", "Test description", "basic-flow", true, false);
        this.createFlow(newFlow);
        flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation found = FlowTest.findFlowByAlias("New Flow", flows);
        Assertions.assertNotNull((Object)found, (String)"created flow visible in parent");
        this.compareFlows(newFlow, found);
        testFlow.setAlias("New Flow");
        try {
            this.authMgmtResource.updateFlow(found.getId(), testFlow);
        }
        catch (ClientErrorException clientErrorException) {
            // empty catch block
        }
        testFlow.setAlias("New(Flow");
        try {
            this.authMgmtResource.updateFlow(found.getId(), testFlow);
        }
        catch (ClientErrorException clientErrorException) {
            // empty catch block
        }
        flows = this.authMgmtResource.getFlows();
        Assertions.assertEquals((Object)"Copy of browser2", (Object)FlowTest.findFlowByAlias("Copy of browser2", flows).getAlias());
        found.setDescription("New description");
        this.authMgmtResource.updateFlow(found.getId(), found);
        flows = this.authMgmtResource.getFlows();
        Assertions.assertEquals((Object)"New description", (Object)FlowTest.findFlowByAlias("New Flow", flows).getDescription());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authEditFlowPath((String)found.getId()), (ResourceType)ResourceType.AUTH_FLOW);
        found.setAlias("New Flow2");
        found.setDescription("New description2");
        this.authMgmtResource.updateFlow(found.getId(), found);
        flows = this.authMgmtResource.getFlows();
        Assertions.assertEquals((Object)"New Flow2", (Object)FlowTest.findFlowByAlias("New Flow2", flows).getAlias());
        Assertions.assertEquals((Object)"New description2", (Object)FlowTest.findFlowByAlias("New Flow2", flows).getDescription());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authEditFlowPath((String)found.getId()), (ResourceType)ResourceType.AUTH_FLOW);
        Assertions.assertNull((Object)FlowTest.findFlowByAlias("New Flow", flows));
        this.authMgmtResource.deleteFlow(testFlow.getId());
    }

    @Test
    public void editExecutionFlowTest() {
        HashMap<String, String> params = new HashMap<String, String>();
        AuthenticationFlowRepresentation newFlow = this.newFlow("Parent-Flow", "This is a parent flow", "basic-flow", true, false);
        this.createFlow(newFlow);
        params.put("alias", "Child-Flow");
        params.put("description", "This is a child flow");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        this.authMgmtResource.addExecutionFlow("Parent-Flow", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"Parent-Flow"), params, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        List executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        params = new HashMap();
        params.put("alias", "Child-Flow");
        params.put("description", "This is another child flow");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        try {
            this.authMgmtResource.addExecutionFlow("Parent-Flow", params);
            Assertions.fail((String)"addExecutionFlow the alias already exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        AuthenticationExecutionInfoRepresentation found = (AuthenticationExecutionInfoRepresentation)executionReps.get(0);
        found.setDisplayName("Parent-Flow");
        try {
            this.authMgmtResource.updateExecutions("Parent-Flow", found);
        }
        catch (ClientErrorException clientErrorException) {
            // empty catch block
        }
        found.setDisplayName("Child-Flow2");
        found.setDescription("This is another child flow2");
        this.authMgmtResource.updateExecutions("Parent-Flow", found);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"Parent-Flow"), (ResourceType)ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        Assertions.assertEquals((Object)"Child-Flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDisplayName());
        Assertions.assertEquals((Object)"This is another child flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDescription());
        found.setDescription("This is another child flow3");
        this.authMgmtResource.updateExecutions("Parent-Flow", found);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"Parent-Flow"), (ResourceType)ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        Assertions.assertEquals((Object)"Child-Flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDisplayName());
        Assertions.assertEquals((Object)"This is another child flow3", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDescription());
    }

    @Test
    public void prioritySetTest() {
        AuthenticationFlowRepresentation newFlow = this.newFlow("Parent-Flow", "This is a parent flow", "basic-flow", true, false);
        this.createFlow(newFlow);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("alias", "Child-Flow1");
        params.put("description", "This is a child flow");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        params.put("priority", 50);
        this.authMgmtResource.addExecutionFlow("Parent-Flow", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"Parent-Flow"), params, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        params.clear();
        params.put("alias", "Child-Flow2");
        params.put("description", "This is a second child flow");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        params.put("priority", 10);
        this.authMgmtResource.addExecutionFlow("Parent-Flow", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"Parent-Flow"), params, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        params.clear();
        params.put("alias", "Child-Flow3");
        params.put("description", "This is a third child flow");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        params.put("priority", 20);
        this.authMgmtResource.addExecutionFlow("Parent-Flow", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"Parent-Flow"), params, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        List executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        Assertions.assertEquals((Object)"Child-Flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDisplayName());
        Assertions.assertEquals((int)10, (int)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getPriority());
        Assertions.assertEquals((Object)"Child-Flow3", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(1)).getDisplayName());
        Assertions.assertEquals((int)20, (int)((AuthenticationExecutionInfoRepresentation)executionReps.get(1)).getPriority());
        Assertions.assertEquals((Object)"Child-Flow1", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(2)).getDisplayName());
        Assertions.assertEquals((int)50, (int)((AuthenticationExecutionInfoRepresentation)executionReps.get(2)).getPriority());
        AuthenticationExecutionInfoRepresentation lastToFirst = (AuthenticationExecutionInfoRepresentation)executionReps.get(2);
        lastToFirst.setPriority(5);
        this.authMgmtResource.updateExecutions("Parent-Flow", lastToFirst);
        executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        Assertions.assertEquals((Object)"Child-Flow1", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDisplayName());
        Assertions.assertEquals((int)5, (int)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getPriority());
        Assertions.assertEquals((Object)"Child-Flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(1)).getDisplayName());
        Assertions.assertEquals((int)10, (int)((AuthenticationExecutionInfoRepresentation)executionReps.get(1)).getPriority());
        Assertions.assertEquals((Object)"Child-Flow3", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(2)).getDisplayName());
        Assertions.assertEquals((int)20, (int)((AuthenticationExecutionInfoRepresentation)executionReps.get(2)).getPriority());
    }

    @Test
    public void failWithLongDescription() throws IOException {
        AuthenticationFlowRepresentation rep = this.authMgmtResource.getFlows().stream().filter(rep1 -> "docker auth".equals(rep1.getAlias())).findAny().orElse(null);
        Assert.assertNotNull((Object)rep);
        StringBuilder name = new StringBuilder();
        while (name.length() < 300) {
            name.append("invalid");
        }
        rep.setDescription(name.toString());
        try {
            this.authMgmtResource.updateFlow(rep.getId(), rep);
            Assert.fail((String)"Should fail because the description is too long");
        }
        catch (InternalServerErrorException isee) {
            try (Response response = isee.getResponse();){
                Assert.assertEquals((long)500L, (long)response.getStatus());
                Assert.assertFalse((boolean)StreamUtil.readString((InputStream)((InputStream)response.getEntity()), (Charset)StandardCharsets.UTF_8).toLowerCase().contains("exception"));
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testAddRemoveExecutionsFailInBuiltinFlow() throws IOException {
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation flow = flows.stream().filter(AuthenticationFlowRepresentation::isBuiltIn).findFirst().orElse(null);
        Assertions.assertNotNull((Object)flow, (String)"There is no builtin flow");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("provider", "allow-access-authenticator");
        BadRequestException e = (BadRequestException)Assertions.assertThrows(BadRequestException.class, () -> this.authMgmtResource.addExecution(flow.getAlias(), data));
        OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)e.getResponse().readEntity(OAuth2ErrorRepresentation.class);
        Assertions.assertEquals((Object)"It is illegal to add execution to a built in flow", (Object)error.getError());
        e = (BadRequestException)Assertions.assertThrows(BadRequestException.class, () -> this.addFlowToParent(flow.getAlias(), "child"));
        error = (OAuth2ErrorRepresentation)e.getResponse().readEntity(OAuth2ErrorRepresentation.class);
        Assertions.assertEquals((Object)"It is illegal to add sub-flow to a built in flow", (Object)error.getError());
        List executions = this.authMgmtResource.getExecutions(flow.getAlias());
        Assertions.assertNotNull((Object)executions, (String)"The builtin flow has no executions");
        Assertions.assertFalse((boolean)executions.isEmpty(), (String)"The builtin flow has no executions");
        e = (BadRequestException)Assertions.assertThrows(BadRequestException.class, () -> this.authMgmtResource.removeExecution(((AuthenticationExecutionInfoRepresentation)executions.get(0)).getId()));
        error = (OAuth2ErrorRepresentation)e.getResponse().readEntity(OAuth2ErrorRepresentation.class);
        Assertions.assertEquals((Object)"It is illegal to remove execution from a built in flow", (Object)error.getError());
    }

    @Test
    public void testExecutionConfigDuplicated() {
        AuthenticationFlowRepresentation existingFlow = null;
        for (AuthenticationFlowRepresentation flow : this.authMgmtResource.getFlows()) {
            if (!flow.getAlias().equals("browser")) continue;
            existingFlow = flow;
        }
        Assertions.assertNotNull(existingFlow);
        List executions = this.authMgmtResource.getExecutions(existingFlow.getAlias());
        AuthenticationExecutionInfoRepresentation executionWithConfig = null;
        for (AuthenticationExecutionInfoRepresentation execution : executions) {
            if (!"identity-provider-redirector".equals(execution.getProviderId())) continue;
            executionWithConfig = execution;
        }
        Assertions.assertNotNull(executionWithConfig);
        AuthenticatorConfigRepresentation executionConfig = new AuthenticatorConfigRepresentation();
        executionConfig.setAlias("test-execution-config");
        executionConfig.setConfig(Map.of("key", "value"));
        try (Response response = this.authMgmtResource.newExecutionConfig(executionWithConfig.getId(), executionConfig);){
            this.managedRealm.cleanup().add(r -> r.flows().removeAuthenticatorConfig(ApiUtil.getCreatedId((Response)response)));
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionConfigPath((String)executionWithConfig.getId()), (Object)executionConfig, (ResourceType)ResourceType.AUTHENTICATOR_CONFIG);
        }
        String newFlowName = "Duplicated of browser";
        Map<String, String> copyFlowParams = Map.of("newName", newFlowName);
        this.authMgmtResource.copy(existingFlow.getAlias(), copyFlowParams).close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), copyFlowParams, (ResourceType)ResourceType.AUTH_FLOW);
        AuthenticationFlowRepresentation newFlow = null;
        for (AuthenticationFlowRepresentation flow : this.authMgmtResource.getFlows()) {
            if (!flow.getAlias().equals(newFlowName)) continue;
            newFlow = flow;
        }
        Set existingExecutionConfigIds = this.authMgmtResource.getExecutions(existingFlow.getAlias()).stream().map(AuthenticationExecutionInfoRepresentation::getAuthenticationConfig).filter(Objects::nonNull).collect(Collectors.toSet());
        Assert.assertFalse((boolean)existingExecutionConfigIds.isEmpty());
        Set newExecutionConfigIds = this.authMgmtResource.getExecutions(newFlow.getAlias()).stream().map(AuthenticationExecutionInfoRepresentation::getAuthenticationConfig).filter(Objects::nonNull).collect(Collectors.toSet());
        Assert.assertFalse((boolean)newExecutionConfigIds.isEmpty());
        for (String executionConfigId : newExecutionConfigIds) {
            Assertions.assertFalse((boolean)existingExecutionConfigIds.contains(executionConfigId), (String)"Execution config not duplicated");
        }
    }
}

