/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.KerberosUtils;

@KeycloakIntegrationTest
public class InitialFlowsTest
extends AbstractAuthenticationTest {
    private HashMap<String, AuthenticatorConfigRepresentation> configs = new HashMap();
    private HashMap<String, AuthenticatorConfigRepresentation> expectedConfigs = new HashMap();

    public InitialFlowsTest() {
        this.expectedConfigs.put("idp-review-profile", this.newConfig("review profile config", new String[]{"update.profile.on.first.login", "missing"}));
        this.expectedConfigs.put("idp-create-user-if-unique", this.newConfig("create unique user config", new String[]{"require.password.update.after.registration", "false"}));
    }

    @Test
    public void testInitialFlows() {
        LinkedList<FlowExecutions> result = new LinkedList<FlowExecutions>();
        List flows = this.authMgmtResource.getFlows();
        for (AuthenticationFlowRepresentation flow : flows) {
            List executionReps = this.authMgmtResource.getExecutions(flow.getAlias());
            for (AuthenticationExecutionInfoRepresentation exec : executionReps) {
                String configId = exec.getAuthenticationConfig();
                if (configId == null || this.configs.containsKey(configId)) continue;
                this.configs.put(configId, this.authMgmtResource.getAuthenticatorConfig(configId));
            }
            result.add(new FlowExecutions(flow, executionReps));
        }
        this.compare(this.expectedFlows(), this.orderAlphabetically(result));
    }

    private void compare(List<FlowExecutions> expected, List<FlowExecutions> actual) {
        Iterator<FlowExecutions> it1 = expected.iterator();
        Iterator<FlowExecutions> it2 = actual.iterator();
        while (it1.hasNext()) {
            FlowExecutions fe1 = it1.next();
            FlowExecutions fe2 = it2.next();
            this.expectedConfigs.put("conditional-credential", this.newConfig("browser".equals(fe1.flow.getAlias()) ? "browser-conditional-credential" : "first-broker-login-conditional-credential", new String[]{"credentials", "webauthn-passwordless"}));
            this.compareFlows(fe1.flow, fe2.flow);
            this.compareExecutionsInfo(fe1.executions, fe2.executions);
        }
    }

    private void compareExecutionsInfo(List<AuthenticationExecutionInfoRepresentation> expected, List<AuthenticationExecutionInfoRepresentation> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Executions count");
        Iterator<AuthenticationExecutionInfoRepresentation> it1 = expected.iterator();
        Iterator<AuthenticationExecutionInfoRepresentation> it2 = actual.iterator();
        while (it1.hasNext()) {
            AuthenticationExecutionInfoRepresentation exe1 = it1.next();
            AuthenticationExecutionInfoRepresentation exe2 = it2.next();
            this.compareExecutionWithConfig(exe1, exe2);
        }
    }

    private void compareExecutionWithConfig(AuthenticationExecutionInfoRepresentation expected, AuthenticationExecutionInfoRepresentation actual) {
        super.compareExecution(expected, actual);
        this.compareAuthConfig(expected, actual);
    }

    private void compareAuthConfig(AuthenticationExecutionInfoRepresentation expected, AuthenticationExecutionInfoRepresentation actual) {
        AuthenticatorConfigRepresentation cfg1 = this.expectedConfigs.get(expected.getProviderId());
        AuthenticatorConfigRepresentation cfg2 = this.configs.get(actual.getAuthenticationConfig());
        if (cfg1 == null && cfg2 == null) {
            return;
        }
        Assertions.assertEquals((Object)cfg1.getAlias(), (Object)cfg2.getAlias(), (String)"Execution configuration alias");
        Assertions.assertEquals((Object)cfg1.getConfig(), (Object)cfg2.getConfig(), (String)"Execution configuration params");
    }

    private List<FlowExecutions> orderAlphabetically(List<FlowExecutions> result) {
        ArrayList<FlowExecutions> sorted = new ArrayList<FlowExecutions>(result);
        Collections.sort(sorted);
        return sorted;
    }

    private LinkedList<FlowExecutions> expectedFlows() {
        String[] stringArray;
        LinkedList<FlowExecutions> expected = new LinkedList<FlowExecutions>();
        if (KerberosUtils.isKerberosSupportExpected()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "REQUIRED";
            stringArray2[1] = "ALTERNATIVE";
            stringArray = stringArray2;
            stringArray2[2] = "DISABLED";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "DISABLED";
        }
        String[] kerberosAuthExpectedChoices = stringArray;
        AuthenticationFlowRepresentation flow = this.newFlow("browser", "Browser based authentication", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "auth-cookie", false, null, "ALTERNATIVE", 10);
        this.addExecExport(flow, null, false, "auth-spnego", false, null, "DISABLED", 20);
        this.addExecExport(flow, null, false, "identity-provider-redirector", false, null, "ALTERNATIVE", 25);
        this.addExecExport(flow, "Organization", false, null, true, null, "ALTERNATIVE", 26);
        this.addExecExport(flow, "forms", false, null, true, null, "ALTERNATIVE", 30);
        LinkedList<Object> execs = new LinkedList<AuthenticationExecutionInfoRepresentation>();
        this.addExecInfo(execs, "Cookie", "auth-cookie", false, 0, 0, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 10);
        this.addExecInfo(execs, "Kerberos", "auth-spnego", false, 0, 1, "DISABLED", null, kerberosAuthExpectedChoices, 20);
        this.addExecInfo(execs, "Identity Provider Redirector", "identity-provider-redirector", true, 0, 2, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 25);
        this.addExecInfo(execs, "Organization", null, false, 0, 3, "ALTERNATIVE", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 26);
        this.addExecInfo(execs, "Browser - Conditional Organization", null, false, 1, 0, "CONDITIONAL", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 10);
        this.addExecInfo(execs, "Condition - user configured", "conditional-user-configured", false, 2, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 10);
        this.addExecInfo(execs, "Organization Identity-First Login", "organization", true, 2, 1, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 20);
        this.addExecInfo(execs, "forms", null, false, 0, 4, "ALTERNATIVE", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 30);
        this.addExecInfo(execs, "Username Password Form", "auth-username-password-form", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED"}, 10);
        this.addExecInfo(execs, "Browser - Conditional 2FA", null, false, 1, 1, "CONDITIONAL", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 20);
        this.addExecInfo(execs, "Condition - user configured", "conditional-user-configured", false, 2, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 10);
        this.addExecInfo(execs, "Condition - credential", "conditional-credential", true, 2, 1, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 20);
        this.addExecInfo(execs, "OTP Form", "auth-otp-form", false, 2, 2, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 30);
        this.addExecInfo(execs, "WebAuthn Authenticator", "webauthn-authenticator", false, 2, 3, "DISABLED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 40);
        this.addExecInfo(execs, "Recovery Authentication Code Form", "auth-recovery-authn-code-form", false, 2, 4, "DISABLED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 50);
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("clients", "Base authentication for clients", "client-flow", true, true);
        this.addExecExport(flow, null, false, "client-secret", false, null, "ALTERNATIVE", 10);
        this.addExecExport(flow, null, false, "client-jwt", false, null, "ALTERNATIVE", 20);
        this.addExecExport(flow, null, false, "client-secret-jwt", false, null, "ALTERNATIVE", 30);
        this.addExecExport(flow, null, false, "client-x509", false, null, "ALTERNATIVE", 40);
        execs = new LinkedList();
        this.addExecInfo(execs, "Client Id and Secret", "client-secret", false, 0, 0, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 10);
        this.addExecInfo(execs, "Signed Jwt", "client-jwt", false, 0, 1, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 20);
        this.addExecInfo(execs, "Signed Jwt with Client Secret", "client-secret-jwt", false, 0, 2, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 30);
        this.addExecInfo(execs, "X509 Certificate", "client-x509", false, 0, 3, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 40);
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("direct grant", "OpenID Connect Resource Owner Grant", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "direct-grant-validate-username", false, null, "REQUIRED", 10);
        this.addExecExport(flow, null, false, "direct-grant-validate-password", false, null, "REQUIRED", 20);
        this.addExecExport(flow, "Direct Grant - Conditional OTP", false, null, true, null, "CONDITIONAL", 30);
        execs = new LinkedList();
        this.addExecInfo(execs, "Username Validation", "direct-grant-validate-username", false, 0, 0, "REQUIRED", null, new String[]{"REQUIRED"}, 10);
        this.addExecInfo(execs, "Password", "direct-grant-validate-password", false, 0, 1, "REQUIRED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 20);
        this.addExecInfo(execs, "Direct Grant - Conditional OTP", null, false, 0, 2, "CONDITIONAL", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 30);
        this.addExecInfo(execs, "Condition - user configured", "conditional-user-configured", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 10);
        this.addExecInfo(execs, "OTP", "direct-grant-validate-otp", false, 1, 1, "REQUIRED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 20);
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("docker auth", "Used by Docker clients to authenticate against the IDP", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "docker-http-basic-authenticator", false, null, "REQUIRED", 10);
        execs = new LinkedList();
        this.addExecInfo(execs, "Docker Authenticator", "docker-http-basic-authenticator", false, 0, 0, "REQUIRED", null, new String[]{"REQUIRED"}, 10);
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("first broker login", "Actions taken after first broker login with identity provider account, which is not yet linked to any Keycloak account", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "idp-review-profile", false, "review profile config", "REQUIRED", 10);
        this.addExecExport(flow, "User creation or linking", false, null, true, null, "REQUIRED", 20);
        this.addExecExport(flow, "First Broker Login - Conditional Organization", false, null, true, null, "CONDITIONAL", 60);
        execs = new LinkedList();
        this.addExecInfo(execs, "Review Profile", "idp-review-profile", true, 0, 0, "REQUIRED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 10);
        this.addExecInfo(execs, "User creation or linking", null, false, 0, 1, "REQUIRED", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 20);
        this.addExecInfo(execs, "Create User If Unique", "idp-create-user-if-unique", true, 1, 0, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 10);
        this.addExecInfo(execs, "Handle Existing Account", null, false, 1, 1, "ALTERNATIVE", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 20);
        this.addExecInfo(execs, "Confirm link existing account", "idp-confirm-link", false, 2, 0, "REQUIRED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 10);
        this.addExecInfo(execs, "Account verification options", null, false, 2, 1, "REQUIRED", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 20);
        this.addExecInfo(execs, "Verify existing account by Email", "idp-email-verification", false, 3, 0, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 10);
        this.addExecInfo(execs, "Verify Existing Account by Re-authentication", null, false, 3, 1, "ALTERNATIVE", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 20);
        this.addExecInfo(execs, "Username Password Form for identity provider reauthentication", "idp-username-password-form", false, 4, 0, "REQUIRED", null, new String[]{"REQUIRED"}, 10);
        this.addExecInfo(execs, "First broker login - Conditional 2FA", null, false, 4, 1, "CONDITIONAL", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 20);
        this.addExecInfo(execs, "Condition - user configured", "conditional-user-configured", false, 5, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 10);
        this.addExecInfo(execs, "Condition - credential", "conditional-credential", true, 5, 1, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 20);
        this.addExecInfo(execs, "OTP Form", "auth-otp-form", false, 5, 2, "ALTERNATIVE", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 30);
        this.addExecInfo(execs, "WebAuthn Authenticator", "webauthn-authenticator", false, 5, 3, "DISABLED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 40);
        this.addExecInfo(execs, "Recovery Authentication Code Form", "auth-recovery-authn-code-form", false, 5, 4, "DISABLED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 50);
        this.addExecInfo(execs, "First Broker Login - Conditional Organization", null, false, 0, 2, "CONDITIONAL", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 60);
        this.addExecInfo(execs, "Condition - user configured", "conditional-user-configured", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 10);
        this.addExecInfo(execs, "Organization Member Onboard", "idp-add-organization-member", false, 1, 1, "REQUIRED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 20);
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("registration", "Registration flow", "basic-flow", true, true);
        this.addExecExport(flow, "registration form", false, "registration-page-form", true, null, "REQUIRED", 10);
        execs = new LinkedList();
        this.addExecInfo(execs, "registration form", "registration-page-form", false, 0, 0, "REQUIRED", true, new String[]{"REQUIRED", "DISABLED"}, 10);
        this.addExecInfo(execs, "Registration User Profile Creation", "registration-user-creation", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 20);
        this.addExecInfo(execs, "Password Validation", "registration-password-action", false, 1, 1, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 50);
        this.addExecInfo(execs, "reCAPTCHA", "registration-recaptcha-action", true, 1, 2, "DISABLED", null, new String[]{"REQUIRED", "DISABLED"}, 60);
        this.addExecInfo(execs, "Terms and conditions", "registration-terms-and-conditions", false, 1, 3, "DISABLED", null, new String[]{"REQUIRED", "DISABLED"}, 70);
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("reset credentials", "Reset credentials for a user if they forgot their password or something", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "reset-credentials-choose-user", false, null, "REQUIRED", 10);
        this.addExecExport(flow, null, false, "reset-credential-email", false, null, "REQUIRED", 20);
        this.addExecExport(flow, null, false, "reset-password", false, null, "REQUIRED", 30);
        this.addExecExport(flow, "Reset - Conditional OTP", false, null, true, null, "CONDITIONAL", 40);
        execs = new LinkedList();
        this.addExecInfo(execs, "Choose User", "reset-credentials-choose-user", false, 0, 0, "REQUIRED", null, new String[]{"REQUIRED"}, 10);
        this.addExecInfo(execs, "Send Reset Email", "reset-credential-email", true, 0, 1, "REQUIRED", null, new String[]{"REQUIRED"}, 20);
        this.addExecInfo(execs, "Reset Password", "reset-password", false, 0, 2, "REQUIRED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 30);
        this.addExecInfo(execs, "Reset - Conditional OTP", null, false, 0, 3, "CONDITIONAL", true, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED", "CONDITIONAL"}, 40);
        this.addExecInfo(execs, "Condition - user configured", "conditional-user-configured", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"}, 10);
        this.addExecInfo(execs, "Reset OTP", "reset-otp", true, 1, 1, "REQUIRED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}, 20);
        expected.add(new FlowExecutions(flow, execs));
        return expected;
    }

    private void addExecExport(AuthenticationFlowRepresentation flow, String flowAlias, boolean userSetupAllowed, String authenticator, boolean authenticatorFlow, String authenticatorConfig, String requirement, int priority) {
        AuthenticationExecutionExportRepresentation rep = this.newExecutionExportRepresentation(flowAlias, userSetupAllowed, authenticator, authenticatorFlow, authenticatorConfig, requirement, priority);
        ArrayList<AuthenticationExecutionExportRepresentation> execs = flow.getAuthenticationExecutions();
        if (execs == null) {
            execs = new ArrayList<AuthenticationExecutionExportRepresentation>();
            flow.setAuthenticationExecutions(execs);
        }
        execs.add(rep);
    }

    private AuthenticationExecutionExportRepresentation newExecutionExportRepresentation(String flowAlias, boolean userSetupAllowed, String authenticator, boolean authenticatorFlow, String authenticatorConfig, String requirement, int priority) {
        AuthenticationExecutionExportRepresentation rep = new AuthenticationExecutionExportRepresentation();
        rep.setFlowAlias(flowAlias);
        rep.setUserSetupAllowed(userSetupAllowed);
        rep.setAuthenticator(authenticator);
        rep.setAuthenticatorFlow(authenticatorFlow);
        rep.setAuthenticatorConfig(authenticatorConfig);
        rep.setRequirement(requirement);
        rep.setPriority(Integer.valueOf(priority));
        return rep;
    }

    private static class FlowExecutions
    implements Comparable<FlowExecutions> {
        AuthenticationFlowRepresentation flow;
        List<AuthenticationExecutionInfoRepresentation> executions;

        FlowExecutions(AuthenticationFlowRepresentation flow, List<AuthenticationExecutionInfoRepresentation> executions) {
            this.flow = flow;
            this.executions = executions;
        }

        @Override
        public int compareTo(FlowExecutions o) {
            return this.flow.getAlias().compareTo(o.flow.getAlias());
        }
    }
}

