/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.AuthenticatorConfigInfoRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.KerberosUtils;

@KeycloakIntegrationTest
public class ProvidersTest
extends AbstractAuthenticationTest {
    @Test
    public void testFormProviders() {
        List result = this.authMgmtResource.getFormProviders();
        Assertions.assertNotNull((Object)result, (String)"null result");
        Assertions.assertEquals((int)1, (int)result.size(), (String)"size");
        Map item = (Map)result.get(0);
        Assertions.assertEquals((Object)"registration-page-form", item.get("id"), (String)"id");
        Assertions.assertEquals((Object)"Registration Page", item.get("displayName"), (String)"displayName");
        Assertions.assertEquals((Object)"This is the controller for the registration page", item.get("description"), (String)"description");
    }

    @Test
    public void testFormActionProviders() {
        List result = this.authMgmtResource.getFormActionProviders();
        LinkedList<Map<String, Object>> expected = new LinkedList<Map<String, Object>>();
        this.addProviderInfo(expected, "registration-recaptcha-action", "reCAPTCHA", "Adds Google reCAPTCHA to the form.");
        this.addProviderInfo(expected, "registration-recaptcha-enterprise", "reCAPTCHA Enterprise", "Adds Google reCAPTCHA Enterprise to the form.");
        this.addProviderInfo(expected, "registration-password-action", "Password Validation", "Validates that password matches password confirmation field.  It also will store password in user's credential store.");
        this.addProviderInfo(expected, "registration-user-creation", "Registration User Profile Creation", "This action must always be first! Validates the username and user profile of the user in validation phase.  In success phase, this will create the user in the database including his user profile.");
        this.addProviderInfo(expected, "registration-terms-and-conditions", "Terms and conditions", "Asks the user to accept terms and conditions before submitting its registration form.");
        this.compareProviders(expected, result);
    }

    @Test
    public void testClientAuthenticatorProviders() {
        List result = this.authMgmtResource.getClientAuthenticatorProviders();
        LinkedList<Map<String, Object>> expected = new LinkedList<Map<String, Object>>();
        this.addClientAuthenticatorProviderInfo(expected, "client-jwt", "Signed Jwt", "Validates client based on signed JWT issued by client and signed with the Client private key", false);
        this.addClientAuthenticatorProviderInfo(expected, "client-secret", "Client Id and Secret", "Validates client based on 'client_id' and 'client_secret' sent either in request parameters or in 'Authorization: Basic' header", true);
        this.addClientAuthenticatorProviderInfo(expected, "client-x509", "X509 Certificate", "Validates client based on a X509 Certificate", false);
        this.addClientAuthenticatorProviderInfo(expected, "client-secret-jwt", "Signed Jwt with Client Secret", "Validates client based on signed JWT issued by client and signed with the Client Secret", true);
        this.compareProviders(expected, result);
    }

    @Test
    public void testPerClientConfigDescriptions() {
        Map configs = this.authMgmtResource.getPerClientConfigDescription();
        Assertions.assertTrue((boolean)configs.containsKey("client-jwt"));
        Assertions.assertTrue((boolean)configs.containsKey("client-secret"));
        Assertions.assertTrue((boolean)((List)configs.get("client-jwt")).isEmpty());
        Assertions.assertTrue((boolean)((List)configs.get("client-secret")).isEmpty());
    }

    @Test
    public void testAuthenticatorConfigDescription() {
        try {
            this.authMgmtResource.getAuthenticatorConfigDescription("not-existent");
            Assertions.fail((String)"Don't expected to find provider 'not-existent'");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        AuthenticatorConfigInfoRepresentation infoRep = this.authMgmtResource.getAuthenticatorConfigDescription("idp-create-user-if-unique");
        Assertions.assertEquals((Object)"Create User If Unique", (Object)infoRep.getName());
        Assertions.assertEquals((Object)"idp-create-user-if-unique", (Object)infoRep.getProviderId());
        Assertions.assertEquals((Object)"Detect if there is existing Keycloak account with same email like identity provider. If no, create new user", (Object)infoRep.getHelpText());
        Assertions.assertEquals((int)1, (int)infoRep.getProperties().size());
        Assert.assertProviderConfigProperty((ConfigPropertyRepresentation)((ConfigPropertyRepresentation)infoRep.getProperties().get(0)), (String)"require.password.update.after.registration", (String)"Require Password Update After Registration", null, (String)"If this option is true and new user is successfully imported from Identity Provider to Keycloak (there is no duplicated email or username detected in Keycloak DB), then this user is required to update his password", (String)"boolean");
    }

    @Test
    public void testInitialAuthenticationProviders() {
        List providers = this.authMgmtResource.getAuthenticatorProviders();
        this.compareProviders(this.expectedAuthProviders(), providers);
    }

    private List<Map<String, Object>> expectedAuthProviders() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        this.addProviderInfo(result, "auth-conditional-otp-form", "Conditional OTP Form", "Validates a OTP on a separate OTP form. Only shown if required based on the configured conditions.");
        this.addProviderInfo(result, "auth-cookie", "Cookie", "Validates the SSO cookie set by the auth server.");
        this.addProviderInfo(result, "auth-otp-form", "OTP Form", "Validates a OTP on a separate OTP form.");
        String kerberosHelpMessage = KerberosUtils.isKerberosSupportExpected() ? "Initiates the SPNEGO protocol.  Most often used with Kerberos." : "DISABLED. Please enable Kerberos feature and make sure Kerberos available in your platform. Initiates the SPNEGO protocol. Most often used with Kerberos.";
        this.addProviderInfo(result, "auth-spnego", "Kerberos", kerberosHelpMessage);
        this.addProviderInfo(result, "auth-username-password-form", "Username Password Form", "Validates a username and password from login form.");
        this.addProviderInfo(result, "auth-x509-client-username-form", "X509/Validate Username Form", "Validates username and password from X509 client certificate received as a part of mutual SSL handshake.");
        this.addProviderInfo(result, "direct-grant-auth-x509-username", "X509/Validate Username", "Validates username and password from X509 client certificate received as a part of mutual SSL handshake.");
        this.addProviderInfo(result, "direct-grant-validate-otp", "OTP", "Validates the one time password supplied as a 'totp' form parameter in direct grant request");
        this.addProviderInfo(result, "direct-grant-validate-password", "Password", "Validates the password supplied as a 'password' form parameter in direct grant request");
        this.addProviderInfo(result, "direct-grant-validate-username", "Username Validation", "Validates the username supplied as a 'username' form parameter in direct grant request");
        this.addProviderInfo(result, "docker-http-basic-authenticator", "Docker Authenticator", "Uses HTTP Basic authentication to validate docker users, returning a docker error token on auth failure");
        this.addProviderInfo(result, "http-basic-authenticator", "HTTP Basic Authentication", "Validates username and password from Authorization HTTP header");
        this.addProviderInfo(result, "identity-provider-redirector", "Identity Provider Redirector", "Redirects to default Identity Provider or Identity Provider specified with kc_idp_hint query parameter");
        this.addProviderInfo(result, "idp-auto-link", "Automatically set existing user", "Automatically set existing user to authentication context without any verification");
        this.addProviderInfo(result, "idp-confirm-link", "Confirm link existing account", "Show the form where user confirms if he wants to link identity provider with existing account or rather edit user profile data retrieved from identity provider to avoid conflict");
        this.addProviderInfo(result, "idp-confirm-override-link", "Confirm override existing link", "Confirm override the link if there is an existing broker user linked to the account.");
        this.addProviderInfo(result, "idp-create-user-if-unique", "Create User If Unique", "Detect if there is existing Keycloak account with same email like identity provider. If no, create new user");
        this.addProviderInfo(result, "idp-email-verification", "Verify existing account by Email", "Email verification of existing Keycloak user, that wants to link his user account with identity provider");
        this.addProviderInfo(result, "idp-review-profile", "Review Profile", "User reviews and updates profile data retrieved from Identity Provider in the displayed form");
        this.addProviderInfo(result, "idp-username-password-form", "Username Password Form for identity provider reauthentication", "Validates a password from login form. Username may be already known from identity provider authentication");
        this.addProviderInfo(result, "reset-credential-email", "Send Reset Email", "Send email to user and wait for response.");
        this.addProviderInfo(result, "reset-credentials-choose-user", "Choose User", "Choose a user to reset credentials for");
        this.addProviderInfo(result, "reset-otp", "Reset OTP", "Removes existing OTP configurations (if chosen) and sets the 'Configure OTP' required action.");
        this.addProviderInfo(result, "reset-password", "Reset Password", "Sets the Update Password required action if execution is REQUIRED.  Will also set it if execution is OPTIONAL and the password is currently configured for it.");
        this.addProviderInfo(result, "webauthn-authenticator", "WebAuthn Authenticator", "Authenticator for WebAuthn. Usually used for WebAuthn two-factor authentication");
        this.addProviderInfo(result, "webauthn-authenticator-passwordless", "WebAuthn Passwordless Authenticator", "Authenticator for Passwordless WebAuthn authentication");
        this.addProviderInfo(result, "auth-recovery-authn-code-form", "Recovery Authentication Code Form", "Validates a Recovery Authentication Code");
        this.addProviderInfo(result, "auth-username-form", "Username Form", "Selects a user from his username.");
        this.addProviderInfo(result, "auth-password-form", "Password Form", "Validates a password from login form.");
        this.addProviderInfo(result, "conditional-user-role", "Condition - user role", "Flow is executed only if user has the given role.");
        this.addProviderInfo(result, "conditional-user-configured", "Condition - user configured", "Executes the current flow only if authenticators are configured");
        this.addProviderInfo(result, "conditional-user-attribute", "Condition - user attribute", "Flow is executed only if the user attribute exists and has the expected value");
        this.addProviderInfo(result, "idp-detect-existing-broker-user", "Detect existing broker user", "Detect if there is an existing Keycloak account with same email like identity provider. If no, throw an error.");
        this.addProviderInfo(result, "deny-access-authenticator", "Deny access", "Access will be always denied. Useful for example in the conditional flows to be used after satisfying the previous conditions");
        this.addProviderInfo(result, "allow-access-authenticator", "Allow access", "Authenticator will always successfully authenticate. Useful for example in the conditional flows to be used after satisfying the previous conditions");
        this.addProviderInfo(result, "conditional-level-of-authentication", "Condition - Level of Authentication", "Flow is executed only if the configured LOA or a higher one has been requested but not yet satisfied. After the flow is successfully finished, the LOA in the session will be updated to value prescribed by this condition.");
        this.addProviderInfo(result, "user-session-limits", "User session count limiter", "Configures how many concurrent sessions a single user is allowed to create for this realm and/or client");
        this.addProviderInfo(result, "idp-add-organization-member", "Organization Member Onboard", "Adds a federated user as a member of an organization");
        this.addProviderInfo(result, "organization", "Organization Identity-First Login", "If organizations are enabled, automatically redirects users to the corresponding identity provider.");
        this.addProviderInfo(result, "conditional-sub-flow-executed", "Condition - sub-flow executed", "Condition to evaluate if a sub-flow was executed successfully during the authentication process");
        this.addProviderInfo(result, "conditional-client-scope", "Condition - client scope", "Condition to evaluate if a configured client scope is present as a client scope of the client requesting authentication");
        this.addProviderInfo(result, "conditional-credential", "Condition - credential", "Condition to evaluate if a specific credential type has been used (or not used) by the user during the authentication process");
        return result;
    }

    private List<Map<String, Object>> sortProviders(List<Map<String, Object>> providers) {
        ArrayList<Map<String, Object>> sorted = new ArrayList<Map<String, Object>>(providers);
        Collections.sort(sorted, new ProviderComparator());
        return sorted;
    }

    private void compareProviders(List<Map<String, Object>> expected, List<Map<String, Object>> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Providers count");
        MatcherAssert.assertThat(this.normalizeResults(actual), (Matcher)Matchers.is(this.normalizeResults(expected)));
    }

    private List<Map<String, Object>> normalizeResults(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> item : list) {
            result.add(new HashMap<String, Object>(item));
        }
        return this.sortProviders(result);
    }

    private void addProviderInfo(List<Map<String, Object>> list, String id, String displayName, String description) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("id", id);
        item.put("displayName", displayName);
        item.put("description", description);
        list.add(item);
    }

    private void addClientAuthenticatorProviderInfo(List<Map<String, Object>> list, String id, String displayName, String description, boolean supportsSecret) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("id", id);
        item.put("displayName", displayName);
        item.put("description", description);
        item.put("supportsSecret", supportsSecret);
        list.add(item);
    }

    private static class ProviderComparator
    implements Comparator<Map<String, Object>> {
        private ProviderComparator() {
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            return String.valueOf(o1.get("id")).compareTo(String.valueOf(o2.get("id")));
        }
    }
}

