/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.BadRequestException;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class RegistrationFlowTest
extends AbstractAuthenticationTest {
    @Test
    public void testAddExecution() {
        AuthenticationFlowRepresentation flowRep = this.newFlow("registration2", "RegistrationFlow2", "basic-flow", true, false);
        this.createFlow(flowRep);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("alias", "registrationForm2");
        data.put("type", "form-flow");
        data.put("description", "registrationForm2 flow");
        data.put("provider", "registration-page-form");
        this.authMgmtResource.addExecutionFlow("registration2", data);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionFlowPath((String)"registration2"), data, (ResourceType)ResourceType.AUTH_EXECUTION_FLOW);
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("provider", "registration-password-action");
        try {
            this.authMgmtResource.addExecution("registration2", data2);
            Assertions.fail((String)"Not expected to add execution of type 'registration-password-action' under top flow");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        this.authMgmtResource.addExecution("registrationForm2", data2);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authAddExecutionPath((String)"registrationForm2"), data2, (ResourceType)ResourceType.AUTH_EXECUTION);
    }
}

