/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RequiredActionConfigInfoRepresentation;
import org.keycloak.representations.idm.RequiredActionConfigRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest(config=CustomProvidersServerConfig.class)
public class RequiredActionsTest
extends AbstractAuthenticationTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;

    @Test
    public void testRequiredActions() {
        List result = this.authMgmtResource.getRequiredActions();
        ArrayList<RequiredActionProviderRepresentation> expected = new ArrayList<RequiredActionProviderRepresentation>();
        this.addRequiredAction(expected, "CONFIGURE_RECOVERY_AUTHN_CODES", "Recovery Authentication Codes", true, false, null);
        this.addRequiredAction(expected, "CONFIGURE_TOTP", "Configure OTP", true, false, null);
        this.addRequiredAction(expected, "TERMS_AND_CONDITIONS", "Terms and Conditions", false, false, null);
        this.addRequiredAction(expected, "UPDATE_EMAIL", "Update Email", false, false, null);
        this.addRequiredAction(expected, "UPDATE_PASSWORD", "Update Password", true, false, null);
        this.addRequiredAction(expected, "UPDATE_PROFILE", "Update Profile", true, false, null);
        this.addRequiredAction(expected, "VERIFY_EMAIL", "Verify Email", true, false, null);
        this.addRequiredAction(expected, "VERIFY_PROFILE", "Verify Profile", true, false, null);
        this.addRequiredAction(expected, "delete_account", "Delete Account", false, false, null);
        this.addRequiredAction(expected, "delete_credential", "Delete Credential", true, false, null);
        this.addRequiredAction(expected, "idp_link", "Linking Identity Provider", true, false, null);
        this.addRequiredAction(expected, "update_user_locale", "Update User Locale", true, false, null);
        this.addRequiredAction(expected, "webauthn-register", "Webauthn Register", true, false, null);
        this.addRequiredAction(expected, "webauthn-register-passwordless", "Webauthn Register Passwordless", true, false, null);
        this.compareRequiredActions(expected, this.sort(result));
        RequiredActionProviderRepresentation forUpdate = this.newRequiredAction("VERIFY_EMAIL", "Verify Email", false, false, null);
        this.authMgmtResource.updateRequiredAction(forUpdate.getAlias(), forUpdate);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRequiredActionPath((String)forUpdate.getAlias()), (ResourceType)ResourceType.REQUIRED_ACTION);
        result = this.authMgmtResource.getRequiredActions();
        RequiredActionProviderRepresentation updated = this.findRequiredActionByAlias(forUpdate.getAlias(), result);
        Assertions.assertNotNull((Object)updated, (String)"Required Action still there");
        this.compareRequiredAction(forUpdate, updated);
        forUpdate.setConfig(Collections.emptyMap());
        this.authMgmtResource.updateRequiredAction(forUpdate.getAlias(), forUpdate);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRequiredActionPath((String)forUpdate.getAlias()), (ResourceType)ResourceType.REQUIRED_ACTION);
        result = this.authMgmtResource.getRequiredActions();
        updated = this.findRequiredActionByAlias(forUpdate.getAlias(), result);
        Assertions.assertNotNull((Object)updated, (String)"Required Action still there");
        this.compareRequiredAction(forUpdate, updated);
    }

    @Test
    public void testCRUDRequiredAction() {
        int lastPriority = ((RequiredActionProviderRepresentation)this.authMgmtResource.getRequiredActions().get(this.authMgmtResource.getRequiredActions().size() - 1)).getPriority();
        List result = this.authMgmtResource.getUnregisteredRequiredActions();
        Assertions.assertEquals((int)2, (int)result.size());
        RequiredActionProviderSimpleRepresentation action = result.stream().filter(a -> a.getProviderId().equals("dummy-action")).findFirst().get();
        Assertions.assertEquals((Object)"dummy-action", (Object)action.getProviderId());
        Assertions.assertEquals((Object)"Dummy Action", (Object)action.getName());
        this.authMgmtResource.registerRequiredAction(action);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)(AdminEventPaths.authMgmtBasePath() + "/register-required-action"), (Object)action, (ResourceType)ResourceType.REQUIRED_ACTION);
        try {
            this.authMgmtResource.registerRequiredAction(action);
        }
        catch (ClientErrorException clientErrorException) {
            // empty catch block
        }
        RequiredActionProviderSimpleRepresentation requiredAction = new RequiredActionProviderSimpleRepresentation();
        requiredAction.setName("not-existent");
        requiredAction.setProviderId("not-existent");
        try {
            this.authMgmtResource.registerRequiredAction(requiredAction);
            Assertions.fail((String)"Didn't expect to register requiredAction with providerId: 'not-existent'");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.authMgmtResource.getRequiredAction("not-existent");
            Assertions.fail((String)"Didn't expect to find requiredAction of alias 'not-existent'");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        RequiredActionProviderRepresentation rep = this.authMgmtResource.getRequiredAction("dummy-action");
        this.compareRequiredAction(rep, this.newRequiredAction("dummy-action", "Dummy Action", true, false, Collections.emptyMap()));
        Assertions.assertEquals((int)(lastPriority + 1), (int)rep.getPriority());
        try {
            this.authMgmtResource.updateRequiredAction("not-existent", rep);
            Assertions.fail((String)"Not expected to update not-existent requiredAction");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        rep.setDefaultAction(true);
        this.authMgmtResource.updateRequiredAction("dummy-action", rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRequiredActionPath((String)rep.getAlias()), (Object)rep, (ResourceType)ResourceType.REQUIRED_ACTION);
        this.compareRequiredAction(rep, this.newRequiredAction("dummy-action", "Dummy Action", true, true, Collections.emptyMap()));
        try {
            this.authMgmtResource.removeRequiredAction("not-existent");
            Assertions.fail((String)"Not expected to remove not-existent requiredAction");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.removeRequiredAction("dummy-action");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authRequiredActionPath((String)rep.getAlias()), (ResourceType)ResourceType.REQUIRED_ACTION);
    }

    @Test
    public void testConfigurableRequiredActionMetadata() {
        String providerId = "configurable-test-action";
        RequiredActionConfigInfoRepresentation requiredActionConfigDescription = this.authMgmtResource.getRequiredActionConfigDescription(providerId);
        Assertions.assertNotNull((Object)requiredActionConfigDescription);
        Assertions.assertNotNull((Object)requiredActionConfigDescription.getProperties());
        Assertions.assertEquals((int)3, (int)requiredActionConfigDescription.getProperties().size());
    }

    @Test
    public void testCRUDConfigurableRequiredAction() {
        int lastPriority = ((RequiredActionProviderRepresentation)this.authMgmtResource.getRequiredActions().get(this.authMgmtResource.getRequiredActions().size() - 1)).getPriority();
        List result = this.authMgmtResource.getUnregisteredRequiredActions();
        Assertions.assertEquals((int)2, (int)result.size());
        String providerId = "configurable-test-action";
        RequiredActionProviderSimpleRepresentation action = result.stream().filter(a -> providerId.equals(a.getProviderId())).findFirst().get();
        Assertions.assertEquals((Object)providerId, (Object)action.getProviderId());
        Assertions.assertEquals((Object)"Configurable Test Action", (Object)action.getName());
        this.authMgmtResource.registerRequiredAction(action);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)(AdminEventPaths.authMgmtBasePath() + "/register-required-action"), (Object)action, (ResourceType)ResourceType.REQUIRED_ACTION);
        RequiredActionConfigRepresentation requiredActionConfigRep = new RequiredActionConfigRepresentation();
        Map newActionConfig = Map.ofEntries(Map.entry("setting1", "value1"), Map.entry("setting2", "false"));
        requiredActionConfigRep.setConfig(newActionConfig);
        this.authMgmtResource.updateRequiredActionConfig(providerId, requiredActionConfigRep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRequiredActionConfigPath((String)providerId), (ResourceType)ResourceType.REQUIRED_ACTION_CONFIG);
        RequiredActionConfigRepresentation savedRequiredActionConfigRep = this.authMgmtResource.getRequiredActionConfig(providerId);
        Assertions.assertNotNull((Object)savedRequiredActionConfigRep);
        Assertions.assertNotNull((Object)savedRequiredActionConfigRep.getConfig());
        Assertions.assertTrue((boolean)savedRequiredActionConfigRep.getConfig().entrySet().containsAll(newActionConfig.entrySet()));
        this.authMgmtResource.removeRequiredActionConfig(providerId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authRequiredActionConfigPath((String)providerId), (ResourceType)ResourceType.REQUIRED_ACTION_CONFIG);
        RequiredActionProviderRepresentation rep = this.authMgmtResource.getRequiredAction(providerId);
        this.authMgmtResource.removeRequiredAction(providerId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.authRequiredActionPath((String)rep.getAlias()), (ResourceType)ResourceType.REQUIRED_ACTION);
        try {
            this.authMgmtResource.getRequiredActionConfig(providerId);
        }
        catch (Exception ex) {
            Assertions.assertTrue((boolean)NotFoundException.class.isInstance(ex));
        }
    }

    private RequiredActionProviderRepresentation findRequiredActionByAlias(String alias, List<RequiredActionProviderRepresentation> list) {
        for (RequiredActionProviderRepresentation a : list) {
            if (!alias.equals(a.getAlias())) continue;
            return a;
        }
        return null;
    }

    private List<RequiredActionProviderRepresentation> sort(List<RequiredActionProviderRepresentation> list) {
        ArrayList<RequiredActionProviderRepresentation> sorted = new ArrayList<RequiredActionProviderRepresentation>(list);
        Collections.sort(sorted, new RequiredActionProviderComparator());
        return sorted;
    }

    private void compareRequiredActions(List<RequiredActionProviderRepresentation> expected, List<RequiredActionProviderRepresentation> actual) {
        Assertions.assertNotNull(actual, (String)"Actual null");
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Required actions count");
        Iterator<RequiredActionProviderRepresentation> ite = expected.iterator();
        Iterator<RequiredActionProviderRepresentation> ita = actual.iterator();
        while (ite.hasNext()) {
            this.compareRequiredAction(ite.next(), ita.next());
        }
    }

    private void compareRequiredAction(RequiredActionProviderRepresentation expected, RequiredActionProviderRepresentation actual) {
        Assertions.assertEquals((Object)expected.getAlias(), (Object)actual.getAlias(), (String)("alias - " + expected.getAlias()));
        Assertions.assertEquals((Object)expected.getName(), (Object)actual.getName(), (String)("name - " + expected.getAlias()));
        Assertions.assertEquals((Object)expected.isEnabled(), (Object)actual.isEnabled(), (String)("enabled - " + expected.getAlias()));
        Assertions.assertEquals((Object)expected.isDefaultAction(), (Object)actual.isDefaultAction(), (String)("defaultAction - " + expected.getAlias()));
        Assertions.assertEquals((Object)(expected.getConfig() != null ? expected.getConfig() : Collections.emptyMap()), (Object)actual.getConfig(), (String)("config - " + expected.getAlias()));
    }

    private void addRequiredAction(List<RequiredActionProviderRepresentation> target, String alias, String name, boolean enabled, boolean defaultAction, Map<String, String> conf) {
        target.add(this.newRequiredAction(alias, name, enabled, defaultAction, conf));
    }

    private RequiredActionProviderRepresentation newRequiredAction(String alias, String name, boolean enabled, boolean defaultAction, Map<String, String> conf) {
        RequiredActionProviderRepresentation action = new RequiredActionProviderRepresentation();
        action.setAlias(alias);
        action.setName(name);
        action.setEnabled(enabled);
        action.setDefaultAction(defaultAction);
        action.setConfig(conf);
        return action;
    }

    private static class RequiredActionProviderComparator
    implements Comparator<RequiredActionProviderRepresentation> {
        private RequiredActionProviderComparator() {
        }

        @Override
        public int compare(RequiredActionProviderRepresentation o1, RequiredActionProviderRepresentation o2) {
            return o1.getAlias().compareTo(o2.getAlias());
        }
    }

    public static class CustomProvidersServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.dependency("org.keycloak.tests", "keycloak-tests-custom-providers");
        }
    }
}

