/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class ShiftExecutionTest
extends AbstractAuthenticationTest {
    @Test
    public void testShiftExecution() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "Copy of browser");
        Response response = this.authMgmtResource.copy("browser", params);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.authCopyFlowPath((String)"browser"), params, (ResourceType)ResourceType.AUTH_FLOW);
        try {
            Assertions.assertEquals((int)201, (int)response.getStatus(), (String)"Copy flow");
        }
        finally {
            response.close();
        }
        List executions = this.authMgmtResource.getExecutions("Copy of browser");
        AuthenticationExecutionInfoRepresentation last = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 1);
        AuthenticationExecutionInfoRepresentation oneButLast = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 2);
        try {
            this.authMgmtResource.raisePriority("not-existent");
            Assertions.fail((String)"Not expected to raise priority of not existent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.raisePriority(last.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRaiseExecutionPath((String)last.getId()), (ResourceType)ResourceType.AUTH_EXECUTION);
        List executions2 = this.authMgmtResource.getExecutions("Copy of browser");
        AuthenticationExecutionInfoRepresentation last2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 1);
        AuthenticationExecutionInfoRepresentation oneButLast2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 2);
        Assertions.assertEquals((Object)last.getId(), (Object)oneButLast2.getId(), (String)"Execution shifted up - N");
        Assertions.assertEquals((Object)oneButLast.getId(), (Object)last2.getId(), (String)"Execution shifted up - N-1");
        try {
            this.authMgmtResource.lowerPriority("not-existent");
            Assertions.fail((String)"Not expected to raise priority of not existent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.lowerPriority(oneButLast2.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authLowerExecutionPath((String)oneButLast2.getId()), (ResourceType)ResourceType.AUTH_EXECUTION);
        executions2 = this.authMgmtResource.getExecutions("Copy of browser");
        last2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 1);
        oneButLast2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 2);
        Assertions.assertEquals((Object)last.getId(), (Object)last2.getId(), (String)"Execution shifted down - N");
        Assertions.assertEquals((Object)oneButLast.getId(), (Object)oneButLast2.getId(), (String)"Execution shifted down - N-1");
    }

    @Test
    public void testBuiltinShiftNotAllowed() {
        List executions = this.authMgmtResource.getExecutions("browser");
        AuthenticationExecutionInfoRepresentation last = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 1);
        AuthenticationExecutionInfoRepresentation oneButLast = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 2);
        try {
            this.authMgmtResource.raisePriority(last.getId());
            Assertions.fail((String)"Not expected to raise priority of builtin flow");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        try {
            this.authMgmtResource.lowerPriority(oneButLast.getId());
            Assertions.fail((String)"Not expected to lower priority of builtin flow");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
    }
}

