/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authentication;

import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class ShiftRequiredActionTest
extends AbstractAuthenticationTest {
    @Test
    public void testShiftRequiredAction() {
        List actions = this.authMgmtResource.getRequiredActions();
        RequiredActionProviderRepresentation last = (RequiredActionProviderRepresentation)actions.get(actions.size() - 1);
        RequiredActionProviderRepresentation oneButLast = (RequiredActionProviderRepresentation)actions.get(actions.size() - 2);
        try {
            this.authMgmtResource.raisePriority("not-existent");
            Assertions.fail((String)"Not expected to raise priority of not existent required action");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.raiseRequiredActionPriority(last.getAlias());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRaiseRequiredActionPath((String)last.getAlias()), (ResourceType)ResourceType.REQUIRED_ACTION);
        List actions2 = this.authMgmtResource.getRequiredActions();
        RequiredActionProviderRepresentation last2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 1);
        RequiredActionProviderRepresentation oneButLast2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 2);
        Assertions.assertEquals((Object)last.getAlias(), (Object)oneButLast2.getAlias(), (String)"Required action shifted up - N");
        Assertions.assertEquals((Object)oneButLast.getAlias(), (Object)last2.getAlias(), (String)"Required action up - N-1");
        try {
            this.authMgmtResource.lowerRequiredActionPriority("not-existent");
            Assertions.fail((String)"Not expected to raise priority of not existent required action");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.lowerRequiredActionPriority(oneButLast2.getAlias());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authLowerRequiredActionPath((String)oneButLast2.getAlias()), (ResourceType)ResourceType.REQUIRED_ACTION);
        actions2 = this.authMgmtResource.getRequiredActions();
        last2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 1);
        oneButLast2 = (RequiredActionProviderRepresentation)actions2.get(actions.size() - 2);
        Assertions.assertEquals((Object)last.getAlias(), (Object)last2.getAlias(), (String)"Required action shifted down - N");
        Assertions.assertEquals((Object)oneButLast.getAlias(), (Object)oneButLast2.getAlias(), (String)"Required action shifted down - N-1");
    }
}

