/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.AggregatePolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientScopePolicyRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.RegexPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.TimePolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class ClientResourceTypeEvaluationTest
extends AbstractPermissionTest {
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;
    @InjectClient(ref="realmClient")
    ManagedClient realmClient;
    private final String clientsType = AdminPermissionsSchema.CLIENTS.getType();

    @Test
    public void testUnsupportedPolicyTypes() {
        this.assertSupportForPolicyType("resource", () -> ClientResourceTypeEvaluationTest.getPermissionsResource(this.client).resource().create(new ResourcePermissionRepresentation()), false);
    }

    @Test
    public void testSupportedPolicyTypes() {
        this.assertSupportForPolicyType("scope", () -> ClientResourceTypeEvaluationTest.getPermissionsResource(this.client).scope().create(AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.USERS.getType()).scopes(AdminPermissionsSchema.USERS.getScopes()).build()), true);
        this.assertSupportForPolicyType("user", () -> this.getPolicies().user().create(new UserPolicyRepresentation()), true);
        this.assertSupportForPolicyType("client", () -> this.getPolicies().client().create(new ClientPolicyRepresentation()), true);
        this.assertSupportForPolicyType("group", () -> this.getPolicies().group().create(new GroupPolicyRepresentation()), true);
        this.assertSupportForPolicyType("role", () -> this.getPolicies().role().create(new RolePolicyRepresentation()), true);
        this.assertSupportForPolicyType("aggregate", () -> this.getPolicies().aggregate().create(new AggregatePolicyRepresentation()), true);
        this.assertSupportForPolicyType("client-scope", () -> this.getPolicies().clientScope().create(new ClientScopePolicyRepresentation()), true);
        this.assertSupportForPolicyType("js", () -> this.getPolicies().js().create(new JSPolicyRepresentation()), true);
        this.assertSupportForPolicyType("regex", () -> this.getPolicies().regex().create(new RegexPolicyRepresentation()), true);
        this.assertSupportForPolicyType("time", () -> this.getPolicies().time().create(new TimePolicyRepresentation()), true);
    }

    private void assertSupportForPolicyType(String type, Supplier<Response> operation, boolean supported) {
        try (Response response = operation.get();){
            this.assertPolicyEndpointResponse(type, supported, response);
        }
        PolicyRepresentation representation = new PolicyRepresentation();
        representation.setType(type);
        try (Response response = this.getPolicies().create(representation);){
            this.assertPolicyEndpointResponse(type, supported, response);
        }
    }

    private void assertPolicyEndpointResponse(String type, boolean supported, Response response) {
        MatcherAssert.assertThat((String)("Policy type [" + type + "] should be " + (supported ? "supported" : "unsupported")), (Object)Response.Status.BAD_REQUEST.equals((Object)Response.Status.fromStatusCode((int)response.getStatus())), (Matcher)CoreMatchers.not((Object)supported));
        MatcherAssert.assertThat((String)("Policy type [" + type + "] should be " + (supported ? "supported" : "unsupported")), (Object)((String)response.readEntity(String.class)).contains("Policy type not supported by feature"), (Matcher)CoreMatchers.not((Object)supported));
    }

    @Test
    public void testManageOnlyOneClient() {
        ClientRepresentation myclient = (ClientRepresentation)this.realm.admin().clients().findByClientId("myclient").get(0);
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientResource clientResource = this.realmAdminClient.realm(this.realm.getName()).clients().get(myclient.getId());
        try {
            clientResource.toRepresentation();
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        try {
            myclient.setName("somethingNew");
            clientResource.update(myclient);
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        try {
            ClientScopeRepresentation clientScopeRep = (ClientScopeRepresentation)clientResource.getDefaultClientScopes().get(1);
            clientResource.removeDefaultClientScope(clientScopeRep.getId());
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, myclient.getId(), this.clientsType, Set.of("view", "manage"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        clientResource.toRepresentation();
        List allClients = this.realmAdminClient.realm(this.realm.getName()).clients().findAll();
        MatcherAssert.assertThat((Object)allClients, (Matcher)Matchers.hasSize((int)1));
        myclient.setName("somethingNew");
        clientResource.update(myclient);
        List defaultClientScopes = clientResource.getDefaultClientScopes();
        MatcherAssert.assertThat((Object)defaultClientScopes, (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
        ClientScopeRepresentation clientScopeRep = (ClientScopeRepresentation)defaultClientScopes.get(1);
        clientResource.removeDefaultClientScope(clientScopeRep.getId());
        clientResource.addOptionalClientScope(clientScopeRep.getId());
        ClientRepresentation realmClientRep = this.realm.admin().clients().get(this.realmClient.getId()).toRepresentation();
        realmClientRep.setName("somethingNew");
        try {
            this.realmAdminClient.realm(this.realm.getName()).clients().get(this.realmClient.getId()).update(realmClientRep);
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
    }

    @Test
    public void testManageAllClients() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setClientId("newClient");
        newClient.setProtocol("openid-connect");
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).clients().create(newClient);){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        List found = this.realmAdminClient.realm(this.realm.getName()).clients().findAll();
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.empty());
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        ClientResourceTypeEvaluationTest.createAllPermission(this.client, this.clientsType, (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, Set.of("view", "manage"));
        this.realmAdminClient.realm(this.realm.getName()).clients().create(newClient).close();
        found = this.realmAdminClient.realm(this.realm.getName()).clients().findByClientId("newClient");
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.hasSize((int)1));
        this.realmAdminClient.realm(this.realm.getName()).clients().get(((ClientRepresentation)found.get(0)).getId()).remove();
        found = this.realmAdminClient.realm(this.realm.getName()).clients().findByClientId("newClient");
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.empty());
        found = this.realmAdminClient.realm(this.realm.getName()).clients().findAll();
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void testViewAllClients() {
        ClientRepresentation myclient = (ClientRepresentation)this.realm.admin().clients().findByClientId("myclient").get(0);
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        try {
            this.realmAdminClient.realm(this.realm.getName()).clients().get(myclient.getId()).getProtocolMappers().getMappers();
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        List found = this.realmAdminClient.realm(this.realm.getName()).clients().findAll(true);
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.empty());
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        ClientResourceTypeEvaluationTest.createAllPermission(this.client, this.clientsType, (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, Set.of("view"));
        found = this.realmAdminClient.realm(this.realm.getName()).clients().findAll(true);
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
        ProtocolMapperRepresentation protocolMapperRep = new ProtocolMapperRepresentation();
        protocolMapperRep.setName("my-protocol-mapper");
        protocolMapperRep.setProtocol("openid-connect");
        protocolMapperRep.setProtocolMapper("oidc-hardcoded-claim-mapper");
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).clients().get(myclient.getId()).getProtocolMappers().createMapper(protocolMapperRep);){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).clients().get(myclient.getId()).getProtocolMappers().getMappers(), (Matcher)Matchers.empty());
        response = this.realmAdminClient.realm(this.realm.getName()).clients().create(null);
        try {
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testCreateClientsRequireManageScope() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setClientId(KeycloakModelUtils.generateId());
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).clients().create(newClient);){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        List found = this.realmAdminClient.realm(this.realm.getName()).clients().findAll(true);
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.empty());
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        ScopePermissionRepresentation allPermission = ClientResourceTypeEvaluationTest.createAllPermission(this.client, this.clientsType, (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, AdminPermissionsSchema.CLIENTS.getScopes().stream().filter(Predicate.not("manage"::equals)).collect(Collectors.toSet()));
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).clients().create(newClient);){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        allPermission = ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(allPermission.getName());
        allPermission.setScopes(Set.of("view", "manage"));
        ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allPermission.getId()).update(allPermission);
        response = this.realmAdminClient.realm(this.realm.getName()).clients().create(newClient);
        try {
            Assertions.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        found = this.realmAdminClient.realm(this.realm.getName()).clients().findByClientId(newClient.getClientId());
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void testMapRolesOnlyOneClient() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientRepresentation myclient = (ClientRepresentation)this.realm.admin().clients().findByClientId("myclient").get(0);
        RoleRepresentation role = new RoleRepresentation();
        role.setName("myclient-role");
        role.setClientRole(Boolean.valueOf(true));
        this.realm.admin().clients().get(myclient.getId()).roles().create(role);
        role = this.realm.admin().clients().get(myclient.getId()).roles().get("myclient-role").toRepresentation();
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(myadmin.getId()).roles().clientLevel(myclient.getId()).add(List.of(role));
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, myadmin.getId(), "Users", Set.of("map-roles"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        this.createPermission(this.client, myclient.getId(), this.clientsType, Set.of("map-roles"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        this.realmAdminClient.realm(this.realm.getName()).users().get(myadmin.getId()).roles().clientLevel(myclient.getId()).add(List.of(role));
    }

    @Test
    public void testMapCompositesToAnotherClientRole() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientRepresentation myclient = (ClientRepresentation)this.realm.admin().clients().findByClientId("myclient").get(0);
        RoleRepresentation roleA = new RoleRepresentation();
        roleA.setName("roleA");
        roleA.setClientRole(Boolean.valueOf(true));
        this.realm.admin().clients().get(myclient.getId()).roles().create(roleA);
        roleA = this.realm.admin().clients().get(myclient.getId()).roles().get("roleA").toRepresentation();
        RoleRepresentation roleB = new RoleRepresentation();
        roleB.setName("roleB");
        roleB.setClientRole(Boolean.valueOf(true));
        this.realm.admin().clients().get(this.realmClient.getId()).roles().create(roleB);
        try {
            this.realmAdminClient.realm(this.realm.getName()).clients().get(this.realmClient.getId()).roles().get("roleB").addComposites(List.of(roleA));
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, myclient.getId(), this.clientsType, Set.of("map-roles-composite"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        try {
            this.realmAdminClient.realm(this.realm.getName()).clients().get(this.realmClient.getId()).roles().get("roleB").addComposites(List.of(roleA));
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        this.createPermission(this.client, this.realmClient.getId(), this.clientsType, Set.of("manage"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        this.realmAdminClient.realm(this.realm.getName()).clients().get(this.realmClient.getId()).roles().get("roleB").addComposites(List.of(roleA));
    }

    @Test
    public void testEvaluateAllResourcePermissionsForSpecificResourcePermission() {
        ClientRepresentation myclient = (ClientRepresentation)this.realm.admin().clients().findByClientId("myclient").get(0);
        UserRepresentation adminUser = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin", adminUser.getId());
        ScopePermissionRepresentation allResourcesPermission = ClientResourceTypeEvaluationTest.createAllPermission(this.client, this.clientsType, (AbstractPolicyRepresentation)allowPolicy, Set.of("manage", "map-roles"));
        ClientsResource clients = this.realmAdminClient.realm(this.realm.getName()).clients();
        clients.get(myclient.getId()).update(myclient);
        ScopePermissionRepresentation resourcePermission = this.createPermission(this.client, myclient.getId(), this.clientsType, Set.of("manage"), new AbstractPolicyRepresentation[]{allowPolicy});
        clients.get(myclient.getId()).update(myclient);
        allResourcesPermission = ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(allResourcesPermission.getName());
        allResourcesPermission.setScopes(Set.of("map-roles"));
        ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allResourcesPermission.getId()).update(allResourcesPermission);
        clients.get(myclient.getId()).update(myclient);
        resourcePermission = ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(resourcePermission.getName());
        resourcePermission.setScopes(Set.of("map-roles"));
        ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(resourcePermission.getId()).update(resourcePermission);
        try {
            clients.get(myclient.getId()).update(myclient);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        allResourcesPermission.setScopes(Set.of("manage"));
        ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allResourcesPermission.getId()).update(allResourcesPermission);
        clients.get(myclient.getId()).update(myclient);
        UserPolicyRepresentation notAllowPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin", adminUser.getId());
        this.createPermission(this.client, myclient.getId(), this.clientsType, Set.of("manage"), new AbstractPolicyRepresentation[]{notAllowPolicy});
        try {
            clients.get(myclient.getId()).update(myclient);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        resourcePermission = ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(resourcePermission.getName());
        resourcePermission.setScopes(Set.of("map-roles", "manage"));
        ClientResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(resourcePermission.getId()).update(resourcePermission);
        try {
            clients.get(myclient.getId()).update(myclient);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
    }

    @Test
    public void testManageClientWithAuthorizationSettings() {
        ClientRepresentation myResourceServer = (ClientRepresentation)this.realm.admin().clients().findByClientId("myresourceserver").get(0);
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientResource clientResource = this.realmAdminClient.realm(this.realm.getName()).clients().get(myResourceServer.getId());
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, myResourceServer.getId(), this.clientsType, Set.of("view", "manage"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        myResourceServer.setName("somethingNew");
        clientResource.update(myResourceServer);
    }
}

