/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class ClientResourceTypeFilteringTest
extends AbstractPermissionTest {
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;

    @BeforeEach
    public void onBeforeEach() {
        for (int i = 0; i < 50; ++i) {
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId("client-" + i);
            client.setName(client.getClientId());
            client.setEnabled(Boolean.valueOf(true));
            client.setProtocol("openid-connect");
            client.setPublicClient(Boolean.valueOf(false));
            client.setSecret("secret");
            client.setAttributes(Map.of("saml.artifact.binding.identifier", "value"));
            this.realm.admin().clients().create(client).close();
        }
    }

    @Test
    public void testViewAllClientsUsingUserPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).clients().findAll();
        Assertions.assertTrue((boolean)search.isEmpty());
        UserPolicyRepresentation policy = ClientResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        ClientResourceTypeFilteringTest.createAllPermission(this.client, "Clients", (AbstractPolicyRepresentation)policy, Set.of("view"));
        search = this.realmAdminClient.realm(this.realm.getName()).clients().findAll();
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)59, (int)search.size());
    }

    @Test
    public void testViewSpecificClientsUsingUserPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).clients().findAll();
        Assertions.assertTrue((boolean)search.isEmpty());
        UserPolicyRepresentation policy = ClientResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        ClientResourceTypeFilteringTest.createAllPermission(this.client, "Clients", (AbstractPolicyRepresentation)policy, Set.of("view"));
        search = this.realmAdminClient.realm(this.realm.getName()).clients().findAll("client-", Boolean.valueOf(true), Boolean.valueOf(true), null, null);
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)50, (int)search.size());
    }

    @Test
    public void testViewClientsByAttributeUsingUserPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).clients().findAll();
        Assertions.assertTrue((boolean)search.isEmpty());
        UserPolicyRepresentation policy = ClientResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        ClientResourceTypeFilteringTest.createAllPermission(this.client, "Clients", (AbstractPolicyRepresentation)policy, Set.of("view"));
        search = this.realmAdminClient.realm(this.realm.getName()).clients().query("saml.artifact.binding.identifier:\"value\"");
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)50, (int)search.size());
    }

    @Test
    public void testDeniedResourcesPrecedenceOverGrantedResources() {
        UserPolicyRepresentation policy = ClientResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        ClientResourceTypeFilteringTest.createAllPermission(this.client, "Clients", (AbstractPolicyRepresentation)policy, Set.of("view"));
        List search = this.realmAdminClient.realm(this.realm.getName()).clients().findAll("client-", Boolean.valueOf(true), Boolean.valueOf(true), null, null);
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)50, (int)search.size());
        UserPolicyRepresentation notMyAdminPolicy = ClientResourceTypeFilteringTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        Set<String> notAllowedClients = search.stream().filter(g -> Set.of("client-0", "client-15", "client-30", "client-45").contains(g.getClientId())).map(ClientRepresentation::getId).collect(Collectors.toSet());
        Assertions.assertFalse((boolean)notAllowedClients.isEmpty());
        this.createPermission(this.client, notAllowedClients, "Clients", Set.of("view"), new AbstractPolicyRepresentation[]{notMyAdminPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).clients().findAll("client-", Boolean.valueOf(true), Boolean.valueOf(true), null, null);
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertTrue((boolean)search.stream().map(ClientRepresentation::getId).noneMatch(notAllowedClients::contains));
    }

    @Test
    public void testSearchByClientId() {
        String expectedClientId = "client-0";
        List search = this.realmAdminClient.realm(this.realm.getName()).clients().findByClientId(expectedClientId);
        Assertions.assertTrue((boolean)search.isEmpty());
        UserPolicyRepresentation allowPolicy = ClientResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, expectedClientId, "Clients", Set.of("view"), new AbstractPolicyRepresentation[]{allowPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).clients().findByClientId(expectedClientId);
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
        Assertions.assertEquals((Object)((ClientRepresentation)search.get(0)).getClientId(), (Object)expectedClientId);
    }
}

