/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ScopePermissionResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class ClientResourceTypePermissionTest
extends AbstractPermissionTest {
    @InjectClient(ref="testClient")
    ManagedClient testClient;
    @InjectClient(ref="testClient2", lifecycle=LifeCycle.METHOD)
    ManagedClient testClient2;

    @BeforeEach
    public void onBefore() {
        UserPolicyRepresentation policy = new UserPolicyRepresentation();
        policy.setName("User Policy");
        this.client.admin().authorization().policies().user().create(policy).close();
    }

    @Test
    public void testCreateResourceTypePermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        ScopePermissionRepresentation expected = ClientResourceTypePermissionTest.createAllPermission(this.client, "Clients", (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, AdminPermissionsSchema.CLIENTS.getScopes());
        List result = ClientResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = ClientResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.CLIENTS.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)1, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)"Clients", (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testCreateResourceObjectPermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation onlyMyAdminUserPolicy = ClientResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        ClientRepresentation client = (ClientRepresentation)this.realm.admin().clients().findAll().get(0);
        ScopePermissionRepresentation expected = this.createPermission(this.client, client.getId(), "Clients", (Set<String>)AdminPermissionsSchema.CLIENTS.getScopes(), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        List result = ClientResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = ClientResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.CLIENTS.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)1, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)client.getClientId(), (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testRemoveClient() {
        ClientResourceTypePermissionTest.createClientPolicy(this.realm, this.client, "Only testClient or testClient2 Client Policy", this.testClient.getId(), this.testClient2.getId());
        ClientResourceTypePermissionTest.createClientPolicy(this.realm, this.client, "Only testClient2 Client Policy", this.testClient2.getId());
        this.createClientPermission(this.testClient, this.testClient2);
        this.createClientPermission(this.testClient2);
        List policies = this.getPolicies().policies(null, "Only", "client", null, null, null, null, null, null, null);
        MatcherAssert.assertThat((Object)policies, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(0)).getConfig().get("clients")), (Matcher)Matchers.containsString((String)this.testClient2.getId()));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(1)).getConfig().get("clients")), (Matcher)Matchers.containsString((String)this.testClient2.getId()));
        List permissions = ClientResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)this.testClient2.getId()));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(1)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)this.testClient2.getId()));
        this.realm.admin().clients().get(this.testClient2.getId()).remove();
        ClientPolicyRepresentation clientPolicy = this.getPolicies().client().findByName("Only testClient or testClient2 Client Policy");
        MatcherAssert.assertThat((Object)clientPolicy, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)clientPolicy.getClients(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{this.testClient2.getId()})));
        ClientPolicyRepresentation clientPolicy1 = this.getPolicies().client().findByName("Only testClient2 Client Policy");
        MatcherAssert.assertThat((Object)clientPolicy1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)clientPolicy1.getClients(), (Matcher)Matchers.empty());
        permissions = ClientResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.testClient2.getId())));
    }

    private ScopePermissionRepresentation createClientPermission(ManagedClient ... clients) {
        ScopePermissionRepresentation permission = AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.CLIENTS.getType()).resources(Arrays.stream(clients).map(ManagedClient::getClientId).collect(Collectors.toSet())).scopes(AdminPermissionsSchema.CLIENTS.getScopes()).addPolicies(List.of("User Policy")).build();
        ClientResourceTypePermissionTest.createPermission(this.client, permission);
        return permission;
    }
}

