/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.admin.authz.fgap.AuthzClientConfig;

@KeycloakIntegrationTest
public class FeatureV2EnabledTest {
    @InjectRealm
    private ManagedRealm realm;
    @InjectClient(config=AuthzClientConfig.class)
    private ManagedClient testClient;

    @Test
    public void schemaNotAvailableForNonAdminPermissionClient() {
        ResourceServerRepresentation authorizationSettings = this.testClient.admin().authorization().getSettings();
        MatcherAssert.assertThat((Object)authorizationSettings, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authorizationSettings.getAuthorizationSchema(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void schemaAvailableAfterFGAPEnabledForRealm() {
        MatcherAssert.assertThat((Object)this.realm.admin().clients().findByClientId("admin-permissions"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        RealmRepresentation realmRep = this.realm.admin().toRepresentation();
        realmRep.setAdminPermissionsEnabled(Boolean.TRUE);
        this.realm.admin().update(realmRep);
        List clients = this.realm.admin().clients().findByClientId("admin-permissions");
        MatcherAssert.assertThat((Object)clients, (Matcher)Matchers.hasSize((int)1));
        ResourceServerRepresentation authorizationSettings = this.realm.admin().clients().get(((ClientRepresentation)clients.get(0)).getId()).authorization().getSettings();
        MatcherAssert.assertThat((Object)authorizationSettings, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authorizationSettings.getAuthorizationSchema(), (Matcher)Matchers.notNullValue());
    }
}

