/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class FineGrainedPermissionsUsersTest
extends AbstractPermissionTest {
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;

    private void assertSearchMatchesCount(RealmResource realmResource, String search, Integer expectedCount) {
        Integer count = realmResource.users().count(search);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)expectedCount));
        MatcherAssert.assertThat((Object)realmResource.users().search(search, null, null), (Matcher)Matchers.hasSize((int)count));
    }

    @Test
    public void countUsersWithGroupViewPermission() {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void countUsersBySearchWithGroupViewPermission() {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        this.assertSearchMatchesCount(testRealmResource, "user", 3);
        this.assertSearchMatchesCount(testRealmResource, "*FirstName*", 3);
        this.assertSearchMatchesCount(testRealmResource, "user2FirstName", 1);
        this.assertSearchMatchesCount(testRealmResource, "*LastName*", 3);
        this.assertSearchMatchesCount(testRealmResource, "user2LastName", 1);
        this.assertSearchMatchesCount(testRealmResource, "*@example.com*", 3);
        this.assertSearchMatchesCount(testRealmResource, "user1@example.com", 1);
        this.assertSearchMatchesCount(testRealmResource, "notExisting", 0);
        this.assertSearchMatchesCount(testRealmResource, "", 3);
        this.assertSearchMatchesCount(testRealmResource, null, 3);
    }

    @Test
    public void countUsersByFiltersWithGroupViewPermission() {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)Matchers.equalTo((Object)testRealmResource.users().search("user", null, null, null, null, null).size()));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void countUsersWithNoViewPermission() {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void countUsersBySearchWithNoViewPermission() {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        this.assertSearchMatchesCount(testRealmResource, "user", 0);
        this.assertSearchMatchesCount(testRealmResource, "FirstName", 0);
        this.assertSearchMatchesCount(testRealmResource, "user2FirstName", 0);
        this.assertSearchMatchesCount(testRealmResource, "LastName", 0);
        this.assertSearchMatchesCount(testRealmResource, "user2LastName", 0);
        this.assertSearchMatchesCount(testRealmResource, "@example.com", 0);
        this.assertSearchMatchesCount(testRealmResource, "user1@example.com", 0);
        this.assertSearchMatchesCount(testRealmResource, "notExisting", 0);
        this.assertSearchMatchesCount(testRealmResource, "", 0);
        this.assertSearchMatchesCount(testRealmResource, null, 0);
    }

    @Test
    public void countUsersByFiltersWithNoViewPermission() {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)0));
    }

    private RealmResource setupTestEnvironmentWithPermissions(boolean grp1ViewPermissions) {
        UserRepresentation user = UserConfigBuilder.create().username("test-user").password("password").name("a", "b").email("c@d.com").enabled(true).build();
        String testUserId = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user));
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.realm.admin().clients().findByClientId("realm-management").get(0);
        String realmManagementId = clientRepresentation.getId();
        RoleRepresentation roleRepresentation = this.realm.admin().clients().get(realmManagementId).roles().get("query-users").toRepresentation();
        this.realm.admin().users().get(testUserId).roles().clientLevel(realmManagementId).add(Collections.singletonList(roleRepresentation));
        this.realm.cleanup().add(r -> r.users().get(testUserId).remove());
        List<GroupRepresentation> groups = this.setupUsersInGroups();
        if (grp1ViewPermissions) {
            UserPolicyRepresentation userPolicy = FineGrainedPermissionsUsersTest.createUserPolicy(this.realm, this.client, "allow-test-user", testUserId);
            this.createGroupPermission(groups.get(0), Set.of("view"), userPolicy);
        }
        Keycloak testUserClient = KeycloakBuilder.builder().serverUrl(this.keycloakUrls.getBaseUrl().toString()).realm(this.realm.getName()).username("test-user").password("password").clientId("admin-cli").clientSecret("").build();
        return testUserClient.realm(this.realm.getCreatedRepresentation().getRealm());
    }

    private List<GroupRepresentation> setupUsersInGroups() {
        GroupRepresentation grp1 = this.createGroup("grp1");
        GroupRepresentation grp2 = this.createGroup("grp2");
        UserRepresentation user1 = UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").enabled(true).build();
        String user1Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user1));
        this.realm.cleanup().add(r -> r.users().get(user1Id).remove());
        UserRepresentation user2 = UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").enabled(true).build();
        String user2Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user2));
        this.realm.cleanup().add(r -> r.users().get(user2Id).remove());
        UserRepresentation user3 = UserConfigBuilder.create().username("user3").password("password").name("user3FirstName", "user3LastName").email("user3@example.com").enabled(true).build();
        String user3Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user3));
        this.realm.cleanup().add(r -> r.users().get(user3Id).remove());
        UserRepresentation user4 = UserConfigBuilder.create().username("user4").password("password").name("user4FirstName", "user4LastName").email("user4@example.com").enabled(true).build();
        String user4Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user4));
        this.realm.cleanup().add(r -> r.users().get(user4Id).remove());
        this.realm.admin().users().get(user1Id).joinGroup(grp1.getId());
        this.realm.admin().users().get(user2Id).joinGroup(grp1.getId());
        this.realm.admin().users().get(user3Id).joinGroup(grp1.getId());
        this.realm.admin().users().get(user4Id).joinGroup(grp2.getId());
        ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
        groups.add(grp1);
        groups.add(grp2);
        return groups;
    }

    private GroupRepresentation createGroup(String name) {
        GroupRepresentation grp = new GroupRepresentation();
        grp.setName(name);
        String groupId = ApiUtil.getCreatedId((Response)this.realm.admin().groups().add(grp));
        grp.setId(groupId);
        this.realm.cleanup().add(r -> r.groups().group(groupId).remove());
        return grp;
    }
}

