/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class GroupResourceTypeEvaluationTest
extends AbstractPermissionTest {
    @InjectUser(ref="alice")
    ManagedUser userAlice;
    @InjectUser(ref="jdoe")
    ManagedUser userJdoe;
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;
    private final String groupName = "top_group";
    private final GroupRepresentation topGroup = new GroupRepresentation();

    @BeforeEach
    public void onBefore() {
        this.topGroup.setName("top_group");
        try (Response response = this.realm.admin().groups().add(this.topGroup);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            this.topGroup.setId(ApiUtil.handleCreatedResponse((Response)response));
            this.realm.cleanup().add(r -> r.groups().group(this.topGroup.getId()).remove());
        }
        this.realm.admin().users().get(this.userAlice.getId()).joinGroup(this.topGroup.getId());
    }

    @Test
    public void testCanViewUserByViewGroupMembers() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertTrue((boolean)search.isEmpty());
        this.createGroupPermission(this.topGroup, Set.of("view-members"), allowMyAdminPermission);
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)search.size());
        Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((UserRepresentation)search.get(0)).getUsername());
    }

    @Test
    public void testCanViewUserByManageGroupMembers() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertTrue((boolean)search.isEmpty());
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).update(UserConfigBuilder.create().email("email@test.com").build());
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        this.createGroupPermission(this.topGroup, Set.of("view-members", "manage-members"), allowMyAdminPermission);
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)search.size());
        Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((UserRepresentation)search.get(0)).getUsername());
        this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).update(UserConfigBuilder.create().email("email@test.com").build());
        Assertions.assertEquals((Object)"email@test.com", (Object)this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).toRepresentation().getEmail());
    }

    @Test
    public void testManageAllGroups() {
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).groups().add(new GroupRepresentation());){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        response = this.realmAdminClient.realm(this.realm.getName()).groups().group(this.topGroup.getId()).subGroup(new GroupRepresentation());
        try {
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        try {
            this.realmAdminClient.realm(this.realm.getName()).groups().group(this.topGroup.getId()).roles().realmLevel().add(List.of());
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation policy = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createAllGroupsPermission(policy, Set.of("view", "manage"));
        GroupRepresentation group = new GroupRepresentation();
        group.setName("testGroup");
        String testGroupId = ApiUtil.handleCreatedResponse((Response)this.realmAdminClient.realm(this.realm.getName()).groups().add(group));
        group.setId(testGroupId);
        group.setName("newGroup");
        this.realmAdminClient.realm(this.realm.getName()).groups().group(testGroupId).update(group);
        Assertions.assertEquals((Object)"newGroup", (Object)this.realmAdminClient.realm(this.realm.getName()).groups().group(testGroupId).toRepresentation().getName());
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).groups().group(this.topGroup.getId()).subGroup(group);){
            Assertions.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)response.getStatus());
        }
        try {
            this.realmAdminClient.realm(this.realm.getName()).groups().group(this.topGroup.getId()).roles().realmLevel().add(List.of(new RoleRepresentation("non_existent", null, false)));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
    }

    @Test
    public void testManageGroup() {
        GroupRepresentation myGroup = new GroupRepresentation();
        myGroup.setName("my_group");
        try (Response response = this.realm.admin().groups().add(myGroup);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            myGroup.setId(ApiUtil.handleCreatedResponse((Response)response));
            this.realm.cleanup().add(r -> r.groups().group(myGroup.getId()).remove());
        }
        UserPolicyRepresentation policy = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createGroupPermission(myGroup, Set.of("view", "manage"), policy);
        try {
            this.realmAdminClient.realm(this.realm.getName()).groups().group(this.topGroup.getId()).update(myGroup);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        myGroup.setName("newGroup");
        this.realmAdminClient.realm(this.realm.getName()).groups().group(myGroup.getId()).update(myGroup);
        Assertions.assertEquals((Object)"newGroup", (Object)this.realmAdminClient.realm(this.realm.getName()).groups().group(myGroup.getId()).toRepresentation().getName());
        GroupRepresentation subGroup = new GroupRepresentation();
        subGroup.setName("subGroup");
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).groups().group(this.topGroup.getId()).subGroup(subGroup);){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        response = this.realmAdminClient.realm(this.realm.getName()).groups().group(myGroup.getId()).subGroup(subGroup);
        try {
            Assertions.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        try {
            this.realmAdminClient.realm(this.realm.getName()).groups().group(this.topGroup.getId()).roles().realmLevel().add(List.of(new RoleRepresentation("non_existent", null, false)));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        try {
            this.realmAdminClient.realm(this.realm.getName()).groups().group(myGroup.getId()).roles().realmLevel().add(List.of(new RoleRepresentation("non_existent", null, false)));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
    }

    @Test
    public void testViewGroups() {
        UserPolicyRepresentation policy = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        List search = this.realmAdminClient.realm(this.realm.getName()).groups().groups();
        MatcherAssert.assertThat((Object)search, (Matcher)Matchers.hasSize((int)0));
        GroupRepresentation myGroup = new GroupRepresentation();
        myGroup.setName("my_group");
        try (Response response = this.realm.admin().groups().add(myGroup);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            myGroup.setId(ApiUtil.handleCreatedResponse((Response)response));
            this.realm.cleanup().add(r -> r.groups().group(myGroup.getId()).remove());
        }
        this.createGroupPermission(myGroup, Set.of("view"), policy);
        search = this.realmAdminClient.realm(this.realm.getName()).groups().groups();
        MatcherAssert.assertThat((Object)search, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((GroupRepresentation)search.get(0)).getName(), (Matcher)Matchers.equalTo((Object)myGroup.getName()));
        this.createAllGroupsPermission(policy, Set.of("view"));
        search = this.realmAdminClient.realm(this.realm.getName()).groups().groups();
        MatcherAssert.assertThat((Object)search, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testManageGroupMembership() {
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).joinGroup("no-such");
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation policy = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createAllUserPermission(policy, Set.of("manage-group-membership"));
        this.createGroupPermission(this.topGroup, Set.of("manage-membership"), policy);
        String bobId = ApiUtil.handleCreatedResponse((Response)this.realm.admin().users().create(UserConfigBuilder.create().username("bob").build()));
        this.realm.cleanup().add(r -> r.users().delete(bobId));
        this.realmAdminClient.realm(this.realm.getName()).users().get(bobId).joinGroup(this.topGroup.getId());
    }

    @Test
    public void testCreateGroupMembers() {
        UserPolicyRepresentation policy = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createGroupPermission(this.topGroup, Set.of("view", "manage-membership", "manage-members"), policy);
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).users().create(UserConfigBuilder.create().username("bob").build());){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
        }
        response = this.realmAdminClient.realm(this.realm.getName()).users().create(UserConfigBuilder.create().username("bob").groups(new String[]{"different_group"}).build());
        try {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        String bobId = ApiUtil.handleCreatedResponse((Response)this.realmAdminClient.realm(this.realm.getName()).users().create(UserConfigBuilder.create().username("bob").groups(new String[]{"/top_group"}).build()));
        this.realm.cleanup().add(r -> r.users().delete(bobId));
    }

    @Test
    public void testEvaluateAllResourcePermissionsForSpecificResourcePermission() {
        UserRepresentation adminUser = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowPolicy = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin", adminUser.getId());
        ScopePermissionRepresentation allResourcesPermission = GroupResourceTypeEvaluationTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)allowPolicy, Set.of("manage", "manage-membership"));
        GroupsResource groups = this.realmAdminClient.realm(this.realm.getName()).groups();
        groups.group(this.topGroup.getId()).update(this.topGroup);
        ScopePermissionRepresentation resourcePermission = this.createPermission(this.client, this.topGroup.getId(), "Groups", Set.of("manage"), new AbstractPolicyRepresentation[]{allowPolicy});
        groups.group(this.topGroup.getId()).update(this.topGroup);
        allResourcesPermission = GroupResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(allResourcesPermission.getName());
        allResourcesPermission.setScopes(Set.of("manage-membership"));
        GroupResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allResourcesPermission.getId()).update(allResourcesPermission);
        groups.group(this.topGroup.getId()).update(this.topGroup);
        resourcePermission = GroupResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(resourcePermission.getName());
        resourcePermission.setScopes(Set.of("manage-membership"));
        GroupResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(resourcePermission.getId()).update(resourcePermission);
        try {
            groups.group(this.topGroup.getId()).update(this.topGroup);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        allResourcesPermission.setScopes(Set.of("manage"));
        GroupResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allResourcesPermission.getId()).update(allResourcesPermission);
        groups.group(this.topGroup.getId()).update(this.topGroup);
        UserPolicyRepresentation notAllowPolicy = GroupResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin", adminUser.getId());
        this.createPermission(this.client, this.topGroup.getId(), "Groups", Set.of("manage"), new AbstractPolicyRepresentation[]{notAllowPolicy});
        try {
            groups.group(this.topGroup.getId()).update(this.topGroup);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        resourcePermission = GroupResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(resourcePermission.getName());
        resourcePermission.setScopes(Set.of("manage"));
        GroupResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(resourcePermission.getId()).update(resourcePermission);
        try {
            groups.group(this.topGroup.getId()).update(this.topGroup);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
    }

    @Test
    public void testImpersonateMembers() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).impersonate();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        this.createGroupPermission(this.topGroup, Set.of("impersonate-members"), allowMyAdminPermission);
        this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).impersonate();
        this.realmAdminClient.tokenManager().logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImpersonateMembersFromChildGroups() {
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userJdoe.getId()).impersonate();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        GroupRepresentation subGroup = new GroupRepresentation();
        subGroup.setName("testSubGroup");
        String testGroupId = ApiUtil.handleCreatedResponse((Response)this.realm.admin().groups().add(subGroup));
        subGroup.setId(testGroupId);
        this.realm.admin().groups().group(this.topGroup.getId()).subGroup(subGroup).close();
        this.realm.admin().users().get(this.userJdoe.getId()).joinGroup(subGroup.getId());
        Assertions.assertTrue((boolean)this.userJdoe.admin().groups().stream().map(GroupRepresentation::getName).allMatch(subGroup.getName()::equals));
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = GroupResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createGroupPermission(this.topGroup, Set.of("impersonate-members"), allowMyAdminPermission);
        this.realmAdminClient.realm(this.realm.getName()).users().get(this.userJdoe.getId()).impersonate();
        this.realmAdminClient.tokenManager().logout();
        UserPolicyRepresentation denyPolicy = GroupResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Deny My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, this.userAlice.getId(), "Users", Set.of("impersonate"), new AbstractPolicyRepresentation[]{denyPolicy});
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).impersonate();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        finally {
            this.realmAdminClient.tokenManager().logout();
        }
        this.realmAdminClient.realm(this.realm.getName()).users().get(this.userJdoe.getId()).impersonate();
        this.realmAdminClient.tokenManager().logout();
    }

    private ScopePermissionRepresentation createAllGroupsPermission(UserPolicyRepresentation policy, Set<String> scopes) {
        return GroupResourceTypeEvaluationTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)policy, scopes);
    }

    private ScopePermissionRepresentation createAllUserPermission(UserPolicyRepresentation policy, Set<String> scopes) {
        return GroupResourceTypeEvaluationTest.createAllPermission(this.client, "Users", (AbstractPolicyRepresentation)policy, scopes);
    }
}

