/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class GroupResourceTypeFilteringTest
extends AbstractPermissionTest {
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;
    @InjectUser(ref="alice")
    ManagedUser userAlice;

    @BeforeEach
    public void onBeforeEach() {
        for (int i = 0; i < 50; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group-" + i);
            try (Response response = this.realm.admin().groups().add(group);){
                group.setId(ApiUtil.getCreatedId((Response)response));
            }
            GroupResource groupResource = this.realm.admin().groups().group(group.getId());
            for (int j = 0; j < 5; ++j) {
                GroupRepresentation subGroup = new GroupRepresentation();
                subGroup.setName("subgroup-" + i + "." + j);
                groupResource.subGroup(subGroup).close();
            }
        }
    }

    @Test
    public void testViewAllGroupsUsingUserPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).groups().groups();
        Assertions.assertTrue((boolean)search.isEmpty());
        UserPolicyRepresentation policy = GroupResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        GroupResourceTypeFilteringTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)policy, Set.of("view"));
        search = this.realmAdminClient.realm(this.realm.getName()).groups().groups();
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)50, (int)search.size());
    }

    @Test
    public void testDeniedResourcesPrecedenceOverGrantedResources() {
        UserPolicyRepresentation policy = GroupResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        GroupResourceTypeFilteringTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)policy, Set.of("view"));
        List search = this.realmAdminClient.realm(this.realm.getName()).groups().groups();
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)50, (int)search.size());
        UserPolicyRepresentation notMyAdminPolicy = GroupResourceTypeFilteringTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        Set<String> notAllowedGroups = search.stream().filter(g -> Set.of("group-0", "group-15", "group-30", "group-45").contains(g.getName())).map(GroupRepresentation::getId).collect(Collectors.toSet());
        Assertions.assertFalse((boolean)notAllowedGroups.isEmpty());
        this.createPermission(this.client, notAllowedGroups, "Groups", Set.of("view"), new AbstractPolicyRepresentation[]{notMyAdminPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).groups().groups();
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertTrue((boolean)search.stream().map(GroupRepresentation::getId).noneMatch(notAllowedGroups::contains));
    }

    @Test
    public void testFilterSubGroups() {
        UserPolicyRepresentation policy = GroupResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        GroupResourceTypeFilteringTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)policy, Set.of("view"));
        List search = this.realmAdminClient.realm(this.realm.getName()).groups().groups("group-0", Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
        GroupRepresentation parentGroup = (GroupRepresentation)search.get(0);
        Assertions.assertEquals((int)5, (int)parentGroup.getSubGroups().size());
        Assertions.assertEquals((long)5L, (Long)parentGroup.getSubGroupCount());
        GroupRepresentation subGroup = parentGroup.getSubGroups().stream().filter(group -> group.getName().equals("subgroup-0.0")).findFirst().orElse(null);
        Assertions.assertNotNull((Object)subGroup);
        UserPolicyRepresentation notMyAdminPolicy = GroupResourceTypeFilteringTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, subGroup.getId(), "Groups", Set.of("view"), new AbstractPolicyRepresentation[]{notMyAdminPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).groups().groups("subgroup-0.0", Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertTrue((boolean)search.isEmpty());
        List subGroups = this.realmAdminClient.realm(this.realm.getName()).groups().group(parentGroup.getId()).getSubGroups(Integer.valueOf(-1), Integer.valueOf(-1), Boolean.valueOf(false));
        Assertions.assertEquals((int)4, (int)subGroups.size());
        Assertions.assertTrue((boolean)subGroups.stream().map(GroupRepresentation::getId).noneMatch(subGroup.getId()::equals));
        search = this.realmAdminClient.realm(this.realm.getName()).groups().groups("group-0", Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertFalse((boolean)search.isEmpty());
        parentGroup = (GroupRepresentation)search.get(0);
        Assertions.assertEquals((int)4, (int)parentGroup.getSubGroups().size());
        Assertions.assertEquals((long)4L, (Long)parentGroup.getSubGroupCount());
        subGroups = this.realmAdminClient.realm(this.realm.getName()).groups().group(parentGroup.getId()).getSubGroups(subGroup.getName(), Boolean.valueOf(true), Integer.valueOf(-1), Integer.valueOf(-1), Boolean.valueOf(true));
        Assertions.assertTrue((boolean)subGroups.isEmpty());
        subGroups = this.realmAdminClient.realm(this.realm.getName()).groups().group(parentGroup.getId()).getSubGroups("subgroup-0.1", Boolean.valueOf(true), Integer.valueOf(-1), Integer.valueOf(-1), Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)subGroups.size());
        Assertions.assertEquals((int)5, (int)this.realm.admin().groups().group(parentGroup.getId()).getSubGroups(Integer.valueOf(-1), Integer.valueOf(-1), Boolean.valueOf(false)).size());
        Assertions.assertEquals((int)5, (int)this.realm.admin().groups().group(parentGroup.getId()).getSubGroups(null, Boolean.valueOf(false), Integer.valueOf(-1), Integer.valueOf(-1), Boolean.valueOf(false)).size());
        Assertions.assertEquals((long)5L, (Long)this.realm.admin().groups().group(parentGroup.getId()).toRepresentation().getSubGroupCount());
    }

    @Test
    public void testGetUserGroups() {
        GroupRepresentation parentGroup = (GroupRepresentation)this.realm.admin().groups().groups("group-0", Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        GroupRepresentation subGroup = (GroupRepresentation)this.realm.admin().groups().groups("subgroup-1.0", Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        this.userAlice.admin().joinGroup(parentGroup.getId());
        this.userAlice.admin().joinGroup(subGroup.getId());
        List groups = this.userAlice.admin().groups();
        Assertions.assertEquals((int)2, (int)groups.size());
        UserPolicyRepresentation policy = GroupResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, this.userAlice.getId(), "Users", Set.of("view"), new AbstractPolicyRepresentation[]{policy});
        this.createPermission(this.client, subGroup.getId(), "Groups", Set.of("view"), new AbstractPolicyRepresentation[]{policy});
        groups = this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).groups();
        Assertions.assertEquals((int)1, (int)groups.size());
        groups = this.userAlice.admin().groups();
        Assertions.assertEquals((int)2, (int)groups.size());
    }
}

