/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ScopePermissionResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class GroupResourceTypePermissionTest
extends AbstractPermissionTest {
    @BeforeEach
    public void onBefore() {
        UserPolicyRepresentation policy = new UserPolicyRepresentation();
        policy.setName("User Policy");
        this.client.admin().authorization().policies().user().create(policy).close();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("MyGroup");
        this.realm.admin().groups().add(group).close();
    }

    @Test
    public void testCreateResourceTypePermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation onlyMyAdminUserPolicy = GroupResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        ScopePermissionRepresentation expected = GroupResourceTypePermissionTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, AdminPermissionsSchema.GROUPS.getScopes());
        List result = GroupResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = GroupResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.GROUPS.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)1, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)"Groups", (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testCreateResourceObjectPermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation onlyMyAdminUserPolicy = GroupResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        GroupRepresentation group = (GroupRepresentation)this.realm.admin().groups().groups().get(0);
        ScopePermissionRepresentation expected = this.createPermission(this.client, group.getId(), "Groups", (Set<String>)AdminPermissionsSchema.GROUPS.getScopes(), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        List result = GroupResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = GroupResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.GROUPS.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)1, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)group.getName(), (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testRemoveGroup() {
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("topGroup");
        try (Response response = this.realm.admin().groups().add(topGroup);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            topGroup.setId(ApiUtil.handleCreatedResponse((Response)response));
            this.realm.cleanup().add(r -> r.groups().group(topGroup.getId()).remove());
        }
        GroupRepresentation topGroup1 = new GroupRepresentation();
        topGroup1.setName("topGroup1");
        try (Response response = this.realm.admin().groups().add(topGroup1);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            topGroup1.setId(ApiUtil.handleCreatedResponse((Response)response));
        }
        this.createGroupPolicy("Only topGroup or topGroup1 Group Policy", topGroup.getId(), topGroup1.getId());
        this.createGroupPolicy("Only topGroup1 Group Policy", topGroup1.getId());
        this.createGroupPermission(topGroup, topGroup1);
        this.createGroupPermission(topGroup1);
        List policies = this.getPolicies().policies(null, "Only", "group", null, null, null, null, null, null, null);
        MatcherAssert.assertThat((Object)policies, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(0)).getConfig().get("groups")), (Matcher)Matchers.containsString((String)topGroup1.getId()));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(1)).getConfig().get("groups")), (Matcher)Matchers.containsString((String)topGroup1.getId()));
        List permissions = GroupResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)topGroup1.getId()));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(1)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)topGroup1.getId()));
        this.realm.admin().groups().group(topGroup1.getId()).remove();
        GroupPolicyRepresentation groupPolicy = this.getPolicies().group().findByName("Only topGroup or topGroup1 Group Policy");
        MatcherAssert.assertThat((Object)groupPolicy, (Matcher)Matchers.notNullValue());
        Set groupIds = groupPolicy.getGroups().stream().map(GroupPolicyRepresentation.GroupDefinition::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat(groupIds, (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{topGroup1.getId()})));
        GroupPolicyRepresentation groupPolicy1 = this.getPolicies().group().findByName("Only topGroup1 Group Policy");
        MatcherAssert.assertThat((Object)groupPolicy1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(groupPolicy1.getGroups().stream().map(GroupPolicyRepresentation.GroupDefinition::getId).collect(Collectors.toSet()), (Matcher)Matchers.empty());
        permissions = GroupResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)topGroup1.getId())));
    }

    private ScopePermissionRepresentation createGroupPermission(GroupRepresentation ... groups) {
        ScopePermissionRepresentation permission = AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.GROUPS.getType()).resources(Arrays.stream(groups).map(GroupRepresentation::getId).collect(Collectors.toSet())).scopes(AdminPermissionsSchema.GROUPS.getScopes()).addPolicies(List.of("User Policy")).build();
        GroupResourceTypePermissionTest.createPermission(this.client, permission);
        return permission;
    }

    private GroupPolicyRepresentation createGroupPolicy(String name, String ... groupIds) {
        GroupPolicyRepresentation policy = new GroupPolicyRepresentation();
        policy.setName(name);
        policy.addGroup(groupIds);
        policy.setLogic(Logic.POSITIVE);
        try (Response response = this.client.admin().authorization().policies().group().create(policy);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            this.realm.cleanup().add(r -> {
                GroupPolicyRepresentation groupPolicy = this.client.admin().authorization().policies().group().findByName(name);
                if (groupPolicy != null) {
                    this.client.admin().authorization().policies().group().findById(groupPolicy.getId()).remove();
                }
            });
        }
        return policy;
    }
}

