/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class PermissionRESTTest
extends AbstractPermissionTest {
    @InjectUser(ref="alice")
    private ManagedUser userAlice;

    @Test
    public void testPreventDeletingAdminPermissionsClient() {
        try {
            this.client.admin().remove();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
    }

    @Test
    public void testManageNotAllowedForAdminPermissionsClient() {
        ClientRepresentation representation = this.client.admin().toRepresentation();
        Assertions.assertFalse((boolean)((Boolean)representation.getAccess().get("manage")));
        Assertions.assertFalse((boolean)((Boolean)representation.getAccess().get("configure")));
    }

    @Test
    public void resourceServerTest() {
        ResourceServerRepresentation rep = new ResourceServerRepresentation();
        rep.setPolicyEnforcementMode(PolicyEnforcementMode.DISABLED);
        rep.setDecisionStrategy(DecisionStrategy.CONSENSUS);
        try {
            this.client.admin().authorization().update(rep);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
        try {
            this.client.admin().authorization().exportSettings();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
        try {
            this.client.admin().authorization().importSettings(rep);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
    }

    @Test
    public void scopesTest() {
        ScopeRepresentation manage = this.client.admin().authorization().scopes().findByName("manage");
        MatcherAssert.assertThat((Object)manage, (Matcher)Matchers.notNullValue());
        ScopeRepresentation customScope = new ScopeRepresentation();
        customScope.setName("custom");
        try (Response response = this.client.admin().authorization().scopes().create(customScope);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        }
        try {
            this.client.admin().authorization().scopes().scope(manage.getId()).update(manage);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
        try {
            this.client.admin().authorization().scopes().scope(manage.getId()).remove();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
    }

    @Test
    public void resourcesTest() {
        ResourceRepresentation resourceRep = new ResourceRepresentation("resource-1", new String[]{"manage"});
        resourceRep.setType(AdminPermissionsSchema.USERS.getType());
        try (Response response = this.client.admin().authorization().resources().create(resourceRep);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        }
        ResourceRepresentation usersResource = this.client.admin().authorization().resources().searchByName(AdminPermissionsSchema.USERS.getType());
        MatcherAssert.assertThat((Object)usersResource, (Matcher)Matchers.notNullValue());
        try {
            this.client.admin().authorization().resources().resource(usersResource.getId()).update(resourceRep);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
        try {
            this.client.admin().authorization().resources().resource(usersResource.getId()).remove();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
        PermissionRESTTest.createPermission(this.client, AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.USERS.getType()).resources(Set.of(this.userAlice.getUsername())).scopes(AdminPermissionsSchema.USERS.getScopes()).build());
        ResourceRepresentation userAliceResourceRep = this.client.admin().authorization().resources().searchByName(this.userAlice.getId());
        MatcherAssert.assertThat((Object)userAliceResourceRep, (Matcher)Matchers.notNullValue());
        String aliceResourceId = userAliceResourceRep.getId();
        try {
            this.client.admin().authorization().resources().resource(aliceResourceId).update(userAliceResourceRep);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
        try {
            this.client.admin().authorization().resources().resource(aliceResourceId).remove();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(BadRequestException.class));
        }
    }

    @Test
    public void permissionsTest() {
        PermissionRESTTest.createPermission(this.client, AbstractPermissionTest.PermissionBuilder.create().scopes(AdminPermissionsSchema.USERS.getScopes()).build(), Response.Status.BAD_REQUEST);
        PermissionRESTTest.createPermission(this.client, AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.USERS.getType()).build(), Response.Status.BAD_REQUEST);
        PermissionRESTTest.createPermission(this.client, AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.USERS.getType()).scopes(Set.of("edit", "write", "token-exchange")).build(), Response.Status.BAD_REQUEST);
    }
}

