/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class RoleResourceTypeEvaluationTest
extends AbstractPermissionTest {
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;
    private final String rolesType = AdminPermissionsSchema.ROLES.getType();

    @Test
    public void testMapRoleClientScopeAllRoles() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientRepresentation myclient = (ClientRepresentation)this.realm.admin().clients().findByClientId("myclient").get(0);
        UserPolicyRepresentation onlyMyAdminUserPolicy = RoleResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        RoleResourceTypeEvaluationTest.createAllPermission(this.client, AdminPermissionsSchema.CLIENTS.getType(), (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, Set.of("view"));
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("my-client-scope");
        clientScope.setProtocol("openid-connect");
        try (Response response = this.realm.admin().clientScopes().create(clientScope);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            clientScope.setId(ApiUtil.handleCreatedResponse((Response)response));
            this.realm.cleanup().add(r -> r.clientScopes().get(clientScope.getId()).remove());
        }
        ClientScopeResource clientScopeResource = this.realmAdminClient.realm(this.realm.getName()).clientScopes().get(clientScope.getId());
        List availableRoles = clientScopeResource.getScopeMappings().realmLevel().listAvailable();
        MatcherAssert.assertThat((Object)availableRoles, (Matcher)Matchers.empty());
        RoleResourceTypeEvaluationTest.createAllPermission(this.client, this.rolesType, (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, Set.of("map-role-client-scope"));
        availableRoles = clientScopeResource.getScopeMappings().realmLevel().listAvailable();
        MatcherAssert.assertThat((Object)availableRoles, (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void testMapCompositeRoleAllRoles() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        RoleRepresentation role = new RoleRepresentation();
        role.setName("myRole");
        this.realm.admin().roles().create(role);
        this.realm.cleanup().add(r -> r.roles().get("myRole").remove());
        RoleRepresentation subRole = new RoleRepresentation();
        subRole.setName("mySubRole");
        this.realm.admin().roles().create(subRole);
        subRole = this.realm.admin().roles().get("mySubRole").toRepresentation();
        this.realm.cleanup().add(r -> r.roles().get("mySubRole").remove());
        try {
            this.realmAdminClient.realm(this.realm.getName()).roles().get("myRole").addComposites(List.of(subRole));
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        String clientId = ((ClientRepresentation)this.realm.admin().clients().findByClientId("realm-management").get(0)).getId();
        RoleRepresentation manageRealmRole = this.realm.admin().clients().get(clientId).roles().get("manage-realm").toRepresentation();
        this.realm.admin().users().get(myadmin.getId()).roles().clientLevel(clientId).add(List.of(manageRealmRole));
        this.realmAdminClient.tokenManager().grantToken();
        UserPolicyRepresentation onlyMyAdminUserPolicy = RoleResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        RoleResourceTypeEvaluationTest.createAllPermission(this.client, this.rolesType, (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, Set.of("map-role-composite"));
        this.realmAdminClient.realm(this.realm.getName()).roles().get("myRole").addComposites(List.of(subRole));
    }

    @Test
    public void testMapRoleOnlySpecificRole() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        RoleRepresentation role = new RoleRepresentation();
        role.setName("myRole");
        this.realm.admin().roles().create(role);
        role = this.realm.admin().roles().get("myRole").toRepresentation();
        this.realm.cleanup().add(r -> r.roles().get("myRole").remove());
        RoleRepresentation otherRole = new RoleRepresentation();
        otherRole.setName("otherRole");
        this.realm.admin().roles().create(otherRole);
        otherRole = this.realm.admin().roles().get("otherRole").toRepresentation();
        this.realm.cleanup().add(r -> r.roles().get("otherRole").remove());
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(myadmin.getId()).roles().realmLevel().add(List.of(role));
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation onlyMyAdminUserPolicy = RoleResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, role.getId(), this.rolesType, Set.of("map-role"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        this.createPermission(this.client, myadmin.getId(), "Users", Set.of("map-roles"), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        this.realmAdminClient.realm(this.realm.getName()).users().get(myadmin.getId()).roles().realmLevel().add(List.of(role));
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(myadmin.getId()).roles().realmLevel().add(List.of(otherRole));
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
    }

    @Test
    public void testMappingAdminRoles() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        ClientRepresentation realmManagement = (ClientRepresentation)this.realm.admin().clients().findByClientId("realm-management").get(0);
        RoleRepresentation createClientRole = this.realm.admin().clients().get(realmManagement.getId()).roles().get("create-client").toRepresentation();
        UserPolicyRepresentation onlyMyAdminUserPolicy = RoleResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        RoleResourceTypeEvaluationTest.createAllPermission(this.client, "Clients", (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, Set.of("map-roles"));
        RoleResourceTypeEvaluationTest.createAllPermission(this.client, "Users", (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, Set.of("map-roles"));
        RoleRepresentation role = new RoleRepresentation();
        role.setName("myRole");
        ClientRepresentation myclient = (ClientRepresentation)this.realm.admin().clients().findByClientId("myclient").get(0);
        this.realm.admin().clients().get(myclient.getId()).roles().create(role);
        role = this.realm.admin().clients().get(myclient.getId()).roles().get("myRole").toRepresentation();
        this.realmAdminClient.realm(this.realm.getName()).users().get(myadmin.getId()).roles().clientLevel(myclient.getId()).add(List.of(role));
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(myadmin.getId()).roles().clientLevel(realmManagement.getId()).add(List.of(createClientRole));
            Assert.fail((String)"Expected exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
    }
}

