/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ScopePermissionResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class RoleResourceTypePermissionTest
extends AbstractPermissionTest {
    @InjectClient(ref="testClient")
    ManagedClient testClient;

    @BeforeEach
    public void onBefore() {
        UserPolicyRepresentation policy = new UserPolicyRepresentation();
        policy.setName("User Policy");
        this.client.admin().authorization().policies().user().create(policy).close();
    }

    @Test
    public void testCreateResourceTypePermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation onlyMyAdminUserPolicy = RoleResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        ScopePermissionRepresentation expected = RoleResourceTypePermissionTest.createAllPermission(this.client, "Roles", (AbstractPolicyRepresentation)onlyMyAdminUserPolicy, AdminPermissionsSchema.ROLES.getScopes());
        List result = RoleResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = RoleResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.ROLES.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)1, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)"Roles", (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testCreateResourceObjectPermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation onlyMyAdminUserPolicy = RoleResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        RoleRepresentation role = (RoleRepresentation)this.realm.admin().roles().list().get(0);
        ScopePermissionRepresentation expected = this.createPermission(this.client, role.getId(), "Roles", (Set<String>)AdminPermissionsSchema.ROLES.getScopes(), new AbstractPolicyRepresentation[]{onlyMyAdminUserPolicy});
        List result = RoleResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = RoleResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.ROLES.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)1, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)role.getName(), (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testRemoveRole() {
        RoleRepresentation realmRole = new RoleRepresentation();
        realmRole.setName("realmRole");
        try {
            this.realm.admin().roles().create(realmRole);
            realmRole.setId(this.realm.admin().roles().get(realmRole.getName()).toRepresentation().getId());
        }
        finally {
            this.realm.cleanup().add(r -> r.roles().deleteRole(realmRole.getName()));
        }
        RoleRepresentation clientRole = new RoleRepresentation();
        clientRole.setName("clientRole");
        clientRole.setClientRole(Boolean.TRUE);
        clientRole.setContainerId(this.testClient.getId());
        this.realm.admin().roles().create(clientRole);
        clientRole.setId(this.realm.admin().roles().get(clientRole.getName()).toRepresentation().getId());
        this.createRolePolicy("Only realmRole or clientRole Role Policy", realmRole.getId(), clientRole.getId());
        this.createRolePolicy("Only clientRole Role Policy", clientRole.getId());
        this.createRolePermission(realmRole, clientRole);
        this.createRolePermission(clientRole);
        List policies = this.getPolicies().policies(null, "Only", "role", null, null, null, null, null, null, null);
        MatcherAssert.assertThat((Object)policies, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(0)).getConfig().get("roles")), (Matcher)Matchers.containsString((String)clientRole.getId()));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(1)).getConfig().get("roles")), (Matcher)Matchers.containsString((String)clientRole.getId()));
        List permissions = RoleResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)clientRole.getId()));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(1)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)clientRole.getId()));
        this.realm.admin().roles().get(clientRole.getName()).remove();
        RolePolicyRepresentation rolePolicy = this.getPolicies().role().findByName("Only realmRole or clientRole Role Policy");
        MatcherAssert.assertThat((Object)rolePolicy, (Matcher)Matchers.notNullValue());
        Set roleIds = rolePolicy.getRoles().stream().map(RolePolicyRepresentation.RoleDefinition::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat(roleIds, (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{clientRole.getId()})));
        RolePolicyRepresentation rolePolicy1 = this.getPolicies().role().findByName("Only clientRole Role Policy");
        MatcherAssert.assertThat((Object)rolePolicy1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(rolePolicy1.getRoles().stream().map(RolePolicyRepresentation.RoleDefinition::getId).collect(Collectors.toSet()), (Matcher)Matchers.empty());
        permissions = RoleResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)clientRole.getId())));
    }

    private ScopePermissionRepresentation createRolePermission(RoleRepresentation ... roles) {
        ScopePermissionRepresentation permission = AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.ROLES.getType()).resources(Arrays.stream(roles).map(RoleRepresentation::getId).collect(Collectors.toSet())).scopes(AdminPermissionsSchema.ROLES.getScopes()).addPolicies(List.of("User Policy")).build();
        RoleResourceTypePermissionTest.createPermission(this.client, permission);
        return permission;
    }

    private RolePolicyRepresentation createRolePolicy(String name, String ... roleIds) {
        RolePolicyRepresentation policy = new RolePolicyRepresentation();
        policy.setName(name);
        for (String roleId : roleIds) {
            policy.addRole(roleId);
        }
        policy.setLogic(Logic.POSITIVE);
        try (Response response = this.client.admin().authorization().policies().role().create(policy);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
            this.realm.cleanup().add(r -> {
                RolePolicyRepresentation rolePolicy = this.client.admin().authorization().policies().role().findByName(name);
                if (rolePolicy != null) {
                    this.client.admin().authorization().policies().role().findById(rolePolicy.getId()).remove();
                }
            });
        }
        return policy;
    }
}

