/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.ForbiddenException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.AbstractUserRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionEffect;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.PolicyEvaluationResponse;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class UserResourceTypeEvaluationSpecTest
extends AbstractPermissionTest {
    @InjectUser(ref="alice")
    ManagedUser userAlice;
    @InjectUser(ref="bob")
    ManagedUser userBob;
    @InjectUser(ref="jdoe")
    ManagedUser userJdoe;
    @InjectUser(ref="tom")
    ManagedUser userTom;
    @InjectUser(ref="mary")
    ManagedUser userMary;
    ManagedUser myadmin;
    private List<ManagedUser> ALL_GROUP_MEMBERS;
    private List<ManagedUser> ALL_USERS;
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;
    private UserPolicyRepresentation allowPolicy;
    private UserPolicyRepresentation denyPolicy;

    @BeforeEach
    public void onBefore() {
        HashMap<String, List<ManagedUser>> groupMembers = new HashMap<String, List<ManagedUser>>();
        groupMembers.put("group-0", List.of(this.userAlice));
        groupMembers.put("group-1", List.of(this.userBob));
        groupMembers.put("group-2", List.of(this.userMary, this.userTom));
        for (Map.Entry group : groupMembers.entrySet()) {
            String name = (String)group.getKey();
            GroupRepresentation rep = new GroupRepresentation();
            rep.setName(name);
            this.realm.admin().groups().add(rep).close();
            List members = (List)group.getValue();
            for (ManagedUser member : members) {
                this.joinGroup(member, name);
            }
        }
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        this.allowPolicy = UserResourceTypeEvaluationSpecTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.denyPolicy = UserResourceTypeEvaluationSpecTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", myadmin.getId());
        this.myadmin = new ManagedUser(myadmin, this.realm.admin().users().get(myadmin.getId()));
        this.ALL_USERS = new ArrayList<ManagedUser>();
        groupMembers.values().forEach(this.ALL_USERS::addAll);
        this.ALL_USERS.add(this.myadmin);
        this.ALL_USERS.add(this.userJdoe);
        this.ALL_GROUP_MEMBERS = groupMembers.values().stream().flatMap(Collection::stream).toList();
    }

    @Test
    public void test_01() {
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_02() {
        this.allowAllGroups();
        this.assertFilter(this.ALL_GROUP_MEMBERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_03() {
        this.denyAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_04() {
        this.allowGroup("group-0");
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_05() {
        this.allowGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.ALL_GROUP_MEMBERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_06() {
        this.allowGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_07() {
        this.denyGroup("group-0");
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_08() {
        this.denyGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.userBob, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_09() {
        this.denyGroup("group-0");
        this.denyAllGroups();
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        MatcherAssert.assertThat((Object)search.isEmpty(), (Matcher)Matchers.is((Object)true));
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_10() {
        this.allowAllUsers();
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_11() {
        this.allowAllUsers();
        this.allowAllGroups();
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_12() {
        this.allowAllUsers();
        this.denyAllGroups();
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        MatcherAssert.assertThat(search.stream().map(AbstractUserRepresentation::getUsername).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.userJdoe.getUsername(), "myadmin"}));
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_13() {
        this.allowAllUsers();
        this.allowGroup("group-0");
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_14() {
        this.allowAllUsers();
        this.allowGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_15() {
        this.allowAllUsers();
        this.allowGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(this.userAlice, this.userJdoe, this.myadmin);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_16() {
        this.allowAllUsers();
        this.denyGroup("group-0");
        this.assertFilter(this.userBob, this.userJdoe, this.myadmin, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_17() {
        this.allowAllUsers();
        this.denyGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.userBob, this.userJdoe, this.myadmin, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_18() {
        this.allowAllUsers();
        this.denyGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(this.userJdoe, this.myadmin);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_19() {
        this.denyAllUsers();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_20() {
        this.denyAllUsers();
        this.allowAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_21() {
        this.denyAllUsers();
        this.denyAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_22() {
        this.denyAllUsers();
        this.allowGroup("group-0");
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_23() {
        this.denyAllUsers();
        this.allowGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_24() {
        this.denyAllUsers();
        this.allowGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_25() {
        this.denyAllUsers();
        this.denyGroup("group-0");
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_26() {
        this.denyAllUsers();
        this.denyGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_27() {
        this.denyAllUsers();
        this.denyGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_28() {
        this.allowUser(this.userAlice);
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_29() {
        this.allowUser(this.userAlice);
        this.allowAllGroups();
        this.assertFilter(this.userAlice, this.userBob, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_30() {
        this.allowUser(this.userAlice);
        this.denyAllGroups();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_31() {
        this.allowUser(this.userAlice);
        this.allowGroup("group-1");
        this.assertFilter(this.userAlice, this.userBob);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_32() {
        this.allowUser(this.userAlice);
        this.allowGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.userAlice, this.userBob, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_33() {
        this.allowUser(this.userAlice);
        this.allowGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_33_a() {
        this.allowUser(this.userAlice);
        this.allowGroup("group-1");
        this.denyAllGroups();
        this.assertFilter(this.userAlice, this.userBob);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_34() {
        this.allowUser(this.userAlice);
        this.denyGroup("group-0");
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_35() {
        this.allowUser(this.userAlice);
        this.denyGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.userBob, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_35_a() {
        this.allowUser(this.userAlice);
        this.denyGroup("group-1");
        this.allowAllGroups();
        this.assertFilter(this.userAlice, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_36() {
        this.allowUser(this.userAlice);
        this.denyGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_37() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_38() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.allowAllGroups();
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_39() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.denyAllGroups();
        this.assertFilter(this.userAlice, this.userJdoe, this.myadmin);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_40() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.allowGroup("group-0");
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_40_a() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.allowGroup("group-1");
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_41() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.allowGroup("group-1");
        this.allowAllGroups();
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_42() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.allowGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(this.userAlice, this.userJdoe, this.myadmin);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_42_a() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.allowGroup("group-1");
        this.assertFilter(this.ALL_USERS);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_43() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.denyGroup("group-0");
        this.assertFilter(this.userBob, this.userJdoe, this.myadmin, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_44() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.denyGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.userBob, this.userJdoe, this.myadmin, this.userTom, this.userMary);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_45() {
        this.allowUser(this.userAlice);
        this.allowAllUsers();
        this.denyGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(this.userJdoe, this.myadmin);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, true);
    }

    @Test
    public void test_46() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_47() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.allowAllGroups();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_48() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.denyAllGroups();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_49() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.allowGroup("group-0");
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_49_a() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.allowGroup("group-1");
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_50() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.allowGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_51() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.allowGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_52() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.denyGroup("group-0");
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_52_a() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.denyGroup("group-1");
        this.assertFilter(this.userAlice);
        this.assertUpdate(this.userAlice, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_53() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.denyGroup("group-0");
        this.allowAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_54() {
        this.allowUser(this.userAlice);
        this.denyAllUsers();
        this.denyGroup("group-0");
        this.denyAllGroups();
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_55() {
        this.allowAllUsers();
        this.denyUser(this.userAlice);
        this.denyUser(this.userJdoe);
        this.assertFilter(this.userBob, this.myadmin, this.userMary, this.userTom);
        this.assertUpdate(this.userBob, true);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_56() {
        this.allowUser(this.userJdoe);
        this.denyUser(this.userBob);
        this.assertFilter(this.userJdoe);
        this.assertUpdate(this.userJdoe, true);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userAlice, false);
    }

    @Test
    public void test_57() {
        this.denyUser(this.userAlice);
        this.denyUser(this.userJdoe);
        this.assertFilter(new ManagedUser[0]);
        this.assertUpdate(this.userBob, false);
        this.assertUpdate(this.userAlice, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_58() {
        this.denyUser(this.userTom);
        this.allowGroup("group-2");
        this.assertFilter(this.userMary);
        this.assertUpdate(this.userMary, true);
        this.assertUpdate(this.userTom, false);
        this.assertUpdate(this.userJdoe, false);
    }

    @Test
    public void test_59() {
        this.allowAllUsers();
        this.denyUser(this.userTom);
        this.allowGroup("group-1");
        this.assertFilter(this.userAlice, this.userBob, this.userMary, this.userJdoe, this.myadmin);
        this.assertUpdate(this.userMary, true);
        this.assertUpdate(this.userJdoe, true);
        this.assertUpdate(this.userTom, false);
    }

    @Test
    public void test_60() {
        this.allowAllUsers();
        this.denyUser(this.userTom);
        this.allowGroup("group-1");
        this.denyGroup("group-2");
        this.assertFilter(this.userAlice, this.userBob, this.userJdoe, this.myadmin);
        this.assertUpdate(this.userJdoe, true);
        this.assertUpdate(this.userMary, false);
        this.assertUpdate(this.userTom, false);
    }

    private void denyUser(ManagedUser user) {
        this.createPermission(this.client, user.getId(), "Users", Set.of("view", "manage"), new AbstractPolicyRepresentation[]{this.denyPolicy});
    }

    private void allowAllUsers() {
        UserResourceTypeEvaluationSpecTest.createAllPermission(this.client, "Users", (AbstractPolicyRepresentation)this.allowPolicy, Set.of("view", "manage"));
    }

    private void allowUser(ManagedUser user) {
        this.createPermission(this.client, user.getId(), "Users", Set.of("view", "manage"), new AbstractPolicyRepresentation[]{this.allowPolicy});
    }

    private void denyAllUsers() {
        UserResourceTypeEvaluationSpecTest.createAllPermission(this.client, "Users", (AbstractPolicyRepresentation)this.denyPolicy, Set.of("view", "manage"));
    }

    private void allowGroup(String name) {
        this.createPermission(this.client, this.getGroup(name).getId(), "Groups", Set.of("view-members", "manage-members"), new AbstractPolicyRepresentation[]{this.allowPolicy});
    }

    private void denyAllGroups() {
        UserResourceTypeEvaluationSpecTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)this.denyPolicy, Set.of("view-members", "manage-members"));
    }

    private void allowAllGroups() {
        UserResourceTypeEvaluationSpecTest.createAllPermission(this.client, "Groups", (AbstractPolicyRepresentation)this.allowPolicy, Set.of("view-members", "manage-members"));
    }

    private void denyGroup(String groupName) {
        this.createPermission(this.client, this.getGroup(groupName).getId(), "Groups", Set.of("view-members", "manage-members"), new AbstractPolicyRepresentation[]{this.denyPolicy});
    }

    private GroupRepresentation getGroup(String groupName) {
        return (GroupRepresentation)this.realm.admin().groups().groups(groupName, Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
    }

    private void joinGroup(ManagedUser user, String groupName) {
        String groupId = this.getGroup(groupName).getId();
        this.realm.admin().users().get(user.getId()).joinGroup(groupId);
    }

    private void assertUpdate(ManagedUser user, boolean success) {
        if (success) {
            this.realmAdminClient.realm(this.realm.getName()).users().get(user.getId()).update(user.admin().toRepresentation());
            this.assertEvaluation(user, DecisionEffect.PERMIT, Set.of("view", "manage"));
        } else {
            try {
                this.realmAdminClient.realm(this.realm.getName()).users().get(user.getId()).update(user.admin().toRepresentation());
                Assertions.fail((String)"Should have thrown an exception");
            }
            catch (ForbiddenException expected) {
                this.assertEvaluation(user, DecisionEffect.DENY, Set.of("view", "manage"));
            }
        }
    }

    private void assertEvaluation(ManagedUser managedUser, DecisionEffect effect, Set<String> grantedScopes) {
        PolicyEvaluationRequest request = new PolicyEvaluationRequest();
        request.setUserId(((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        request.setResourceType("Users");
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(managedUser.getId());
        request.setResources(List.of(resource));
        PolicyEvaluationResponse response = this.client.admin().authorization().policies().evaluate(request);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)effect));
        if (response.getResults().isEmpty()) {
            return;
        }
        PolicyEvaluationResponse.EvaluationResultRepresentation result = (PolicyEvaluationResponse.EvaluationResultRepresentation)response.getResults().get(0);
        if (!grantedScopes.isEmpty()) {
            if (DecisionEffect.PERMIT.equals((Object)effect)) {
                MatcherAssert.assertThat((Object)result.getResource().getName(), (Matcher)Matchers.is((Object)(managedUser.getUsername() + " with scopes " + String.valueOf(grantedScopes.stream().sorted().toList()))));
                MatcherAssert.assertThat(result.getAllowedScopes().stream().map(ScopeRepresentation::getName).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])grantedScopes.toArray(new String[0])));
                MatcherAssert.assertThat(result.getDeniedScopes().stream().map(ScopeRepresentation::getName).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])AdminPermissionsSchema.USERS.getScopes().stream().filter(Predicate.not(grantedScopes::contains)).toArray()));
            } else {
                MatcherAssert.assertThat(result.getDeniedScopes().stream().map(ScopeRepresentation::getName).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])AdminPermissionsSchema.USERS.getScopes().toArray()));
            }
        }
    }

    private void assertFilter(List<ManagedUser> expected) {
        this.assertFilter(expected.toArray(new ManagedUser[0]));
    }

    private void assertFilter(ManagedUser ... expected) {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        if (expected.length == 0) {
            MatcherAssert.assertThat((Object)search.isEmpty(), (Matcher)Matchers.is((Object)true));
        } else {
            MatcherAssert.assertThat(search.stream().map(AbstractUserRepresentation::getUsername).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])Stream.of(expected).map(ManagedUser::getUsername).toArray()));
        }
    }
}

